/*
 *	MlpDeclaration.h
 *		version1.11.0
 */
/*
Copyright(c)2024 ЃgXgE\tgEFAEVXe, All Rights Reserved.
*/

#ifndef	MLP_DECLARATION_H
#define	MLP_DECLARATION_H

#include <time.h>
#include <Windows.h>

typedef	void* MlpStampData;

typedef enum MlpPictureOpt {
	MLP_PICTURE_RGB = 0,
	MLP_PICTURE_GRAY,
	MLP_PICTURE_DITHER,
	MLP_PICTURE_BW,
	MLP_PICTURE_FAXG3,
	MLP_PICTURE_FAXG4,

	MLP_COMPRESS_NONE,				/*TIFFϊ̏ꍇɈkȂ*/
	MLP_COMPRESS_JPEG,				/*TIFFϊ̏ꍇJPEGk*/
	MLP_COMPRESS_DEFLATE,			/*TIFFϊ̏ꍇDeflatek*/
	MLP_COMPRESS_LZW,				/*TIFFϊ̏ꍇLZWk*/

	MLP_JPEG_QUALITY,				/*JPEGk̉摜i*/

	MLP_RESOLUTION_DPI,				/*XDPI,YDPIol̉𑜓x*/
	MLP_RESOLUTION_XDPI,			/*XDPI 𑜓x*/
	MLP_RESOLUTION_YDPI,			/*YDPI 𑜓x*/
	MLP_CANVAS_SIZE,				/*LoXTCY XYow*/
	MLP_CANVAS_XSIZE,				/*LoXTCY X-݂̂w*/
	MLP_CANVAS_YSIZE,				/*LoXTCY Y-݂̂w*/
	MLP_PICTURE_XSIZE,				/*_TCYw*/
	MLP_PICTURE_YSIZE,				/*_TCYw*/
	MLP_PICTURE_SIZE_UNIT,			/*_TCY̒P*/
	MLP_PICTURE_USE_MEDIABOX=20,	/*y[W̋EMediaBoxɂ*/
	MLP_PICTURE_USE_CROPBOX=21,		/*y[W̋ECropBoxɂ*/
	MLP_PICTURE_USE_BLEEDBOX=22,	/*y[W̋EBleedBoxɂ*/
	MLP_PICTURE_USE_TRIMBOX=23,		/*y[W̋ETrimBoxɂ*/
	MLP_PICTURE_USE_ARTBOX=24,		/*y[W̋EArtBoxɂ*/
	MLP_PIXEL_SIZE_X=25,			/*sNZPʂ̉摜*/
	MLP_PIXEL_SIZE_Y,				/*sNZPʂ̉摜*/
	MLP_FILL_PATH_AA,				/*tBpX̃A`ACAX MLP_GRAPHIC_AA̓ɕύX*/
	MLP_CID_0_GLYPH,				/*R[h0̃Ot 0:notdef\, 1:(gid=0)\, 2:̕𖳎*/
	MLP_PAGE_CLIP_VALUE=30,			/*y[Ẅ̗wlsNZȗ̈ŃNbv*/
	MLP_STROKEPATH_MINIMUM_LINE_WIDTH,	/*pX̃Xg[Nɂŏw*/

	MLP_THRESHOLD_BITONAL,			/*l臒l*/
	MLP_THRESHOLD_DITHER,			/*fBU臒l*/

	MLP_PICTURE_CMYK=36,			/*CMYKF*/
	MLP_ANTIALIAS_LEVEL,			/*A`ACAX̃x*/
	MLP_DATA_COMPRESSION_LEVEL,		/*f[^k̃x*/
	MLP_PICTURE_USE_MEDIA_CROP=43,	/*y[W̋EMediaBox܂CropBox̏ɂ*/
	MLP_OCG_USAGE=44,				/*0:"view", 1:"Print", 2:"Export"*/
	MLP_XY_PIXEL_SIZE_MEM=47,		/*oオ摜f[^̕TCY (cłꂼDPIɐݒ肳)*/
//	MLP_REPLACE_TR2_MODE=48,		/*eLXgFill then Stroke`ύX 0:]ǂA1:Fill`A2:Stroke`A3:`(3͔J)*/
//	MLP_WATERMARK_TEXT_FILL = 51,	/*eLXgEH[^}[NFillō쐬*/
//	MLP_WATERMARK_TEXT_STROKE,		/*eLXgEH[^}[NStrokeō쐬*/
	MLP_BITMAP_IMG_FORMAT=53,		/*BMP`̃f[^tH[}bg 0:WindowsA1:OS/2*/
//	MLP_CANVAS_ORIGIN=54,			/*LoXTCYύX̌_w gp~2020.5.22 MLP_CANVAS_ALIGN_*ɕύX*/
	MLP_USE_ZERO_LINE_WIDTH=55,		/*[̃Xg[Nɑ΂A0:PsNZɕύX(݊)A1:A`ACAX̃xɕύX*/
	MLP_GRAPHIC_ANTIALIAS_LEVEL,	/*OtBbÑA`ACAXx*/
	MLP_TEXT_ANTIALIAS_LEVEL,		/*eLXg̃A`ACAXx*/
	MLP_BIGTIFF_CREATION_FLAG=58,	/*WTIFF܂BigTIFF摜؂ւ*/
	MLP_ROTATE_PAGE_IMAGE=60,		/*PDF̌݃y[WꎞIɉ]*/
	MLP_TRANSPARENT_PICT = 63,		/*Ȕwỉ摜𐶐*/
	MLP_CANVAS_ALIGN_CENTER=64,		/*LoXw肵ۂ̔zuʒu𒆐Sɂ*/
	MLP_CANVAS_ALIGN_UPPER_LEFT=65,	/*LoXw肵ۂ̔zuʒuɂ*/
	MLP_CANVAS_ALIGN_LOWER_LEFT=66,	/*LoXw肵ۂ̔zuʒuɂ*/
	MLP_CANVAS_ALIGN_UPPER_RIGHT=67,/*LoXw肵ۂ̔zuʒuEɂ*/
	MLP_CANVAS_ALIGN_LOWER_RIGHT=68,/*LoXw肵ۂ̔zuʒuEɂ*/
	MLP_SUPPRESS_COMPONENT=71,		/*摜̍ۂɈꕔ̃R|[lgȗ*/

	/*PDFt@C*/
	MLP_PDF_RESOLUTION=301,			/*X,Yol̉𑜓x*/
	MLP_PDF_RESOLUTION_X,			/*X 𑜓x*/
	MLP_PDF_RESOLUTION_Y,			/*Y 𑜓x*/
	MLP_PDF_IMAGE_FORMAT,			/*y[W摜i[ۂ̉摜`*/

	/*X^v*/
	STM_STAMP_INFO_CALLBACK=501,			/*X^ṽR[obNw*/
	MLP_STAMP_INFO_CALLBACK=501,			/*X^ṽR[obNw*/
	STM_STAMP_INFO_CALLBACK_NO=502,			/*X^ṽR[obN (for C#)*/
	MLP_STAMP_INFO_CALLBACK_NO=502,			/*X^ṽR[obN (for C#)*/

	MLP_STROKEPATH_ENABLE_CALLBACK=1001,	/*Xg[NpX̃R[obNLɂ*/
	MLP_TILE_IMAGE_ENABLE_CALLBACK,			/*^C摜̃R[obNLɂ*/
	MLP_TILE_MASK_IMG_ENABLE_CALLBACK,		/*^C}XN摜̃R[obNLɂ*/
	MLP_TILING_ENABLE_CALLBACK,				/*^CÕR[obNLɂ*/
	MLP_TILING_IGNORE_PROCESS,				/*^COSɖ(̋@\̓T|[gȂ)*/
	MLP_SUPPRESS_ALPHA_CHANNEL_ON_CB,		/*R[obN̉摜f[^ɃAt@`ll܂߂Ȃ*/
	MLP_PAGE_PICT_CREATED_ENABLE_CALLBACK,	/*y[W쐬̃y[W쐬ƃR[obNLɂ*/
	MLP_ONE_PAGE_CREATED_CALLBACK_ENABLE,	/*y[W쐬̃R[obNPy[WłLɂ*/
} MlpPictureOpt;

typedef enum MlpDocumentOpt {
	MLP_PERMISSION_FLAG=1201,	/*̃p[~bVtO*/
	MLP_OCG_COUNT,				/*OCG̑*/
	MLP_GLYPH_NOT_FOUND_COUNT,	/*OtłȂ*/
	MLP_PDF_AUTHOR,
	MLP_NEEDS_PASSWORD,			/*0:ÍA1:NULLpX[hŃI[vA2:pX[hKv*/
	MLP_PRINT_RESTRICTION=1207,	/*ꂽ𑜓xtOl 1:肳ꂽ(𑜓x)A0:(𑜓x)*/
	MLP_DOCUMENT_TITLE=1211,	/*PDF̃^Cg*/
	MLP_CREATION_DATE,			/**/
	MLP_MODIFICATION_DATE,		/*ŐV̕ύX*/
	MLP_ENCRYPT_VERSION,		/*̈Ío[W*/
	MLP_ENCRYPT_REVISION,		/*̈ÍrW*/
	MLP_PDF_VERSION,			/*PDF̃o[W*/
} MlpDocumentOpt;

typedef enum MlpLibraryOpt {
	MLP_THREAD_SPLIT_PAGE=102,		/*y[W𕡐̃XbhŎs*/
	MLP_THREAD_SPLIT_PAGE_COUNT,	/*y[W𕪊Xbh̐*/
	MLP_THREAD_EACH_PAGE,			/*ey[Wʂ̃XbhŎs*/
	MLP_THREAD_EACH_PAGE_COUNT,		/*iy[WXbh̐*/

	MLP_LICENSE_ERROR_INFO = 1201,	/*sCZX̏ڍ׏*/
} MlpLibraryOpt;

typedef enum MlpStampDataCmd_e {
	MLP_STAMP_PAGE = 101,
	MLP_STAMP_LAYER,
	MLP_STAMP_POS,
	MLP_STAMP_XPOS,
	MLP_STAMP_YPOS,
	MLP_STAMP_ALPHA,
	MLP_STAMP_ANNOT_CREATOR,
	MLP_STAMP_ANNOT_SUBJECT,
	MLP_STAMP_ANNOT_CREATION,
	MLP_STAMP_ANNOT_MODIFICATION,
	MLP_STAMP_ANNOT_LOCK,
	MLP_STAMP_ANNOT_RO,
	MLP_STAMP_ANNOT_BLENDMODE,

	MLP_STAMP_TEXT_VALUE = 201,
	MLP_STAMP_TEXT_FONT,
	MLP_STAMP_TEXT_FONTFILE,
	MLP_STAMP_TEXT_SIZE,
	MLP_STAMP_TEXT_BOLDEN,
	MLP_STAMP_TEXT_WMODE,
	MLP_STAMP_TEXT_COLOR,
	MLP_STAMP_TEXT_CHAR_SPACE,
	MLP_STAMP_TEXT_SCALE,
	MLP_STAMP_TEXT_EXPAND,

	MLP_STAMP_BORDER_COLOR = 301,
	MLP_STAMP_BORDER_CORNER,
	MLP_STAMP_BORDER_DASH,
	MLP_STAMP_BORDER_CLIP,

	MLP_STAMP_CIRCLE_POS = 401,
	MLP_STAMP_CIRCLE_DIAMETER,
	MLP_STAMP_CIRCLE_SUB,
	MLP_STAMP_CIRCLE_LWIDTH,
	MLP_STAMP_CIRCLE_COLOR,

	MLP_STAMP_RECTANGLE_POS = 501,
	MLP_STAMP_RECTANGLE_SIZE,
	MLP_STAMP_RECTANGLE_LWIDTH,
	MLP_STAMP_RECTANGLE_COLOR,

} MlpStampDataCmd;

typedef enum MlpPictureUnit_e {
	MLP_PICTURE_UNIT_PERCENT	= 1,		/*摜̘_TCYw肷ۂ̒Pʂp[Zg*/
	MLP_PICTURE_UNIT_INCH		= 2,		/*摜̘_TCYw肷ۂ̒PʂC`*/
	MLP_PICTURE_UNIT_MM			= 3,		/*摜̘_TCYw肷ۂ̒Pʂ~[g[mm]*/
} MlpPictureUnit;

typedef enum MlpCallbackSettingMode {
	MLP_RENDERING_CB=1,				/*y[W̉͏I / _O̊Jnm点R[obNw*/
	MLP_PROGRESS_CB,				/*w肵s̃_Oi摜i[jIƂm点R[obNw*/
	MLP_RENDERED_CB,				/*y[W̃_OIm点R[obNw*/
	MLP_PROGRESS2_CB,				/*I*/

	MLP_DRAW_STROKE_PATH_CB=101,	/*pX̃Xg[LOƂɃR[obN*/
	MLP_DEFINE_IMAGE_TILE_CB,		/*^C`ꂽƂɃR[obN*/
	MLP_DEFINE_MASK_IMAGE_TILE_CB,	/*^C̃}XN`ꂽƂɃR[obN*/
	MLP_DRAW_TILED_IMAGE_CB,		/*^COꂽ摜\tƂɃR[obN*/

} MlpCallbackSettingMode;

typedef enum MlpTiffCompressMode {
	MLP_TIFF_COMPRESS_NONE=0,		/*TIFFϊňkȂ*/
	MLP_TIFF_COMPRESS_JPEG,			/*TIFFϊJPEGk*/
	MLP_TIFF_COMPRESS_DEFLATE,		/*TIFFϊDeflatek*/
	MLP_TIFF_COMPRESS_LZW,			/*TIFFϊLZWk*/
} MlpTiffComtressMode;

typedef enum MlpConstants {
	MIN_RESOLUTION		= 10,		/*ŏ̉𑜓xύX*/
	MAX_RESOLUTION		= 10000,
	DEFAULT_RESOLUTION	= 150,
	DEFAULT_PDF_RESOLUTION	= 72,
	MIN_JPEG_QUALITY	= 24,
	MAX_JPEG_QUALITY	= 90,
	DEFAULT_JPEG_QUALITY= 75,

	MIN_PIXEL_SIZE		= 200,
	MAX_PIXEL_SIZE		= 5000000,

	DEFAULT_MULTILINE_TEXT_WIDGET_FONT_SIZE	= 55,	/*}`CTextWidget(Form Annotation)̃tHg̊TCY(l͎TCŶPO{)*/

	CONVERT_CMYK_TO_RGB		= 1,	/*CMYKRGBւ̕ϊ*/
	CONVERT_MOST_FAST		= 1,	/*ł*/
	CONVERT_FAST			= 2,	/**/
	CONVERT_BY_COLOR_PROFILE= 3,	/*J[vt@Cɂϊ*/
} MlpConstants;

typedef enum MlpCid0GlyphMode {
	SHOW_NOTDEF_GLYPH		= 0,
	REPLACE_TO_BLANK_GLYPH	= 1,
	IGNORE_CID_0_GLYPH		= 2,
} MlpCid0GlyphMode;

typedef enum MlpBoundaryBox {
	MEDIA_BOX		= 0,
	CROP_BOX		= 1,
	BLEED_BOX		= 2,
	TRIM_BOX		= 3,
	ART_BOX			= 4,
	MEDIA_CROP		= 5,
} MlpBoundaryBox;

typedef	enum MlpWatermarkLayer {
	WML_NO_PAINT	= 0,
	WML_FOREGROUND	= 1,
	WML_BACKGROUND	= 2,
} MlpWatermarkLayer;

typedef enum MlpCanvasOrigin {
	CORIGIN_CENTER		= 0,
	CORIGIN_LEFT_TOP	= 1,
	CORIGIN_LEFT_BOTTOM	= 2,
	CORIGIN_RIGHT_TOP	= 3,
	CORIGIN_RIGHT_BOTTOM= 4,
} MlpCanvasOrigin;

typedef	enum MlpOpenUsage {
	OPEN_USAGE_VIEW = 1,
	OPEN_USAGE_PRINT,
	OPEN_USAGE_EXPORT,
	OPEN_USAGE_EXTRACT,
} MlpOpenUsage;

typedef	struct MlpOcgDataRec_s	MlpOcgDataRec_t;
typedef	struct MlpOcgUsageRec_s	MlpOcgUsageRec_t;
typedef	MlpOcgDataRec_t		MlpOcgData;
typedef	MlpOcgUsageRec_t	MlpOcgUsage;

#define	MAX_OCG_NAME_LEN	100

struct MlpOcgDataRec_s {
	int		id;
	char	name[MAX_OCG_NAME_LEN+1];
	int		level;
	int		visible;
};

struct MlpOcgUsageRec_s {
	int		id;
	char	name[MAX_OCG_NAME_LEN+1];
	int		level;
	int		visible;

	/*Usage*/
	int	printState;
	int	viewState;
};

#ifndef	STROKE_PATH_ATTR_DEF
#define	STROKE_PATH_ATTR_DEF
typedef struct StrokePathAttr_s {
	float	lineWidth;
	int		lineCap;
	int		lineJoin;
	float	miterLimit;

	int		dashLen;
	float	dashPhase;
	float	dashData[32];

	float	colorfv[5];

	char	*pathString;

	int		x, y, width, height;
	int		colors;
} StrokePathAttr;
#endif	/*STROKE_PATH_ATTR_DEF*/

#ifndef	IMAGE_TILE_ATTR_DEF
#define	IMAGE_TILE_ATTR_DEF
typedef	struct Matrix_s {
	float	a, b, c, d, e, f;
} Matrix;

typedef struct ImageTileAttr_s {
	int		width, height, colors;
	float	alpha;
	float	xstep, ystep;
	Matrix	ctm;
} ImageTileAttr;
#endif	/*IMAGE_TILE_ATTR_DEF*/

typedef	struct BBox_s {		//2021.10.31
	float	x0, y0;
	float	x1, y1;
} BBox;

typedef struct MlpFormData_s {
	int			type;
	const char	*name;
	int			valueLength;
	const char	**value;		//[ol,\l]yA̔z
	const char	*richText;
	const char	**(*GetValue)(struct MlpFormData_s*, int);
} MlpFormData;

typedef struct MlpFontList_s {	/*tHg̊e푮i[*/
	unsigned int	embedFlg;	//2:tHgA3:TuZbgtHgA4:W14tHgA0:񖄍
	unsigned int	type;		//tHg^Cv enum FontType_e
	union {
		char*		mbs;
		wchar_t*	wcs;
		char*		u8;
	}				uName;
} MlpFontList;

/*
**	PrimitiveC^[tF[X
*/

typedef	void* PRIMITIVE_HANDLE;

typedef	struct PrmObjectHandle_s	PrmObjectHandle;
typedef	struct PrmDocumentXref_s	PrmDocumentXref;
typedef	enum PrmObjectType_e		PrmObjectType;
typedef	enum PrmXRefType_e			PrmXrefType;

struct PrmObjectHandle_s {
	PrmObjectType type;
	unsigned __int64 handle;
	int num;
};

struct PrmDocumentXref_s {
	int		ofs;
	int		num;
	int		gen;
	char	type;
};

enum PrmObjectType_e {
	PRM_UNKNOWN_OBJ = 0,
	PRM_NULL_OBJ = 1,
	PRM_BOOL_OBJ,
	PRM_INT_OBJ,
	PRM_REAL_OBJ,
	PRM_NUMBER_OBJ,
	PRM_STRING_OBJ,
	PRM_NAME_OBJ,
	PRM_ARRAY_OBJ,
	PRM_DICTIONARY_OBJ,
	PRM_INDIRECT_OBJ,
	PRM_NUMBER_OF_OBJS,
};

enum PrmXRefType_e {
	PRM_XREF_TABLE = 0,
	PRM_XREF_STREAM,
};

/*
**	Modifier
*/
typedef	void* MOD_HANDLE;

#ifdef _UNICODE
typedef	struct ModTextArgW_s	ModTextArg;
#else
typedef	struct ModTextArgA_s	ModTextArg;
#endif
typedef struct ModTextArgW_s {
	int pageNumber;
	unsigned int cKind;
	float color[4];
	float xTextPos, yTextPos;
	wchar_t* fontName;
	float fontSize;
	wchar_t* text;
} ModTextArgW;
typedef struct ModTextArgA_s {
	int pageNumber;
	unsigned int cKind;
	float color[4];
	float xTextPos, yTextPos;
	char* fontName;
	float fontSize;
	char* text;
} ModTextArgA;

/*
**	Stamper
*/
typedef	void*	MlpStamp;

typedef	struct MlpPoint_s {
	float	x, y;
} MlpPoint;

/*
**	Stamper
*/
typedef	void* STAMP_HANDLE;

/*
**	Secure
*/
typedef	void*	SECURE_HANDLE;
typedef	struct MlpDocumentHierarchyInfo_s	MlpDocumentHierarchyInfo;
typedef	struct MlpRevokedInfo_s				MlpRevokedInfo;

enum SecKindOfSigningTime_e {
	SEC_SIGNING_TIME_SYS = 0,	//؂{VXe̎
	SEC_SIGNING_TIME_M,			//̏ɋLꂽ
	SEC_SIGNING_TIME_SIGN,		//PKCS#7bZ[WɋLڂꂽ
	SEC_SIGNING_TIME_TS,		//^CX^v̎
};

struct MlpRevokedInfo_s {
	int nData;					//i[ꂽf[^
	struct {
		unsigned char* data;
		unsigned long	len;
	} *d;
};

struct MlpDocumentHierarchyInfo_s {
	unsigned int has_DSS : 1;
	unsigned int has_VRI : 1;
	unsigned int has_SIG : 2;			//2:TyepSigł(^CX^v)A3:TyepSigł(^CX^vL)
										//1:TyepDocumentTimeStampł
	unsigned int sig_verified : 1;
	unsigned int has_page_obj : 1;
	unsigned int has_resource_onj : 1;
	unsigned int has_annotation_obj : 1;
	unsigned int TamperingElm : 1;			//1:y[WLqƎv(ZLeBȊO)IuWFNgLڂĂ
	unsigned int hash_is_matched_sign : 1;	//adbe.pkcs7.detached, ETSI.CAdES.detached(DocTimeStampȊO)̏ꍇɗLȃtO
											//MLPadbe.x509.rsa_sha1, adbe.pkcs7.sha1ɖΉ
	unsigned int hash_is_matched_ts : 1;	//DocTimeStamp̏ꍇɗLȃtO
	unsigned int SignerCertIsNotRevoked : 2;//ҏؖ̎A0:mFA2:ς݁A3:Ȃ
	unsigned int SignerCertIsCurrValid : 1;	//ؖ͌ݎŗL

	long long	DataSize;
	long long	SignedDataSize;
	long long	ByteRange[4];

	BYTE*		RangeDifference;			//ByteRangeƃt@CTCY̍كf[^
	size_t		RangeDifferenceLength;		//RangeDifferencẽoCg

	const char* SigObj;
	const char* Title;
	const char* Name;
	const char* M;
	const char* Filter;
	const char* SubFilter;
	const char* PropBuild;

	const unsigned char** VRI_Certs;
	const unsigned char** VRI_CRLs;
	const unsigned char** VRI_OCSPs;
	const unsigned int* VRI_Cert_size;	//VRI_Certz̊evf̃oCgTCY
	const unsigned int* VRI_CRL_size;	//VRI_CRLz̊evf̃oCgTCY
	const unsigned int* VRI_OCSP_size;	//VRI_OCSPz̊evf̃oCgTCY
	const unsigned long Contents_len;
	const unsigned long VRI_Certs_len;	//VRI_Certz̃TCY
	const unsigned long VRI_CRLs_len;	//VRI_CRLz̃TCY
	const unsigned long VRI_OCSPs_len;	//VRI_OCSPz̃TCY

	MlpRevokedInfo	cms_CRLs;
	MlpRevokedInfo	cms_OCSPs;
	MlpRevokedInfo	dss_CRLs;		//f[^i[R[h͎ĂȂigpłj
	MlpRevokedInfo	dss_OCSPs;		//f[^i[R[h͎ĂȂigpłj

	enum SecKindOfSigningTime_e	SigningTime_source;
	FILETIME SigningTime;

	const unsigned char* Contents;
	const char* DigestAlgorithm;

	const unsigned char* SignerCert;
	const unsigned char* SignerCertSn;
	const unsigned char* SignerCertSubj;
	const unsigned char* IssuerName;
	const unsigned long SignerCert_len;
	const unsigned long SignerCertSn_len;
	const unsigned long SignerCertSubj_len;
	const unsigned long IssuerName_len;
	const char* SignatureAlgorithmId;
	FILETIME	NotBefore;
	FILETIME	NotAfter;
	const int SignerCert_err;

	char*	TstPolicyId;
	char*	HashOid;
	unsigned char*	HashMessage;
	unsigned int	HashMessageLen;
	unsigned char*	TstSn;
	unsigned int	TstSnLen;
	char*	GenTime;
	struct tm	GenTm;		//{
	int		AccuracySec;
	int		AccuracyMilli;
	int		AccuracyMicro;
	wchar_t*	TsaName;

	int error_code;
};

/*
**	^f[^
*/
typedef	void* METADATA_HANDLE;

typedef	struct MlpMetadataProperty_s		MlpMetadataProperty;
typedef	struct MlpMetaSimpleProperty_s		MlpMetaSimpleProperty;
typedef	struct MlpMetaArrayProperty_s		MlpMetaArrayProperty;
typedef	struct MlpMetaStructProperty_s		MlpMetaStructProperty;

struct MlpMetaSimpleProperty_s {
	wchar_t	*property;
	wchar_t	*value;
};

struct MlpMetaArrayProperty_s {
	wchar_t	*property;
	wchar_t	**valueAry;
	unsigned int	value_count;
};

struct MlpMetaStructProperty_s {
	wchar_t	*property;
	wchar_t	**fieldAry;
	wchar_t	**valueAry;
	unsigned int	value_count;
};

struct MlpMetadataProperty_s {
	MlpMetaSimpleProperty	*siProp;
	unsigned int	si_count;

	MlpMetaArrayProperty	*arProp;
	unsigned int	ar_count;

	MlpMetaStructProperty	*stProp;
	unsigned int	st_count;
};

/*
**	XMP
*/
typedef	void* XMP_HANDLE;

/*
 *	͗p
 */
typedef	struct PrsFontName_s PrsFontName;
#define	PrsFontName_fontId_LEN		100
#define	PrsFontName_fontName_LEN	256

struct PrsFontName_s {
	int		pageNum;						/*tHggĂ(ŏ)y[Wԍ*/
	char	fontId[PrsFontName_fontId_LEN];	/*tHg̎ʖ*/
	char	fontName[PrsFontName_fontName_LEN];	/*tHg*/
	int		embedded;						/*1:ߍ܂ꂽtHgA0:ȊO*/
	int		render;							/*-1:_[[h̎w肪ȂA0:ʏ̃_[[hŗpĂA1:Tr=2̃_[[hŎgpĂ*/
};

#endif	/*MLP_DECLARATION_H*/
