/*
 *	XMP Property Option Bit
 */

// =================================================================================================
// Copyright 2002 Adobe
// All Rights Reserved.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// =================================================================================================

#ifndef XMP_PROPERTY_OPTION_BIT_H
#define XMP_PROPERTY_OPTION_BIT_H

#define kXMP_ArrayLastItem      ((signed long)(-1L))
#define kXMP_UseNullTermination ((unsigned long)(~0UL))
#define kXMP_NoOptions          ((unsigned long)0UL)

#define XMP_SetOption(var,opt)      var |= (opt)
#define XMP_ClearOption(var,opt)    var &= ~(opt)
#define XMP_TestOption(var,opt)     (((var) & (opt)) != 0)
#define XMP_OptionIsSet(var,opt)    (((var) & (opt)) != 0)
#define XMP_OptionIsClear(var,opt)  (((var) & (opt)) == 0)

#define XMP_PropIsSimple(opt)       (((opt) & kXMP_PropCompositeMask) == 0)
#define XMP_PropIsStruct(opt)       (((opt) & kXMP_PropValueIsStruct) != 0)
#define XMP_PropIsArray(opt)        (((opt) & kXMP_PropValueIsArray) != 0)

#define XMP_ArrayIsUnordered(opt)   (((opt) & kXMP_PropArrayIsOrdered) == 0)
#define XMP_ArrayIsOrdered(opt)     (((opt) & kXMP_PropArrayIsOrdered) != 0)
#define XMP_ArrayIsAlternate(opt)   (((opt) & kXMP_PropArrayIsAlternate) != 0)
#define XMP_ArrayIsAltText(opt)     (((opt) & kXMP_PropArrayIsAltText) != 0)

#define XMP_PropHasQualifiers(opt)  (((opt) & kXMP_PropHasQualifiers) != 0)
#define XMP_PropIsQualifier(opt)    (((opt) & kXMP_PropIsQualifier) != 0)
#define XMP_PropHasLang(opt)        (((opt) & kXMP_PropHasLang) != 0)

#define XMP_NodeIsSchema(opt)       (((opt) & kXMP_SchemaNode) != 0)
#define XMP_PropIsAlias(opt)        (((opt) & kXMP_PropIsAlias) != 0)

enum {
	kXMP_PropValueIsURI = 0x00000002UL,

	// ------------------------------------------------------
	// Options relating to qualifiers attached to a property.
	kXMP_PropHasQualifiers	= 0x00000010UL,
	kXMP_PropIsQualifier	= 0x00000020UL,
	kXMP_PropHasLang		= 0x00000040UL,
	kXMP_PropHasType		= 0x00000080UL,

	// --------------------------------------------
	// Options relating to the data structure form.
	kXMP_PropValueIsStruct		= 0x00000100UL,
	kXMP_PropValueIsArray		= 0x00000200UL,
	kXMP_PropArrayIsUnordered	= kXMP_PropValueIsArray,
	kXMP_PropArrayIsOrdered		= 0x00000400UL,
	kXMP_PropArrayIsAlternate	= 0x00000800UL,

	// ------------------------------------
	// Additional struct and array options.
	kXMP_PropArrayIsAltText	= 0x00001000UL,
//	kXMP_InsertBeforeItem	= 0x00004000UL,  ! Used by SetXyz functions.
//	kXMP_InsertAfterItem	= 0x00008000UL,  ! Used by SetXyz functions.

	// ----------------------------
	// Other miscellaneous options.
	kXMP_PropIsAlias		= 0x00010000UL,
	kXMP_PropHasAliases		= 0x00020000UL,
	kXMP_PropIsInternal		= 0x00040000UL,
	kXMP_PropIsStable		= 0x00100000UL,
	kXMP_PropIsDerived		= 0x00200000UL,
//	kXMPUtil_AllowCommas	= 0x10000000UL,  ! Used by TXMPUtils::CatenateArrayItems and ::SeparateArrayItems.
//	kXMP_DeleteExisting		= 0x20000000UL,  ! Used by TXMPMeta::SetXyz functions to delete any pre-existing property.
//	kXMP_SchemaNode			= 0x80000000UL,  ! Returned by iterators - #define to avoid warnings

	// ------------------------------
	// Masks that are multiple flags.
	kXMP_PropArrayFormMask	= kXMP_PropValueIsArray | kXMP_PropArrayIsOrdered | kXMP_PropArrayIsAlternate | kXMP_PropArrayIsAltText,
	kXMP_PropCompositeMask	= kXMP_PropValueIsStruct | kXMP_PropArrayFormMask,
	kXMP_ImplReservedMask	= 0x70000000L
};

#endif /*XMP_PROPERTY_OPTION_BIT_H*/

