﻿/*
 *  toJPEG sample application
 */
/*
Copyright(c) 2021 株式会社トラスト・ソフトウェア・システム,All Rights Reserved.
*/

using System;
using PDFTools.PdfImagerLP;

namespace toJPEG
{
	class toJPEG
	{
		static void Main(string[] args)
		{
			int ret = 0;
			PdfImager imgr = new PdfImager();

			//初期化
			switch (imgr.Initialize("0-0395-923KH7539E9G"))
			{
				case err.MLP_ALREADY_INITIALIZED:
					Console.WriteLine("既に初期化されています。");
					Environment.Exit(1);
					break;
				case err.MLP_NOT_INITIALIZED:
					Console.WriteLine("初期化できませんでした。");
					Environment.Exit(1);
					break;
				case err.MLP_LICENSE_ERROR:
					Console.WriteLine("ライセンスが不正です。");
					Environment.Exit(1);
					break;
			}

			//初期化ファイル
			switch (imgr.LoadInitFile("../../../../../init.xml"))
			{
				case err.MLP_NOT_INITIALIZED:
					Console.WriteLine("初期化されていません。");
					Environment.Exit(3);
					break;
				case err.MLP_INIT_FILE_OPEN_ERROR:
					Console.WriteLine("初期化ファイルを読めません。");
					ret = 3;
					goto end_proc;
			}

			//オープン
			switch (imgr.OpenDoc("../../../../../../doc/PdfImager-LP.pdf", "", ""))
			{
				case err.MLP_NOT_INITIALIZED:
					Console.WriteLine("初期化されていません。");
					Environment.Exit(4);
					break;
				case err.MLP_ALREADY_OPENED:
					Console.WriteLine("既にオープンしています。");
					ret = 4;
					goto end_proc;
				case err.MLP_FILE_OPEN_ERROR:
					Console.WriteLine("オープンできません。");
					ret = 4;
					goto end_proc;
				case err.MLP_FILE_IS_NOT_PDF:
					Console.WriteLine("PDFではありません。");
					ret = 4;
					goto end_proc;
				case err.MLP_FILE_NOT_DECRYPTED:
					Console.WriteLine("復号できませんでした。");
					ret = 4;
					goto end_proc;
			}

			//PDFページ総数
			int pages = imgr.PageCount();
			if (pages < 0)
			{
				Console.WriteLine("エラー");
				ret = 5;
				goto end_proc;
			}
			else if (pages == 0)
			{
				Console.WriteLine("ページがありません。");
				ret = 5;
				goto end_proc;
			}
			else
			{
				Console.WriteLine("\"{0}\"の総ページ数は {1} です。", "PdfImager-LP.pdf", pages);
			}

			//コールバック指定
			DelegateProgress progress_cb = new DelegateProgress(
				(int lines, int totalLines) =>
				{
					Console.WriteLine("{0}/{1}を処理しました。", lines, totalLines);
				});
			DelegateRendering rendering_cb = new DelegateRendering(
				(int pageNumber) =>
				{
					Console.WriteLine("{0}ページを変換しています。", pageNumber);
				});
			imgr.SetCallbackFunc(CallbackMode.MLP_PROGRESS_CB, 100, progress_cb);
			imgr.SetCallbackFunc(CallbackMode.MLP_RENDERING_CB, 0, rendering_cb);

			//サイズ指定
			imgr.SetPictureSize(0, 30, PictureUnit.MLP_PICTURE_UNIT_PERCENT);

			/*
			 * 画像設定
			 */
#if true
			//RGBカラー
			imgr.SetPictureRGB();                               //既定の設定
#elif false
			//グレースケール
			imgr.SetPictureGray();
#endif

			//解像度
			imgr.SetPicture(PictureOpt.RESOLUTION_DPI, 150);    //既定の解像度

			//JPEG画像品質
			imgr.SetPicture(PictureOpt.JPEG_QUALITY, 75);       //既定の品質

			//画像作成
			switch (ret = imgr.CreatePict(1, "out.jpg"))
			{
				case err.MLP_PDF_HAS_NOT_PAGE:
					Console.WriteLine("ページがありません。");
					ret = 6;
					goto end_proc;
				case err.MLP_INVALID_PAGE_NUMBER:
					Console.WriteLine("ページ数が不正です。");
					ret = 6;
					goto end_proc;
				case err.MLP_NO_OUTPUT_FILE:
					Console.WriteLine("出力画像を指定してください。");
					ret = 6;
					goto end_proc;
				case err.MLP_TOO_LARGE_PIXEL:
					Console.WriteLine("画像が大きすぎます。");
					ret = 6;
					goto end_proc;
				case err.MLP_DRAW_ERROR:
					Console.WriteLine("画像作成に失敗しました。");
					ret = 6;
					goto end_proc;
			}

			//PNG画像作成
			//imgr.CreatePict(1, "out.png");

			//文書クローズ
			imgr.CloseDoc();

		//後始末
		end_proc:
			imgr.Uninitialize();
			Environment.Exit(ret);
		}
	}
}
