﻿/*
 *  toTiffMulti sample application
 */
/*
Copyright(c) 20210-0395-923KH7539E9G 株式会社トラスト・ソフトウェア・システム,All Rights Reserved.
*/

using System;
using PDFTools.PdfImagerLP;

namespace toTiffMulti
{
	class toTiffMulti
	{
		static void Main(string[] args)
		{
			int ret = 0;
			PdfImager imgr = new PdfImager();

			//初期化
			switch (imgr.Initialize("0-0395-923KH7539E9G"))
			{
				case err.MLP_ALREADY_INITIALIZED:
					Console.WriteLine("既に初期化されています。");
					Environment.Exit(1);
					break;
				case err.MLP_NOT_INITIALIZED:
					Console.WriteLine("初期化できませんでした。");
					Environment.Exit(1);
					break;
				case err.MLP_LICENSE_ERROR:
					Console.WriteLine("ライセンスが不正です。");
					Environment.Exit(1);
					break;
			}

			//オープン
			switch (imgr.OpenDoc("../../../../../../doc/PdfImager-LP.pdf", "", ""))
			{
				case err.MLP_NOT_INITIALIZED:
					Console.WriteLine("初期化されていません。");
					Environment.Exit(2);
					break;
				case err.MLP_ALREADY_OPENED:
					Console.WriteLine("既にオープンしています。");
					ret = 2;
					goto end_proc;
				case err.MLP_FILE_OPEN_ERROR:
					Console.WriteLine("オープンできません。");
					ret = 2;
					goto end_proc;
				case err.MLP_FILE_IS_NOT_PDF:
					Console.WriteLine("PDFではありません。");
					ret = 2;
					goto end_proc;
				case err.MLP_FILE_NOT_DECRYPTED:
					Console.WriteLine("復号できませんでした。");
					ret = 2;
					goto end_proc;
			}

			//コールバック指定
			DelegateProgress progress_cb = new DelegateProgress(
				(int lines, int totalLines) =>
				{
					Console.WriteLine("{0}/{1}を処理しました。", lines, totalLines);
				});
			DelegateRendering rendering_cb = new DelegateRendering(
				(int pageNumber) =>
				{
					Console.WriteLine("{0}ページを変換しています。", pageNumber);
				});
			imgr.SetCallbackFunc(CallbackMode.MLP_PROGRESS_CB, 100, progress_cb);
			imgr.SetCallbackFunc(CallbackMode.MLP_RENDERING_CB, 0, rendering_cb);

			//PDFページ総数
			int pages = imgr.PageCount();
			if (pages < 0)
			{
				Console.WriteLine("エラー");
				ret = 5;
				goto end_proc;
			}
			else if (pages == 0)
			{
				Console.WriteLine("ページがありません。");
				ret = 5;
				goto end_proc;
			}
			else
			{
				Console.WriteLine("\"{0}\"の総ページ数は {1} です。", "PdfImager-LP.pdf", pages);
			}

			//サイズ指定
			imgr.SetPictureSize(0, 30, PictureUnit.MLP_PICTURE_UNIT_PERCENT);

			/*
			 * 画像設定
			 */
			//RGBカラー
#if true
			imgr.SetPictureRGB();                   //既定の設定
#elif false
			imgr.SetPictureGray();
#elif false
			imgr.SetPictureDither();
#elif false
			imgr.SetPictureBW();
#endif

			//圧縮
#if false
			imgr.SetPicture(PictureOpt.COMPRESS_DEFLATE);   //既定の圧縮
#elif true
			imgr.SetPicture(PictureOpt.COMPRESS_JPEG);
			//			imgr.SetPicture(PictureOpt.COMPRESS_JPEG, 50);	//画像の品質を同時に指定する場合
#elif false
			imgr.SetPicture(PictureOpt.COMPRESS_LZW);
#elif false
			imgr.SetPicture(PictureOpt.COMPRESS_NONE);		//圧縮しない
#endif

			//解像度
			imgr.SetPicture(PictureOpt.RESOLUTION_DPI, 150); //既定の解像度

			//JPEG画質
			imgr.SetPicture(PictureOpt.JPEG_QUALITY, 75);   //既定の品質

			//画像作成
			switch (ret = imgr.ConvertToTiff("outa.tiff"))          /*すべてのページを画像に変換*/
			//			switch(ret = imgr.CreateTiffRange(0, -1, "outm.tiff"))	/*ページの順番：昇順*/
			//			switch(ret = imgr.CreateTiffRange(-1, 0, "outm.tiff"))	/*ページの順番：降順*/
			{
				case err.MLP_PDF_HAS_NOT_PAGE:
					Console.WriteLine("ページがありません。");
					ret = 3;
					break;
				case err.MLP_INVALID_PAGE_NUMBER:
					Console.WriteLine("ページ数が不正です。");
					ret = 3;
					break;
				case err.MLP_NO_OUTPUT_FILE:
					Console.WriteLine("出力画像を指定してください。");
					ret = 3;
					break;
				case err.MLP_TOO_LARGE_PIXEL:
					Console.WriteLine("画像が大きすぎます。");
					ret = 3;
					break;
				case err.MLP_DRAW_ERROR:
					Console.WriteLine("画像作成に失敗しました。");
					ret = 3;
					break;
				case err.MLP_INVALID_PICTURE_TYPE:
					Console.WriteLine("無効な画像形式です。\n");
					ret = 3;
					break;
				default:
					if (ret < 0) { Console.WriteLine("画像作成に失敗(%d)\n", ret); ret = 4; }
					else { Console.WriteLine("%dページのTIFF画像を作成\n", ret); ret = 0; }
					break;
			}

			//文書クローズ
			imgr.CloseDoc();

		//後始末
		end_proc:
			imgr.Uninitialize();
			Environment.Exit(ret);
		}
	}
}
