// ColorprofileDlg.cpp : t@C
/*
Copyright(c) 2021 ЃgXgE\tgEFAEVXe
f]ڂ֎~܂B
*/

#include "stdafx.h"
#include "Imager.h"
#include <MlpDeclaration.h>
#include "ColorprofileDlg.h"
#include "ColorprofileListDlg.h"


// ColorprofileDlg _CAO

IMPLEMENT_DYNAMIC(ColorprofileDlg, CDialog)

ColorprofileDlg::ColorprofileDlg(CWnd* pParent /*=NULL*/)
	: CDialog(ColorprofileDlg::IDD, pParent)
{
	InitValue();
}

ColorprofileDlg::~ColorprofileDlg()
{
}

void ColorprofileDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_RGB_PROFILE_EDT, m_RgbProfileEdt);
	DDX_Control(pDX, IDC_CMYK_PROFILE_EDT, m_CmykProfileEdt);
}


BEGIN_MESSAGE_MAP(ColorprofileDlg, CDialog)
	ON_BN_CLICKED(IDC_LIST_BTN, &ColorprofileDlg::OnBnClickedListBtn)
END_MESSAGE_MAP()

void ColorprofileDlg::InitValue()
{
	rgbProfileName = cmykProfileName = "";
	m_conv = CONVERT_FAST;
}

// ColorprofileDlg bZ[W nh

BOOL ColorprofileDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	m_ProfileConvRb = (CButton*)GetDlgItem(IDC_PROFILE_CONV_RB);
	m_FastConvRb = (CButton*)GetDlgItem(IDC_FAST_CONV_RB);
	m_MostFastConvRb = (CButton*)GetDlgItem(IDC_MOST_FAST_CONV_RB);

	m_ProfileConvRb->SetCheck(BST_UNCHECKED);
	m_FastConvRb->SetCheck(BST_UNCHECKED);
	m_MostFastConvRb->SetCheck(BST_UNCHECKED);
	switch(m_conv){
		case CONVERT_MOST_FAST:
			m_MostFastConvRb->SetCheck(BST_CHECKED);
			break;
		case CONVERT_FAST:
			m_FastConvRb->SetCheck(BST_CHECKED);
			break;
		case CONVERT_BY_COLOR_PROFILE:
			m_ProfileConvRb->SetCheck(BST_CHECKED);
			break;
	}

#if	1
	m_RgbProfileEdt.SetWindowText("sRGB Color Space Profile.icm");
	m_CmykProfileEdt.SetWindowText("JapanColor2001Coated.icc");
#endif

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void ColorprofileDlg::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if(m_ProfileConvRb->GetCheck() == BST_CHECKED)
		m_conv = CONVERT_BY_COLOR_PROFILE;
	else if(m_FastConvRb->GetCheck() == BST_CHECKED)
		m_conv = CONVERT_FAST;
	else if(m_MostFastConvRb->GetCheck() == BST_CHECKED)
		m_conv = CONVERT_MOST_FAST;
	if(m_ProfileConvRb->GetCheck() == BST_CHECKED){
		m_RgbProfileEdt.GetWindowText(rgbProfileName);
		m_CmykProfileEdt.GetWindowText(cmykProfileName);
	}

	CDialog::OnOK();
}

void ColorprofileDlg::OnBnClickedListBtn()
{
	ColorprofileListDlg	dlg;
	dlg.DoModal();
}
