// ImagerDlg.cpp : t@C
/*
Copyright(c) 2021 ЃgXgE\tgEFAEVXe
f]ڂ֎~܂B
*/

#include "stdafx.h"
#include <ImagerLp.h>
#include "Imager.h"
#include "ImagerDlg.h"
#include "LicenseDlg.h"
#include "PasswordDlg.h"
#include "MessageDlg.h"
#include "LayerDlg.h"
#include "FontInfoDlg.h"
#include "ColorprofileDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

// 
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

// CImagerDlg _CAO
CImagerDlg::CImagerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CImagerDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	wtmImgDlg = NULL;
	wtmStrDlg = NULL;
	colorprofileDlg = NULL;
	threadDetailDlg = NULL;
}

void CImagerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDOK, m_OkBtn);
	DDX_Control(pDX,             IDC_INIT_BTN, m_InitBtn);
	DDX_Control(pDX,           IDC_UNINIT_BTN, m_UninitBtn);
	DDX_Control(pDX,         IDC_OPEN_DOC_BTN, m_OpenDocBtn);
	DDX_Control(pDX,        IDC_CLOSE_DOC_BTN, m_CloseDocBtn);
	DDX_Control(pDX,     IDC_PAGE_TO_PICT_BTN, m_PageToPictBtn);
	DDX_Control(pDX,              IDC_OCG_BTN, m_OcgBtn);
	DDX_Control(pDX,    IDC_INIT_FILE_REF_BTN, m_InitFileRefBtn);
	DDX_Control(pDX, IDC_WTM_IMG_FILE_REF_BTN, m_WtmImgFileRefBtn);
	DDX_Control(pDX,   IDC_WTM_IMG_DETAIL_BTN, m_WtmImgDetailBtn);
	DDX_Control(pDX,  IDC_WTM_STR_DETAIL_BTN, m_WtmStrDetailBtn);
	DDX_Control(pDX,    IDC_THREAD_DETAIL_BTN, m_ThreadDetailBtn);
	DDX_Control(pDX,        IDC_FONT_INFO_BTN, m_FontInfoBtn);
	DDX_Control(pDX,     IDC_COLORPROFILE_BTN, m_ColorprofileBtn);
	DDX_Control(pDX,           IDC_LIC_STR_EDT, m_LicStrEdt);
	DDX_Control(pDX,         IDC_FILE_NAME_EDT, m_FileNameEdt);
	DDX_Control(pDX,          IDC_OUT_FILE_EDT, m_OutFileEdt);
	DDX_Control(pDX,               IDC_DPI_EDT, m_DpiEdt);
	DDX_Control(pDX,           IDC_QUALITY_EDT, m_QualityEdt);
	DDX_Control(pDX,         IDC_PAGE_LIST_EDT, m_PageListEdt);
	DDX_Control(pDX,       IDC_PICT_SIZE_X_EDT, m_PictSizeXEdt);
	DDX_Control(pDX,       IDC_PICT_SIZE_Y_EDT, m_PictSizeYEdt);
	DDX_Control(pDX,        IDC_CVS_SIZE_X_EDT, m_CvsSizeXEdt);
	DDX_Control(pDX,        IDC_CVS_SIZE_Y_EDT, m_CvsSizeYEdt);
	DDX_Control(pDX,    IDC_INIT_FILE_NAME_EDT, m_InitFileNameEdt);
	DDX_Control(pDX, IDC_WTM_IMG_FILE_NAME_EDT, m_WtmImgFileNameEdt);
	DDX_Control(pDX,   IDC_WTM_TEST_STRING_EDT, m_WtmStringEdt);
	DDX_Control(pDX,    IDC_MIN_LINE_WIDTH_EDT, m_MinLineWidthEdt);
	DDX_Control(pDX,         IDC_SINGLE_FILE_CHK, m_SingleFileChk);
	DDX_Control(pDX,           IDC_INIT_FILE_CHK, m_InitFileChk);
	DDX_Control(pDX,             IDC_WTM_IMG_CHK, m_WtmImgChk);
	DDX_Control(pDX,  IDC_WTM_IMG_FOREGROUND_CHK, m_WtmImgForegroundChk);
	DDX_Control(pDX,            IDC_WTM_STR_CHK, m_WtmStrChk);
	DDX_Control(pDX, IDC_WTM_STR_FOREGROUND_CHK, m_WtmStrForegroundChk);
	DDX_Control(pDX,          IDC_SPLIT_PAGE_CHK, m_SplitPageChk);
	DDX_Control(pDX,           IDC_EACH_PAGE_CHK, m_EachPageChk);
	DDX_Control(pDX,     IDC_ANTI_ALIAS_PATH_CHK, m_AntiAliasPathChk);
	DDX_Control(pDX,     IDC_ANTI_ALIAS_TEXT_CHK, m_AntiAliasTextChk);
	DDX_Control(pDX, IDC_PAGE_SEL, m_PageSel);
	DDX_Control(pDX, IDC_PAGE_SIZE, m_PageSize);
	DDX_Control(pDX, IDC_PAGE_ROTATE, m_PageRotate);
	DDX_Control(pDX, IDC_OCG_COUNT, m_OcgCount);
	DDX_Control(pDX, IDC_PASSWORD_ENC, m_PasswordEnc);
	DDX_Control(pDX, IDC_DOC_TITLE, m_DocTitle);
	DDX_Control(pDX, IDC_N_PAGES, m_NPages);
	DDX_Control(pDX, IDC_RESULT_SIZE, m_ResultSize);
	DDX_Control(pDX, IDC_DOC_VERSION, m_DocVersion);
	DDX_Control(pDX, IDC_PAGE_BOUNDS, m_PageBounds);
	DDX_Control(pDX, IDC_MODE, m_mode);
}

BEGIN_MESSAGE_MAP(CImagerDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(            IDC_INIT_BTN, &CImagerDlg::OnBnClickedInitBtn)
	ON_BN_CLICKED(          IDC_UNINIT_BTN, &CImagerDlg::OnBnClickedUninitBtn)
	ON_BN_CLICKED(        IDC_OPEN_DOC_BTN, &CImagerDlg::OnBnClickedOpenDocBtn)
	ON_BN_CLICKED(       IDC_CLOSE_DOC_BTN, &CImagerDlg::OnBnClickedCloseDocBtn)
	ON_BN_CLICKED(    IDC_PAGE_TO_PICT_BTN, &CImagerDlg::OnBnClickedPageToPictBtn)
	ON_BN_CLICKED(        IDC_FILE_REF_BTN, &CImagerDlg::OnBnClickedFileRefBtn)
	ON_BN_CLICKED(             IDC_OCG_BTN, &CImagerDlg::OnBnClickedOcgBtn)
	ON_BN_CLICKED(  IDC_WTM_IMG_DETAIL_BTN, &CImagerDlg::OnBnClickedWtmImgDetailBtn)
	ON_BN_CLICKED(  IDC_WTM_STR_DETAIL_BTN, &CImagerDlg::OnBnClickedWtmStrDetailBtn)
	ON_BN_CLICKED(       IDC_FONT_INFO_BTN, &CImagerDlg::OnBnClickedFontInfoBtn)
	ON_BN_CLICKED(    IDC_COLORPROFILE_BTN, &CImagerDlg::OnBnClickedColorprofileBtn)
	ON_BN_CLICKED(   IDC_THREAD_DETAIL_BTN, &CImagerDlg::OnBnClickedTreadDetailBtn)
	ON_BN_CLICKED(   IDC_INIT_FILE_REF_BTN, &CImagerDlg::OnBnClickedInitFileRefBtn)
	ON_BN_CLICKED(    IDC_RES_FILE_REF_BTN, &CImagerDlg::OnBnClickedResFileRefBtn)
	ON_BN_CLICKED(IDC_WTM_IMG_FILE_REF_BTN, &CImagerDlg::OnBnClickedWtmImgFileRefBtn)
	ON_BN_CLICKED(      IDC_JPEG_RB, &CImagerDlg::OnBnClickedJpegRb)
	ON_BN_CLICKED(       IDC_PNG_RB, &CImagerDlg::OnBnClickedPngRb)
	ON_BN_CLICKED      (IDC_TIFF_RB, &CImagerDlg::OnBnClickedTiffRb)
	ON_BN_CLICKED(IDC_PAGE_RANGE_RB, &CImagerDlg::OnBnClickedPageRb)
	ON_BN_CLICKED(  IDC_PAGE_NUM_RB, &CImagerDlg::OnBnClickedPageRb)
	ON_BN_CLICKED( IDC_ALL_PAGES_RB, &CImagerDlg::OnBnClickedPageWholeRb)
	ON_BN_CLICKED(  IDC_MEDIABOX_RB, &CImagerDlg::PageBounds)
	ON_BN_CLICKED(   IDC_CROPBOX_RB, &CImagerDlg::PageBounds)
	ON_BN_CLICKED(  IDC_BLEEDBOX_RB, &CImagerDlg::PageBounds)
	ON_BN_CLICKED(   IDC_TRIMBOX_RB, &CImagerDlg::PageBounds)
	ON_BN_CLICKED(    IDC_ARTBOX_RB, &CImagerDlg::PageBounds)
	ON_BN_CLICKED(  IDC_WTM_IMG_CHK, &CImagerDlg::OnBnClickedWtmImgChk)
	ON_BN_CLICKED(  IDC_WTM_STR_CHK, &CImagerDlg::OnBnClickedWtmStrChk)
	ON_BN_CLICKED(IDC_INIT_FILE_CHK, &CImagerDlg::OnBnClickedInitFileChk)
	ON_EN_CHANGE(      IDC_DPI_EDT, &CImagerDlg::OnEnChangeDpiEdt)
	ON_EN_CHANGE(IDC_PAGE_LIST_EDT, &CImagerDlg::OnEnChangePageListEdt)
END_MESSAGE_MAP()

//o̓t@C̃`FbN
bool CImagerDlg::OutFileCheck()
{
	CString	s;

	m_OutFileEdt.GetWindowText(s);
	int len = s.GetLength();
	if(len > 0){
		if(len < 5){
			MessageBox("t@CsłB");
			return false;
		}else if(!s.Right(4).CompareNoCase(".tif")||!s.Right(5).CompareNoCase(".tiff")){
			m_TiffRb->SetCheck(BST_CHECKED);
			m_JpegRb->SetCheck(BST_UNCHECKED);
			m_PngRb->SetCheck(BST_UNCHECKED);
			return true;
		}else if(!s.Right(4).CompareNoCase(".jpg")){
			m_TiffRb->SetCheck(BST_UNCHECKED);
			m_JpegRb->SetCheck(BST_CHECKED);
			m_PngRb->SetCheck(BST_UNCHECKED);
			return true;
		}else if(!s.Right(4).CompareNoCase(".png")){
			m_TiffRb->SetCheck(BST_UNCHECKED);
			m_JpegRb->SetCheck(BST_UNCHECKED);
			m_PngRb->SetCheck(BST_CHECKED);
			return true;
		}else{
			MessageBox("t@CʎqFł܂B");
			return false;
		}
	}

	//摜t@Cw肳ĂȂ̂ŁAK؂ȃt@Cɂ
	if(m_TiffRb->GetCheck() == BST_CHECKED) s = "out.tiff";
	else if(m_JpegRb->GetCheck() == BST_CHECKED) s = "out.jpg";
	else if(m_PngRb->GetCheck() == BST_CHECKED) s = "out.png";
	else{
		s = "out.png";
		m_PngRb->SetCheck(BST_CHECKED);
	}
	m_OutFileEdt.SetWindowText(s);

	return true;
}

//y[WE
void CImagerDlg::PageBounds()
{
	if(m_MediaBoxRb->GetCheck() == BST_CHECKED) MlpSetPicture(MLP_PICTURE_USE_MEDIABOX);
	else if(m_CropBoxRb->GetCheck() == BST_CHECKED) MlpSetPicture(MLP_PICTURE_USE_CROPBOX);
	else if(m_BleedBoxRb->GetCheck() == BST_CHECKED) MlpSetPicture(MLP_PICTURE_USE_BLEEDBOX);
	else if(m_TrimBoxRb->GetCheck() == BST_CHECKED) MlpSetPicture(MLP_PICTURE_USE_TRIMBOX);
	else if(m_ArtBoxRb->GetCheck() == BST_CHECKED) MlpSetPicture(MLP_PICTURE_USE_ARTBOX);
	if(m_CloseDocBtn.IsWindowEnabled()){
		if(pageCount <= 0) return;	/*y[WȂꍇ̓y[WTCYXVȂ*/
		CString	s;
		m_PageListEdt.GetWindowText(s);
		int pageNum = atoi(s);
		if(pageNum <= 0) pageNum = 1;
		else if(pageCount < pageNum) pageNum = pageCount;
		/*y[W̃TCY*/
		PageOrgSize(pageNum);
		PagePictSize(pageNum);
	}
}

//y[W̃IWiTCY
void CImagerDlg::PageOrgSize(int pageNum)
{
	CString	s;
	int		x, y;
	int		k;
	float	userUnit, left, bottom, right, top;

	if(pageNum < 1) pageNum = 1;

	/*TCY*/
	MlpSetPictureResolution(72);
	MlpGetPicturePixel(pageNum, &x, &y);
	s.Format("y[WTCY: %d x %d", x, y);
	m_PageSize.SetWindowText(s);
	m_PageSize.EnableWindow(true);

	/*E*/
	if(m_MediaBoxRb->GetCheck() == BST_CHECKED) k = MEDIA_BOX;
	else if(m_CropBoxRb->GetCheck() == BST_CHECKED) k = CROP_BOX;
	else if(m_BleedBoxRb->GetCheck() == BST_CHECKED) k = BLEED_BOX;
	else if(m_TrimBoxRb->GetCheck() == BST_CHECKED) k = TRIM_BOX;
	else if(m_ArtBoxRb->GetCheck() == BST_CHECKED) k = ART_BOX;
	MlpGetPageBoundary(pageNum, k, &userUnit, &left, &bottom, &right, &top);
	s.Format("y[WE: (%g, %g)-(%g, %g) %g", left, bottom, right, top, userUnit);
	m_PageBounds.SetWindowText(s);
	m_PageBounds.EnableWindow(true);
}

//w肳ꂽ𑜓xł̃TCY(LoXTCYł͂Ȃ)
void CImagerDlg::PagePictSize(int pageNum)
{
	CString	s;
	int		c, r;
	int		x, y;

	if(pageNum < 1) pageNum = 1;

	if((c = MlpPageCount()) < pageNum ){
		m_PageSize.EnableWindow(false);
		m_PageSize.SetWindowText("y[WTCY");
		m_PageRotate.EnableWindow(false);
		m_PageRotate.SetWindowText("y[W]");
		return;
	}
	m_DpiEdt.GetWindowText(s);
	r = atoi(s);
	if(r < 10) return;	/*𑜓x̂Ńy[WTCY\Ȃ*/
	MlpSetPictureResolution(r);
	MlpGetPicturePixel(pageNum, &x, &y);	/*y[Ww肳ꂽꍇ́A擪̃y[Ŵ*/
	s.Format("%d x %d", x, y);
	m_ResultSize.SetWindowText(s);
}

/*
**	CImagerDlg bZ[W nh
*/

BOOL CImagerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// "o[W..." j[VXe j[ɒǉ܂B

	// IDM_ABOUTBOX ́AVXe R}h͈͓̔ɂȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if(pSysMenu != NULL){
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if(!strAboutMenu.IsEmpty()){
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// TODO: ɒǉ܂B
	m_TiffRb	= (CButton*)GetDlgItem(IDC_TIFF_RB);
	m_JpegRb	= (CButton*)GetDlgItem(IDC_JPEG_RB);
	m_PngRb		= (CButton*)GetDlgItem(IDC_PNG_RB);
	m_PageRangeRb	= (CButton*)GetDlgItem(IDC_PAGE_RANGE_RB);
	m_PageNumRb		= (CButton*)GetDlgItem(IDC_PAGE_NUM_RB);
	m_AllPagesRb	= (CButton*)GetDlgItem(IDC_ALL_PAGES_RB);
	m_ColorRb	= (CButton*)GetDlgItem(IDC_COLOR_RB);
	m_GrayRb	= (CButton*)GetDlgItem(IDC_GRAY_RB);
	m_DitherRb	= (CButton*)GetDlgItem(IDC_DITHER_RB);
	m_BwRb		= (CButton*)GetDlgItem(IDC_BW_RB);
	m_CompressNoneRb	= (CButton*)GetDlgItem(IDC_COMPRESS_NONE_RB);
	m_CompressJpegRb	= (CButton*)GetDlgItem(IDC_COMPRESS_JPEG_RB);
	m_CompressDeflateRb	= (CButton*)GetDlgItem(IDC_COMPRESS_DEFLATE_GB);
	m_CompressLzwRb		= (CButton*)GetDlgItem(IDC_COMPRESS_LZW_RB);
	m_UnitPercentRb	= (CButton*)GetDlgItem(IDC_UNIT_PERCENT_RB);
	m_UnitInchRb	= (CButton*)GetDlgItem(IDC_UNIT_INCH_RB);
	m_UnitMmRb		= (CButton*)GetDlgItem(IDC_UNIT_MM_RB);
	m_MediaBoxRb	= (CButton*)GetDlgItem(IDC_MEDIABOX_RB);
	m_CropBoxRb		= (CButton*)GetDlgItem(IDC_CROPBOX_RB);
	m_BleedBoxRb	= (CButton*)GetDlgItem(IDC_BLEEDBOX_RB);
	m_TrimBoxRb		= (CButton*)GetDlgItem(IDC_TRIMBOX_RB);
	m_ArtBoxRb		= (CButton*)GetDlgItem(IDC_ARTBOX_RB);

	m_SplitPageChk.SetCheck(BST_CHECKED);	/*y[W𕪊ĕ񏈗*/
	m_SingleFileChk.SetCheck(BST_CHECKED);	/*Pt@Cɂ*/
#if		0	//̉摜`TIFF`
	m_TiffRb->SetCheck(BST_CHECKED);		/*TIFF`摜쐬*/
	m_PageRangeRb->SetCheck(BST_CHECKED);	/*y[W͈̔͂w*/
#elif	0	//̉摜`JPEG`
	m_JpegRb->SetCheck(BST_CHECKED);			/*PNG`摜쐬*/
	m_PageNumRb->SetCheck(BST_CHECKED);		/*y[Wԍw*/
#elif	1	//̉摜`PNG`
	m_PngRb->SetCheck(BST_CHECKED);			/*PNG`摜쐬*/
	m_PageNumRb->SetCheck(BST_CHECKED);		/*y[Wԍw*/
#endif
	m_ColorRb->SetCheck(BST_CHECKED);		/*RGBJ[摜𐶐*/
	m_CompressNoneRb->SetCheck(BST_CHECKED);/*TIFF`̏ꍇ kȂ*/
	m_MediaBoxRb->SetCheck(BST_CHECKED);	/*MediaBoxEgp*/

	m_DpiEdt.SetWindowText("150");			/*150DPỈ摜𐶐*/
	m_QualityEdt.SetWindowText("75");		/*JPEGk̏ꍇi75%ɂ*/

	wtmImgDlg = new WatermarkImgDlg();
	wtmStrDlg = new WatermarkStrDlg();
	colorprofileDlg = new ColorprofileDlg();
	threadDetailDlg = new ThreadDetailDlg();

	pageCount = 0;	//݊JĂPDF̑y[W


	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

void CImagerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if((nID & 0xFFF0) == IDM_ABOUTBOX){
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}else{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CImagerDlg::OnPaint()
{
	if(IsIconic()){
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}else{
		CDialog::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CImagerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

// {^
void CImagerDlg::OnBnClickedInitBtn()
{
	if(MlpInitialize("0-W0H6-7H5GKW7E336R") != 0){	//K؂ȃCZXL[ɑւĂB
		LicenseDlg dlg;
		if(dlg.DoModal() != IDOK){
			MessageBox("ł܂B");
			return;
		}
		if(MlpInitialize((TCHAR*)(LPCTSTR)dlg.GetLicenseStr()) != 0){
			MessageBox("ł܂B");
			return;
		}
	}

	//CZX
	char	licStr[100];
	MlpLicenseInfoStr(licStr);
	m_LicStrEdt.SetWindowText(licStr);

	//t@C
	if(m_InitFileChk.GetCheck() == BST_CHECKED){
		CString	s;
		m_InitFileNameEdt.GetWindowText(s);
		MlpLoadInitFile((TCHAR*)(LPCTSTR)s);
	}
	m_InitFileChk.EnableWindow(false);
	m_InitFileNameEdt.EnableWindow(false);
	m_InitFileRefBtn.EnableWindow(false);

	//o̓t@C
	if(m_PngRb->GetCheck() == BST_CHECKED) m_OutFileEdt.SetWindowText("out.png");
	else if(m_JpegRb->GetCheck() == BST_CHECKED) m_OutFileEdt.SetWindowText("out.jpg");
	else if(m_TiffRb->GetCheck() == BST_CHECKED) m_OutFileEdt.SetWindowText("out.tiff");

	//
	m_InitBtn.EnableWindow(false);
	m_UninitBtn.EnableWindow(true);
	m_ColorprofileBtn.EnableWindow(true);
	m_ThreadDetailBtn.EnableWindow(true);
	m_OpenDocBtn.EnableWindow(true);
	m_OpenDocBtn.SetFocus();
	m_AntiAliasPathChk.EnableWindow(true);
	m_AntiAliasTextChk.EnableWindow(true);
	m_SplitPageChk.EnableWindow(true);
	m_EachPageChk.EnableWindow(true);
}

//MLPI {^
void CImagerDlg::OnBnClickedUninitBtn()
{
	MlpUninitialize();
	m_LicStrEdt.SetWindowText("");
	m_InitBtn.EnableWindow(true);
	m_UninitBtn.EnableWindow(false);
	m_ColorprofileBtn.EnableWindow(false);
	m_ThreadDetailBtn.EnableWindow(false);
	m_OpenDocBtn.EnableWindow(false);
	m_SplitPageChk.EnableWindow(false);
	m_EachPageChk.EnableWindow(false);
	m_InitFileChk.SetCheck(BST_UNCHECKED);
	m_InitFileChk.EnableWindow(true);
	m_InitFileNameEdt.EnableWindow(false);
	m_InitFileRefBtn.EnableWindow(false);
	m_AntiAliasPathChk.EnableWindow(false);
	m_AntiAliasTextChk.EnableWindow(false);
	m_AntiAliasPathChk.SetCheck(BST_UNCHECKED);
	m_AntiAliasTextChk.SetCheck(BST_UNCHECKED);
	m_SplitPageChk.SetCheck(BST_CHECKED);
	m_EachPageChk.SetCheck(BST_UNCHECKED);
}

//t@CQ
void CImagerDlg::OnBnClickedInitFileRefBtn()
{
	CFileDialog	dlg(true, "xml", "init.xml", OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, "t@C(*.xml)|*.xml|ׂ(*.*)|*.*||");
	if(dlg.DoModal() != IDOK) return;
	m_InitFileNameEdt.SetWindowText(dlg.GetPathName());
}

//J {^
void CImagerDlg::OnBnClickedOpenDocBtn()
{
	CString	s;
	PasswordDlg	dlg;
	int	restrict;

	m_FileNameEdt.GetWindowText(s);
	if(s.GetLength() < 1){
		MessageBox("PDFt@Cw肵ĂB");
		return;
	}

	//J
	m_FileNameEdt.GetWindowText(s);
	if(s.Right(4).CompareNoCase(".pdf")){
		MessageBox("PDFt@Cw肵ĂB");
		return;
	}
	switch(MlpOpenDoc(s, "", "")){
		case MLP_NO_ERROR:
			m_PasswordEnc.EnableWindow(true);
			m_PasswordEnc.SetWindowText("PDFt@ĆA(Í)łB");
			break;
		case MLP_FILE_IS_NOT_PDF:
			MessageBox("");
			return;
		case MLP_FILE_NOT_DECRYPTED:
			if(dlg.DoModal() != IDOK){
				MessageBox("ł܂B");
				return;
			}
			switch(dlg.GetOpenMode()){
				case 0:
					if(MlpOpenDoc(s, dlg.GetOwnerPswd(), dlg.GetUserPswd()) == MLP_FILE_NOT_DECRYPTED){
						MessageBox("t@CJ܂B");
						return;
					}
					break;
				case 1:
					if(MlpOpenDocUsage(s, dlg.GetPswd(), 1) == MLP_FILE_NOT_DECRYPTED){
						MessageBox("t@CJ܂B");
						return;
					}
					break;
				case 2:
					if(MlpOpenDocUsage(s, dlg.GetPswd(), 2) == MLP_FILE_NOT_DECRYPTED){
						MessageBox("t@CJ܂B");
						return;
					}
					break;
				default:
					MessageBox("ł܂B");
					return;
			}
			MlpGetDocumentInfo(MLP_PRINT_RESTRICTION, &restrict);
			switch(restrict){
				case 0:
					s.Format("PDFt@ĆApX[hňÍĂ܂B\r\n(͂܂B)", s);
					break;
				case 1:
					s.Format("PDFt@ĆApX[hňÍĂ܂B\r\n(𑜓xw肳Ă܂B)", s);
					break;
				case 2:
					s.Format("PDFt@ĆApX[hňÍĂ܂B\r\n(͋Ă܂B)", s);
					break;
			}
			m_PasswordEnc.EnableWindow(true);
			m_PasswordEnc.SetWindowText(s);
			break;
		case MLP_OPEN_ERROR:
		default:
			MessageBox("t@CJ܂B");
			return;
	}

	//{^...
	m_UninitBtn.EnableWindow(false);
	m_OpenDocBtn.EnableWindow(false);
	m_CloseDocBtn.EnableWindow(true);

	//u\v܂́uv[h
	switch(dlg.GetOpenMode()){
		case 0:	m_mode.SetWindowText("\ш");	break;
		case 1:	m_mode.SetWindowText("\[h");		break;
		case 2:	m_mode.SetWindowText("[h");		break;
		default:m_mode.SetWindowText("s");			break;
	}

	//^Cg
	char	*title;
	MlpGetDocumentInfo(MLP_DOCUMENT_TITLE, &title);
	if(title[0]){
		s.Format("^Cg: %s", title);
		m_DocTitle.SetWindowText(s);
	}else
		m_DocTitle.SetWindowText("^CgݒȂ");
	m_DocTitle.EnableWindow(true);

	//̃o[W
	MlpGetDocumentInfo(MLP_PDF_VERSION, &pdfVersion);
	s.Format("PDF%g", pdfVersion / 10.f);
	m_DocVersion.SetWindowText(s);
	m_DocVersion.EnableWindow(true);

	//y[WE
	if(m_MediaBoxRb->GetCheck() == BST_CHECKED) MlpSetPicture(MLP_PICTURE_USE_MEDIABOX);
	else if(m_CropBoxRb->GetCheck() == BST_CHECKED) MlpSetPicture(MLP_PICTURE_USE_CROPBOX);
	else if(m_BleedBoxRb->GetCheck() == BST_CHECKED) MlpSetPicture(MLP_PICTURE_USE_BLEEDBOX);
	else if(m_TrimBoxRb->GetCheck() == BST_CHECKED) MlpSetPicture(MLP_PICTURE_USE_TRIMBOX);
	else if(m_ArtBoxRb->GetCheck() == BST_CHECKED) MlpSetPicture(MLP_PICTURE_USE_ARTBOX);
	else m_MediaBoxRb->SetCheck(BST_CHECKED);	/*default*/
	m_MediaBoxRb->EnableWindow(true);
	m_CropBoxRb->EnableWindow(true);
	m_BleedBoxRb->EnableWindow(true);
	m_TrimBoxRb->EnableWindow(true);
	m_ArtBoxRb->EnableWindow(true);

	//y[W
	//y[WύXƁAy[W񂪕ωBAm_CloseDocBtnEnablȅꍇ
	pageCount = MlpPageCount();
	if(m_PageRangeRb->IsWindowEnabled()){
		s.Format("1-%d", pageCount);
	}else{
		s = "1";
	}
	m_PageListEdt.SetWindowText(s);
	s.Format("y[W: %d", pageCount);
	m_NPages.SetWindowText(s);
	m_NPages.EnableWindow(true);

	//OCG
	int nOCG = MlpGetOcgCount();
	s.Format("(OCG: %d)", nOCG);
	m_OcgCount.SetWindowText(s);
	m_OcgCount.EnableWindow(true);
	if(0 < nOCG){
		m_OcgBtn.EnableWindow(true);
	}

	//
	//PDFI[vƓ̏ڍׂ
	wtmImgDlg->InitValue();
	wtmStrDlg->InitValue();
	m_WtmImgChk.EnableWindow(true);
	m_WtmStrChk.EnableWindow(true);

	//{^...
	m_PageToPictBtn.EnableWindow(true);
	if(m_TiffRb->GetCheck() == BST_CHECKED) m_PageRangeRb->EnableWindow(true), m_AllPagesRb->EnableWindow(true);
	m_PageNumRb->EnableWindow(true);
	m_PageListEdt.EnableWindow(true);
	m_FontInfoBtn.EnableWindow(true);
	m_PngRb->EnableWindow(true);
	m_JpegRb->EnableWindow(true);
	m_TiffRb->EnableWindow(true);
	m_MediaBoxRb->EnableWindow(true);
	m_CropBoxRb->EnableWindow(true);
	m_BleedBoxRb->EnableWindow(true);
	m_TrimBoxRb->EnableWindow(true);
	m_ArtBoxRb->EnableWindow(true);
}

// {^
void CImagerDlg::OnBnClickedCloseDocBtn()
{
	MlpCloseDoc();
	pageCount = 0;

	m_UninitBtn.EnableWindow(true);
	m_OpenDocBtn.EnableWindow(true);
	m_CloseDocBtn.EnableWindow(false);
	m_PasswordEnc.EnableWindow(false);
	m_PasswordEnc.SetWindowText("(JۂɃpX[hKvȏꍇ܂B)");
	m_PageToPictBtn.EnableWindow(false);
	m_mode.SetWindowText("(\܂͈)");
	m_PageRangeRb->EnableWindow(false);
	m_PageNumRb->EnableWindow(false);
	m_PageListEdt.EnableWindow(false);
	m_PageListEdt.SetWindowText("");
	m_PngRb->EnableWindow(false);
	m_JpegRb->EnableWindow(false);
	m_TiffRb->EnableWindow(false);

	m_OcgBtn.EnableWindow(false);
	m_DocTitle.EnableWindow(false);
	m_DocTitle.SetWindowText("^Cg");
	m_DocVersion.EnableWindow(false);
	m_DocVersion.SetWindowText("PDFx.x");
	m_NPages.EnableWindow(false);
	m_NPages.SetWindowText("y[W");
	m_PageBounds.EnableWindow(false);
	m_PageBounds.SetWindowText("y[WE");
	m_ResultSize.SetWindowText("( 悱 x  )");
	m_WtmImgChk.EnableWindow(false);
	m_WtmStrChk.EnableWindow(false);
	m_FontInfoBtn.EnableWindow(false);
	m_MediaBoxRb->EnableWindow(false);
	m_CropBoxRb->EnableWindow(false);
	m_BleedBoxRb->EnableWindow(false);
	m_TrimBoxRb->EnableWindow(false);
	m_ArtBoxRb->EnableWindow(false);
}

//o̓t@CQ
void CImagerDlg::OnBnClickedResFileRefBtn()
{
	CFileDialog	dlg(false, NULL, "out", OFN_READONLY | OFN_OVERWRITEPROMPT, "PNG摜(*.png)|*.png|JPEG摜(*.jpg)|*.jpg;*.jpeg|TIFF摜(*.tiff)|*.tiff, *.tif|ׂẲ摜`|*.png;*.jpg;*.jpeg;*.tiff;*.tif|ׂ(*.*)|*.*||");
	if(dlg.DoModal() != IDOK) return;
	m_PngRb->SetCheck(BST_UNCHECKED);
	m_JpegRb->SetCheck(BST_UNCHECKED);
	m_TiffRb->SetCheck(BST_UNCHECKED);
	if(dlg.GetFileExt() == "png"){
		m_PngRb->SetCheck(BST_CHECKED);
	}else if(dlg.GetFileExt() == "jpg" || dlg.GetFileExt() == "jpeg"){
		m_JpegRb->SetCheck(BST_CHECKED);
	}else if(dlg.GetFileExt() == "tiff" || dlg.GetFileExt() == "tif"){
		m_TiffRb->SetCheck(BST_CHECKED);
	}else{
		MessageBox("̉摜`ɂ͕ϊł܂B");
		m_PngRb->SetCheck(BST_CHECKED);
		return;
	}
	m_OutFileEdt.SetWindowText(dlg.GetPathName());
}

//摜쐬 {^
void CImagerDlg::OnBnClickedPageToPictBtn()
{
	CWaitCursor	*wait = NULL;
	CString	pg, out;
	MessageDlg	dlg;

	//PDF̃o[W
	if(pdfVersion < 14 || pdfVersion > 17){
		CString	s;
		s.Format("PDF%g ͉摜ɕϊł܂B", pdfVersion / 10.f);
		MessageBox(s);
		return;
	}

	//y[W
	if(pageCount < 1){
		MessageBox("y[W܂");
		return;
	}

	//o̓t@C
	if(!OutFileCheck()) return;
	m_PageToPictBtn.EnableWindow(false);
	m_CloseDocBtn.EnableWindow(false);
	m_OkBtn.EnableWindow(false);

	//𑜓x
	CString	s;
	int		val;

	m_DpiEdt.GetWindowText(s);
	val = atoi(s);
	if(val < 50){
		val = 50;
		m_DpiEdt.SetWindowText("50");
	}else if(val > 10000){
		val = 10000;
		m_DpiEdt.SetWindowText("10000");
	}
	MlpSetPictureResolution(val);

	//i
	m_QualityEdt.GetWindowText(s);
	val = atoi(s);
	if(val < 10) val = 10;
	else if(val > 90) val = 90;
	MlpSetPictureQuality(val);

	//Fw
	if(m_ColorRb->GetCheck() == BST_CHECKED)		MlpSetPictureRGB();
	else if(m_GrayRb->GetCheck() == BST_CHECKED)	MlpSetPictureGray();
	else if(m_DitherRb->GetCheck() == BST_CHECKED)	MlpSetPictureDither();
	else if(m_BwRb->GetCheck() == BST_CHECKED)		MlpSetPictureBW();

	//J[vt@C
	switch(colorprofileDlg->m_conv){
		case CONVERT_BY_COLOR_PROFILE:
			MlpSetRGBProfile((TCHAR*)(LPCTSTR)colorprofileDlg->rgbProfileName);
			MlpSetCMYKProfile((TCHAR*)(LPCTSTR)colorprofileDlg->cmykProfileName);
		case CONVERT_FAST:
		case CONVERT_MOST_FAST:
			MlpSetColorConvertForImage(CONVERT_CMYK_TO_RGB, colorprofileDlg->m_conv);
			break;
		default:
			break;
	}

	//A`GCAX
	MlpSetPicture(MLP_FILL_PATH_AA, m_AntiAliasPathChk.GetCheck() == BST_CHECKED ? 0 : 1);		/*0:}A1:ʏ*/
	MlpSetPicture(MLP_TEXT_ANTIALIAS, m_AntiAliasTextChk.GetCheck() == BST_CHECKED ? 0 : 1);	/*0:}A1:ʏ*/

	//ŏ
	m_MinLineWidthEdt.GetWindowText(s);
	if(0 < s.GetLength()){
		float w = (float)atof(s);
		if(0 < w) MlpSetPicture(MLP_STROKEPATH_MINIMUM_LINE_WIDTH, w);
	}

	//TIFF`̈kw
	if(m_CompressNoneRb->GetCheck() == BST_CHECKED)			MlpSetTiffCompress(MLP_TIFF_COMPRESS_NONE);
	else if(m_CompressJpegRb->GetCheck() == BST_CHECKED)	MlpSetTiffCompress(MLP_TIFF_COMPRESS_JPEG);
	else if(m_CompressDeflateRb->GetCheck() == BST_CHECKED)	MlpSetTiffCompress(MLP_TIFF_COMPRESS_DEFLATE);
	else if(m_CompressLzwRb->GetCheck() == BST_CHECKED)		MlpSetTiffCompress(MLP_TIFF_COMPRESS_LZW);
	else													MlpSetTiffCompress(MLP_TIFF_COMPRESS_DEFLATE);

	//LoXTCY
	int		x, y;
	m_CvsSizeXEdt.GetWindowText(s);	x = atoi(s);
	m_CvsSizeYEdt.GetWindowText(s);	y = atoi(s);
	if(x < 10){ x = 0; m_CvsSizeXEdt.SetWindowText("");	}
	if(y < 10){	y = 0; m_CvsSizeYEdt.SetWindowText("");	}
	MlpSetCanvasSize(x, y);

	//摜TCY
	m_PictSizeXEdt.GetWindowText(s);
	x = atoi(s);
	m_PictSizeYEdt.GetWindowText(s);
	y = atoi(s);
	if(x < 0) x = 0;
	if(y < 0) y = 0;
	if(((0 < x) && (x < 10)) || ((0 < y) && (y < 10))){
		MessageBox("摜TCY x ܂ y ܂B");
		goto end_proc;
	}
	if((10 <= x) || (10 <= y)){
		if(m_UnitPercentRb->GetCheck() == BST_CHECKED)	MlpSetPictureSize(x, y, MLP_PICTURE_UNIT_PERCENT);
		else if(m_UnitInchRb->GetCheck() == BST_CHECKED)MlpSetPictureSize(x, y, MLP_PICTURE_UNIT_INCH);
		else if(m_UnitMmRb->GetCheck() == BST_CHECKED)	MlpSetPictureSize(x, y, MLP_PICTURE_UNIT_MM);
		else{
			MessageBox("摜TCY̒Pʂw肵ĂB");
			goto end_proc;
		}
	}

	//
	if(m_WtmImgChk.GetCheck() == BST_CHECKED){
		CString	s;
		m_WtmImgFileNameEdt.GetWindowText(s);
		if(0 < s.GetLength())
			MlpSetImageWatermark(s, wtmImgDlg->m_xpos, wtmImgDlg->m_ypos, m_WtmImgForegroundChk.GetCheck() == BST_CHECKED ? 1 : -1, wtmImgDlg->m_xscale, wtmImgDlg->m_yscale, wtmImgDlg->m_alpha);
	}
	if(m_WtmStrChk.GetCheck() == BST_CHECKED){
		CString	s;
		m_WtmStringEdt.GetWindowText(s);
		if(0 < s.GetLength()){
			if(wtmStrDlg->m_filltext)
				MlpSetFillTextWatermark(s, wtmStrDlg->m_fontname, wtmStrDlg->m_xpos, wtmStrDlg->m_ypos, m_WtmStrForegroundChk.GetCheck() == BST_CHECKED ? 1 : -1, wtmStrDlg->m_fontsize, (LPCTSTR)wtmStrDlg->m_fontcolor, wtmStrDlg->m_alpha);
			else
				MlpSetStrokeTextWatermark(s, wtmStrDlg->m_fontname, wtmStrDlg->m_xpos, wtmStrDlg->m_ypos, m_WtmStrForegroundChk.GetCheck() == BST_CHECKED ? 1 : -1, wtmStrDlg->m_fontsize, (LPCTSTR)wtmStrDlg->m_fontcolor, wtmStrDlg->m_alpha);
		}
	}

	//񏈗
	MlpSetPicture(MLP_THREAD_SPLIT_PAGE, m_SplitPageChk.GetCheck() == BST_CHECKED ? 1 : 0);
	MlpSetPicture(MLP_THREAD_EACH_PAGE, m_EachPageChk.GetCheck() == BST_CHECKED ? 1 : 0);
	if(0 < threadDetailDlg->m_nthread){
		MlpSetPicture(MLP_THREAD_SPLIT_PAGE_COUNT, threadDetailDlg->m_nthread);
		MlpSetPicture(MLP_THREAD_EACH_PAGE_COUNT, threadDetailDlg->m_nthread);
	}

	//摜쐬
	wait = new CWaitCursor;
	if(m_TiffRb->GetCheck() == BST_CHECKED){
		int		res;
		m_PageListEdt.GetWindowText(pg);
		if(pg.GetLength() < 1) pg.Format("1-%d", pageCount);
		m_OutFileEdt.GetWindowText(out);
		if(out.GetLength() < 1) out = "out.tiff";
		res = MlpCreateTiffMulti(pg, (TCHAR*)(LPCTSTR)out);
		if(res > 0){
			CString	s;
			s.Format("S%dy[W̉摜𐶐܂B", res);
			dlg.DoModal(s, out);
			goto end_proc;
		}
		else if(res < 0){
			MessageBox("摜ϊs");
			goto end_proc;
		}
	}else if((m_JpegRb->GetCheck() == BST_CHECKED)||(m_PngRb->GetCheck() == BST_CHECKED)){
		m_PageListEdt.GetWindowText(pg);
		int p = atoi(pg);
		if(p < 1) p = 1;
		else if(p > pageCount) p = pageCount;
		m_OutFileEdt.GetWindowText(out);
		if(out.GetLength() < 1) out = m_JpegRb->GetCheck() == BST_CHECKED ? "out.jpeg" : "out.png";
		if(MlpCreatePict(p, (TCHAR*)(LPCTSTR)out) != 0){
			MessageBox("摜ϊs");
			goto end_proc;
		}
	}else{
		MessageBox("摜`s");
		goto end_proc;
	}

	//I
	dlg.DoModal(CString("쐬"), out);
end_proc:
	delete wait;
	m_PageToPictBtn.EnableWindow(true);
	m_CloseDocBtn.EnableWindow(true);
	m_OkBtn.EnableWindow(true);
	m_OkBtn.SetFocus();
	return;
}

//摜tH[}bg TIFF`FbN{^
void CImagerDlg::OnBnClickedTiffRb()
{
	CString	s;
	int		p;

	if(m_TiffRb->GetCheck() != BST_CHECKED){
		m_CompressNoneRb->EnableWindow(false);
		m_CompressDeflateRb->EnableWindow(false);
		m_CompressLzwRb->EnableWindow(false);
		m_CompressJpegRb->EnableWindow(false);
		return;
	}else{
		m_CompressNoneRb->EnableWindow(true);
		m_CompressDeflateRb->EnableWindow(true);
		m_CompressLzwRb->EnableWindow(true);
		m_CompressJpegRb->EnableWindow(true);
	}
	if(pageCount < 1){MessageBox("݂PDFɃy[W܂B");return;}

	//o̓t@C
	m_OutFileEdt.GetWindowText(s);
	p = s.MakeLower().ReverseFind('.');
	if(p >= 0){
		m_OutFileEdt.SetWindowText(s.Left(p) + ".tiff");
	}else{
		if(s.GetLength())
			m_OutFileEdt.SetWindowText(s + ".tiff");
		else
			m_OutFileEdt.SetWindowText("out.tiff");
	}

	//y[Ww
	m_PageRangeRb->SetCheck(BST_CHECKED);
	m_PageNumRb->SetCheck(BST_UNCHECKED);
	m_PageRangeRb->EnableWindow(true);
	m_PageNumRb->EnableWindow(true);
	m_AllPagesRb->EnableWindow(true);
	m_PageSel.SetWindowText("y[W͈");
	m_SingleFileChk.ShowWindow(SW_SHOW);
	if(!m_CloseDocBtn.IsWindowEnabled()) return;
	m_PageListEdt.GetWindowText(s);
	p = atoi(s);
	if(p < 1) p = 1;
	s.Format("%d-%d", p , pageCount);
	m_PageListEdt.SetWindowText(s);
}

//摜tH[}bgJPEG `FbN{^
void CImagerDlg::OnBnClickedJpegRb()
{
	CString	s;
	int		p;

	if(m_JpegRb->GetCheck() != BST_CHECKED) return;
	else{
		//kw
		m_CompressNoneRb->EnableWindow(false);
		m_CompressDeflateRb->EnableWindow(false);
		m_CompressLzwRb->EnableWindow(false);
		m_CompressJpegRb->EnableWindow(false);
	}
	if(pageCount < 1){MessageBox("݂PDFɃy[W܂B");return;}

	//o̓t@C
	m_OutFileEdt.GetWindowText(s);
	p = s.MakeLower().ReverseFind('.');
	if(p >= 0){
		m_OutFileEdt.SetWindowText(s.Left(p) + ".jpg");
	}else{
		if(s.GetLength())
			m_OutFileEdt.SetWindowText(s + ".jpg");
		else
			m_OutFileEdt.SetWindowText("out.jpg");
	}

	//y[Ww
	m_PageRangeRb->SetCheck(BST_UNCHECKED);
	m_PageNumRb->SetCheck(BST_CHECKED);
	m_AllPagesRb->SetCheck(BST_UNCHECKED);
	m_PageRangeRb->EnableWindow(false);
	m_PageNumRb->EnableWindow(false);
	m_AllPagesRb->EnableWindow(false);
	m_PageSel.SetWindowText("y[Wԍ");
	m_SingleFileChk.ShowWindow(SW_HIDE);
	if(!m_CloseDocBtn.IsWindowEnabled()) return;
	m_PageListEdt.GetWindowText(s);
	p = atoi(s);
	if(p < 1) p = 1;
	s.Format("%d", p);
	m_PageListEdt.SetWindowText(s);
}

//摜tH[}bgPNG `FbN{^
void CImagerDlg::OnBnClickedPngRb()
{
	CString	s;
	int		p;

	if(m_PngRb->GetCheck() != BST_CHECKED) return;
	else{
		//kw
		m_CompressNoneRb->EnableWindow(false);
		m_CompressDeflateRb->EnableWindow(false);
		m_CompressLzwRb->EnableWindow(false);
		m_CompressJpegRb->EnableWindow(false);
	}
	if(pageCount < 1){MessageBox("݂PDFɃy[W܂B");return;}

	//o̓t@C
	m_OutFileEdt.GetWindowText(s);
	p = s.MakeLower().ReverseFind('.');
	if(p >= 0){
		m_OutFileEdt.SetWindowText(s.Left(p) + ".png");
	}else{
		if(s.GetLength())
			m_OutFileEdt.SetWindowText(s + ".png");
		else
			m_OutFileEdt.SetWindowText("out.png");
	}

	//y[Ww
	m_PageRangeRb->SetCheck(BST_UNCHECKED);
	m_PageNumRb->SetCheck(BST_CHECKED);
	m_AllPagesRb->SetCheck(BST_UNCHECKED);
	m_PageRangeRb->EnableWindow(false);
	m_PageNumRb->EnableWindow(false);
	m_AllPagesRb->EnableWindow(false);
	m_PageSel.SetWindowText("y[Wԍ");
	m_SingleFileChk.ShowWindow(SW_HIDE);
	if(!m_CloseDocBtn.IsWindowEnabled()) return;
	m_PageListEdt.GetWindowText(s);
	p = atoi(s);
	if(p < 1) p = 1;
	s.Format("%d", p);
	m_PageListEdt.SetWindowText(s);
}

//PDFt@CQƃ{^
void CImagerDlg::OnBnClickedFileRefBtn()
{
	CFileDialog	dlg(true, "pdf", NULL, OFN_READONLY | OFN_OVERWRITEPROMPT, "PDFt@C(*.pdf)|*.pdf|ׂ(*.*)|*.*||");
	if(dlg.DoModal() != IDOK) return;
	m_FileNameEdt.SetWindowText(dlg.GetPathName());
}

//Py[Ww {^
void CImagerDlg::OnBnClickedPageRb()
{
	CString	s;

	if(pageCount < 1){
		MessageBox("JĂPDFɃy[W܂B");
		return;
	}
	if(m_PageRangeRb->GetCheck() == BST_CHECKED){
		s.Format("1-%d", pageCount);
	}else{
		s = "1";
	}
	m_PageListEdt.SetWindowText(s);
}

//Sy[Ww {^
void CImagerDlg::OnBnClickedPageWholeRb()
{
	CString	s;

	if(pageCount < 1){
		MessageBox("JĂPDFɃy[W܂B");
		return;
	}
	if(m_AllPagesRb->GetCheck() == BST_CHECKED){
		s.Format("1-%d", pageCount);
	}else{
		s = "1";
	}
	m_PageListEdt.SetWindowText(s);
}

//y[Wԍ̎w肪ύXꂽ
void CImagerDlg::OnEnChangePageListEdt()
{
	CString	s;

	if(!m_CloseDocBtn.IsWindowEnabled()){
		m_PageSize.EnableWindow(false);
		m_PageSize.SetWindowText("y[WTCY");
		m_OcgCount.EnableWindow(false);
		m_OcgCount.SetWindowText("(OCG)");
		m_PageRotate.EnableWindow(false);
		m_PageRotate.SetWindowText("y[W]");
		return;
	}
	if(pageCount < 1) return;
	m_PageListEdt.GetWindowText(s);
	int pageNum = atoi(s);
	if(pageNum < 0 || pageCount < pageNum) pageNum = pageCount;

	//y[W̉]
	int rotate;
	MlpGetPageRotation(pageNum, &rotate);
	if(rotate){
		s.Format("y[W]: %d", rotate);
		m_PageRotate.SetWindowText(s);
	}else
		m_PageRotate.SetWindowText("y[W]: Ȃ");
	m_PageRotate.EnableWindow(true);

	//y[W̃IWiTCY
	PageOrgSize(pageNum);

	//y[W̉摜TCY
	PagePictSize(pageNum);
}

//𑜓xύXꂽ
void CImagerDlg::OnEnChangeDpiEdt()
{
	CString	s;

	m_DpiEdt.GetWindowText(s);
	if(atoi(s) < 10){
		m_PageSize.EnableWindow(false);
		m_PageSize.SetWindowText("y[WTCY");
		return;
	}

	/*y[WTCY*/
	int pageCount = MlpPageCount();
	if(pageCount < 1) return;
	m_PageListEdt.GetWindowText(s);
	int pageNum = atoi(s);
	if(pageNum < 0) pageNum = pageCount;
	PagePictSize(pageNum);
}

//OCG\
void CImagerDlg::OnBnClickedOcgBtn()
{
	LayerDlg	dlg;
	MlpOcgUsage	*usage;

	int	nOcg = MlpGetOcgCount();
	MlpGetOcgUsage(&usage);

	dlg.DoModal(usage, nOcg);
}

//tHg\
void CImagerDlg::OnBnClickedFontInfoBtn()
{
	PrsFontName	*fontName;
	FontInfoDlg	dlg;
	int		len;

	if(!MlpPrsGetFontInfo(&fontName, &len)){
		if(len)
			dlg.DoModal(fontName ,len);
		else
			MessageBox("tHg񂪂܂");
	}
}

//摜
void CImagerDlg::OnBnClickedWtmImgFileRefBtn()
{
	CFileDialog	dlg(true, NULL, NULL, OFN_READONLY | OFN_OVERWRITEPROMPT, "摜(*.png,*.jpg,*.tiff)|*.png;*.jpg;*.jpeg;*.tiff;*.tif|ׂ(*.*)|*.*||");
	if(dlg.DoModal() != IDOK) return;
	m_WtmImgFileNameEdt.SetWindowText(dlg.GetPathName());
}

//
void CImagerDlg::OnBnClickedWtmImgChk()
{
	if(m_WtmImgChk.GetCheck() == BST_CHECKED){
		m_WtmImgForegroundChk.EnableWindow(true);
		m_WtmImgFileNameEdt.EnableWindow(true);
		m_WtmImgFileRefBtn.EnableWindow(true);
		m_WtmImgDetailBtn.EnableWindow(true);
	}else{
		m_WtmImgForegroundChk.EnableWindow(false);
		m_WtmImgFileNameEdt.EnableWindow(false);
		m_WtmImgFileRefBtn.EnableWindow(false);
		m_WtmImgDetailBtn.EnableWindow(false);
	}
}

void CImagerDlg::OnBnClickedWtmStrChk()
{
	if(m_WtmStrChk.GetCheck() == BST_CHECKED){
		m_WtmStrForegroundChk.EnableWindow(true);
		m_WtmStringEdt.EnableWindow(true);
		m_WtmStrDetailBtn.EnableWindow(true);
	}else{
		m_WtmStrForegroundChk.EnableWindow(false);
		m_WtmStringEdt.EnableWindow(false);
		m_WtmStrDetailBtn.EnableWindow(false);
	}
}

void CImagerDlg::OnBnClickedWtmImgDetailBtn()
{
	CString	s;

	m_WtmImgFileNameEdt.GetWindowText(wtmImgDlg->m_filename);
	wtmImgDlg->m_foreground = (m_WtmImgForegroundChk.GetCheck() == BST_CHECKED);
	if(IDOK == wtmImgDlg->DoModal()){
		m_WtmImgFileNameEdt.SetWindowText(wtmImgDlg->m_filename);
		if(wtmImgDlg->m_foreground)
			m_WtmImgForegroundChk.SetCheck(BST_CHECKED);
		else
			m_WtmImgForegroundChk.SetCheck(BST_UNCHECKED);
	}
}

void CImagerDlg::OnBnClickedWtmStrDetailBtn()
{
	CString	s;

	m_WtmStringEdt.GetWindowText(wtmStrDlg->m_string);
	wtmStrDlg->m_foreground = (m_WtmStrForegroundChk.GetCheck() == BST_CHECKED);
	if(IDOK == wtmStrDlg->DoModal()){
		m_WtmStringEdt.SetWindowText(wtmStrDlg->m_string);
		if(wtmStrDlg->m_foreground)
			m_WtmStrForegroundChk.SetCheck(BST_CHECKED);
		else
			m_WtmStrForegroundChk.SetCheck(BST_UNCHECKED);
	}
}

//t@C
void CImagerDlg::OnBnClickedInitFileChk()
{
	if(m_InitFileChk.GetCheck() == BST_CHECKED){
		m_InitFileNameEdt.EnableWindow(true);
		m_InitFileRefBtn.EnableWindow(true);
	}else{
		m_InitFileNameEdt.EnableWindow(false);
		m_InitFileRefBtn.EnableWindow(false);
	}
}

//J[vt@C
void CImagerDlg::OnBnClickedColorprofileBtn()
{
	colorprofileDlg->DoModal();
}

//Xbh
void CImagerDlg::OnBnClickedTreadDetailBtn()
{
	int	cpu;

	MlpGetLibraryInfo(MLP_LOGICAL_CPU_COUNT, &cpu);
	threadDetailDlg->DoModal(cpu, m_SplitPageChk.GetCheck() == BST_CHECKED, m_EachPageChk.GetCheck() == BST_CHECKED);
}

//EBhEI
void CImagerDlg::OnDestroy()
{
	if(wtmImgDlg) delete wtmImgDlg;
	if(wtmStrDlg) delete wtmStrDlg;
	if(colorprofileDlg) delete colorprofileDlg;
	if(threadDetailDlg) delete threadDetailDlg;
	wtmImgDlg = NULL;
	MlpUninitialize();
	CDialog::OnDestroy();
}
