// WatermarkImgDlg.cpp : t@C
/*
Copyright(c) 2021 ЃgXgE\tgEFAEVXe
f]ڂ֎~܂B
*/

#include "stdafx.h"
#include "Imager.h"
#include "WatermarkImgDlg.h"


// WatermarkImgDlg _CAO

IMPLEMENT_DYNAMIC(WatermarkImgDlg, CDialog)

WatermarkImgDlg::WatermarkImgDlg(CWnd* pParent /*=NULL*/)
	: CDialog(WatermarkImgDlg::IDD, pParent)
{
	InitValue();
}

WatermarkImgDlg::~WatermarkImgDlg()
{
}

void WatermarkImgDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_FILE_NAME_EDT, m_FileNameEdt);
	DDX_Control(pDX, IDC_XPOS_EDT, m_XposEdt);
	DDX_Control(pDX, IDC_YPOS_EDT, m_YposEdt);
	DDX_Control(pDX, IDC_XSCALE_EDT, m_XscaleEdt);
	DDX_Control(pDX, IDC_YSCALE_EDT, m_YscaleEdt);
	DDX_Control(pDX, IDC_ALPHA_EDT, m_AlphaEdt);
}


BEGIN_MESSAGE_MAP(WatermarkImgDlg, CDialog)
	ON_BN_CLICKED(IDC_FILE_REF_BTN, &WatermarkImgDlg::OnBnClickedFileRefBtn)
END_MESSAGE_MAP()

void WatermarkImgDlg::InitValue()
{
	m_filename = "";
	m_xpos = m_ypos = 0;
	m_ForegroundRb = false;
	m_xscale = m_yscale = m_alpha = 1.0f;
}

// WatermarkImgDlg bZ[W nh

BOOL WatermarkImgDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	CString	s;

	m_ForegroundRb = (CButton*)GetDlgItem(IDC_FOREGROUND_RB);
	m_BackgroundRb = (CButton*)GetDlgItem(IDC_BACKGROUND_RB);
	m_FileNameEdt.SetWindowText(m_filename);
	s.Format("%d", m_xpos); m_XposEdt.SetWindowText(s);
	s.Format("%d", m_ypos); m_YposEdt.SetWindowText(s);
	s.Format("%g", m_xscale); m_XscaleEdt.SetWindowText(s);
	s.Format("%g", m_yscale); m_YscaleEdt.SetWindowText(s);
	s.Format("%g", m_alpha * 100.0f); m_AlphaEdt.SetWindowText(s);
	if(m_foreground){
		m_ForegroundRb->SetCheck(BST_CHECKED);
		m_BackgroundRb->SetCheck(BST_UNCHECKED);
	}else{
		m_ForegroundRb->SetCheck(BST_UNCHECKED);
		m_BackgroundRb->SetCheck(BST_CHECKED);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void WatermarkImgDlg::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	CString	s;
	m_FileNameEdt.GetWindowText(m_filename);
	m_XposEdt.GetWindowText(s); m_xpos = atoi(s);
	m_YposEdt.GetWindowText(s); m_ypos = atoi(s);
	m_XscaleEdt.GetWindowText(s); m_xscale = (float)atof(s);
	m_YscaleEdt.GetWindowText(s); m_yscale = (float)atof(s);
	m_AlphaEdt.GetWindowText(s); m_alpha = (float)(atof(s) / 100.0f);
	m_foreground = (m_ForegroundRb->GetCheck() == BST_CHECKED);

	CDialog::OnOK();
}

//摜
void WatermarkImgDlg::OnBnClickedFileRefBtn()
{
	CFileDialog	dlg(true, NULL, NULL, OFN_READONLY | OFN_OVERWRITEPROMPT, "摜(*.png,*.jpg,*.tiff)|*.png;*.jpg;*.jpeg;*.tiff;*.tif|ׂ(*.*)|*.*||");
	if(dlg.DoModal() != IDOK) return;
	m_FileNameEdt.SetWindowText(dlg.GetPathName());
}
