/*
**	toJPEG Sample application
*/
/*
Copyright(c) 2021 ЃgXgE\tgEFAEVXe,All Rights Reserved.
*/

#include <stdio.h>
#include "ImagerLp.h"


#pragma comment(lib,"PdfImagerLP.lib")

/* R[obN֐ */
void __stdcall RenderingCB(int pageNum)
{
	printf("y[W %d ̃_OJn\n", pageNum);
}
void WINAPI ProgressCB(int lines, int totalLines)
{
	printf("%d / %d sI\n", lines, totalLines);
}

int main(int argc, char* argv[])
{
	int		pages;
	int		res, ret = 0;

	/**/
	switch(MlpInitialize(TEXT("0-0395-923KH7539E9G"))){
	case  MLP_ALREADY_INITIALIZED:
		printf("ɏĂ܂B\n");
		return 1;
	case MLP_NOT_INITIALIZED:
		printf("ł܂łB\n");
		return 1;
	case MLP_LICENSE_ERROR:
		printf("CZXsłB\n");
		return 1;
	}

	/*CZX*/
	MlpShowLicenseInfo();

	/*t@C*/
	switch(MlpLoadInitFile(TEXT("../../init.xml"))){
	case MLP_NOT_INITIALIZED:
		printf("Ă܂B\n");
		return 3;
	case MLP_INIT_FILE_OPEN_ERROR:
		printf("t@Cǂ߂܂B\n");
		ret = 3;
		goto end_proc2;
	}

	/*I[v*/
	switch(MlpOpenDoc(TEXT("../../../doc/PdfImager-LP.pdf"), TEXT(""), TEXT(""))){
	case MLP_NOT_INITIALIZED:
		printf("Ă܂B\n");
		return 4;
	case MLP_ALREADY_OPENED:
		printf("ɃI[vĂ܂B\n");
		ret = 4;
		goto end_proc2;
	case MLP_FILE_OPEN_ERROR:
		printf("I[vł܂B\n");
		ret = 4;
		goto end_proc2;
	case MLP_FILE_IS_NOT_PDF:
		printf("PDFł͂܂B\n");
		ret = 4;
		goto end_proc2;
	case MLP_FILE_NOT_DECRYPTED:
		printf("ł܂łB\n");
		ret = 4;
		goto end_proc2;
	}

	/*PDF̃y[W*/
	pages = MlpPageCount();
	if(pages < 0){
		printf("G[\n");
		ret = 5;
		goto end_proc1;
	}else if(pages == 0){
		printf("y[W܂B\n");
		ret = 5;
		goto end_proc1;
	}else{
		printf("\"%s\"̑y[W %d łB\n", "PdfImager-LP.pdf", pages);
	}

	/*R[obN֐w*/
	MlpSetCallbackFunc(MLP_RENDERING_CB, 0, RenderingCB);
	MlpSetCallbackFunc(MLP_PROGRESS_CB, 500, ProgressCB);

	/*TCYw*/
	MlpSetPictureSize(0, 30, MLP_PICTURE_UNIT_PERCENT);

	/*摜̐ݒ*/
#if	1
	/*o͉摜RGBJ[摜ɂ*/
	res = MlpSetPictureRGB();
	if(res){
		printf("o͉摜RGBJ[摜ɐݒł܂B\n");
		ret = 2;
		goto end_proc2;
	}
#elif	0
	/*o͉摜O[XP[ɂ*/
	res = MlpSetPictureGray();
	if(res){
		printf("O[XP[ɐݒł܂B\n");
		ret = 2;
		goto end_proc2;
	}
#endif

	/*𑜓x*/
	MlpSetPicture(MLP_RESOLUTION_DPI, 150);

	/*摜i*/
	MlpSetPicture(MLP_JPEG_QUALITY, 75);

	/*摜쐬*/
	switch(ret = MlpCreatePict(1, TEXT("out.jpg"))){
	case MLP_PDF_HAS_NOT_PAGE:
		printf("y[W܂B\n");
		ret = 6;
		break;
	case MLP_INVALID_PAGE_NUMBER:
		printf("y[WsłB\n");
		ret = 6;
		break;
	case MLP_NO_OUTPUT_FILE:
		printf("o͉摜w肵ĂB\n");
		ret = 6;
		break;
	case MLP_TOO_LARGE_PIXEL:
		printf("摜傫܂B\n");
		ret = 6;
		break;
	case MLP_DRAW_ERROR:
		printf("摜쐬Ɏs܂B\n");
		ret = 6;
		break;
	default:
		if(ret < 0){
			printf("摜쐬Ɏs(%d)\n", ret);
			ret = 4;
		}
		break;
	}

	/*PNG摜o*/
//	MlpCreatePict(1, "out.png");

	/*N[Y*/
end_proc1:
	MlpCloseDoc();

	/*n*/
end_proc2:
	MlpUninitialize();

	return ret;
}

