/*
**	toTiffMulti Sample application
*/
/*
Copyright(c) 2021 ЃgXgE\tgEFAEVXe,All Rights Reserved.
*/

#include <stdio.h>
#include <Windows.h>
#include "ImagerLp.h"


#pragma comment(lib,"PdfImagerLP.lib")

/* R[obN֐ */
void __stdcall RenderingCB(int pageNum)
{
	printf("y[W %d ̃_OJn\n", pageNum);
}
void WINAPI ProgressCB(int lines, int totalLines)
{
	printf("%d / %d sI\n", lines, totalLines);
}

int main(int argc, char* argv[])
{
	int		ret = 0;

	/**/
	switch(MlpInitialize(TEXT("0-0395-923KH7539E9G"))){
	case  MLP_ALREADY_INITIALIZED:
		printf("ɏĂ܂B\n");
		return 1;
	case MLP_NOT_INITIALIZED:
		printf("ł܂łB\n");
		return 1;
	case MLP_LICENSE_ERROR:
		printf("CZXsłB\n");
		return 1;
	}

	/*ׂẴo[WPDFe*/
	MlpSetPicture(MLP_ALLOW_PDF_ALL);

	/*I[v*/
	switch(MlpOpenDoc(TEXT("../../../doc/PdfImager-LP.pdf"), NULL, NULL)){
	case MLP_NOT_INITIALIZED:
		printf("Ă܂B\n");
		return 2;
	case MLP_ALREADY_OPENED:
		printf("ɃI[vĂ܂B\n");
		ret = 2;
		goto end_proc;
	case MLP_FILE_OPEN_ERROR:
		printf("I[vł܂B\n");
		ret = 2;
		goto end_proc;
	case MLP_FILE_IS_NOT_PDF:
		printf("PDFł͂܂B\n");
		ret = 2;
		goto end_proc;
	case MLP_FILE_NOT_DECRYPTED:
		printf("ł܂łB\n");
		ret = 2;
		goto end_proc;
	}

	/*R[obN֐w*/
	MlpSetCallbackFunc(MLP_RENDERING_CB, 0, RenderingCB);
	MlpSetCallbackFunc(MLP_PROGRESS_CB, 500, ProgressCB);

	/*TCYw*/
	MlpSetPictureSize(0, 30, MLP_PICTURE_UNIT_PERCENT);

	/*
	 * 摜ݒ
	 */
	/*RGBJ[*/
#if	1
	MlpSetPictureRGB();				/*̐ݒ*/
#elif	0
	MlpSetPictureGray();
#elif	0
	MlpSetPictureDither();
#elif	0
	MlpSetPictureBW();
#endif

	/*k*/
#if	0
	MlpSetPicture(MLP_COMPRESS_DEFLATE);	/*̈k*/
#elif	1
	MlpSetPicture(MLP_COMPRESS_JPEG);
//	MlpSetPicture(MLP_COMPRESS_JPEG, 50);	/*摜̕i𓯎Ɏw肷ꍇ*/
#elif	0
	MlpSetPicture(MLP_COMPRESS_LZW);
#elif	0
	MlpSetPicture(MLP_COMPRESS_NONE);		/*kȂ*/
#endif

	/*𑜓x*/
	MlpSetPicture(MLP_RESOLUTION_DPI, 150);	/*̉𑜓x*/

	/*JPEG掿*/
	MlpSetPicture(MLP_JPEG_QUALITY, 75);	/*̕i*/

	/*摜쐬*/
#if	1
	switch(ret = MlpCreateTiffRange(0, -1, TEXT("outm.tiff"))){	/*y[W̏ԁF*/
#else
	switch(ret = MlpCreateTiffRange(-1, 0, TEXT("outm.tiff"))){	/*y[W̏ԁF~*/
#endif
	case MLP_PDF_HAS_NOT_PAGE:
		printf("y[W܂B\n");
		ret = 3;
		break;
	case MLP_INVALID_PAGE_NUMBER:
		printf("y[WsłB\n");
		ret = 3;
		break;
	case MLP_NO_OUTPUT_FILE:
		printf("o͉摜w肵ĂB\n");
		ret = 3;
		break;
	case MLP_TOO_LARGE_PIXEL:
		printf("摜傫܂B\n");
		ret = 3;
		break;
	case MLP_DRAW_ERROR:
		printf("摜쐬Ɏs܂B\n");
		ret = 3;
		break;
	case MLP_INVALID_PICT_TYPE:
		printf("ȉ摜`łB\n");
		ret = 3;
		break;
	default:
		if(ret < 0){ printf("摜쐬Ɏs(%d)\n", ret); ret = 4; }
		else   { printf("%dy[WTIFF摜쐬\n", ret); ret = 0; }
		break;
	}

	/*N[Y*/
	MlpCloseDoc();

	/*n*/
end_proc:
	MlpUninitialize();

	return ret;
}

