﻿/*
**	Imager-LP互換ヘッダ
**		version 1.10.2
*/
/*
Copyright(c)2025 株式会社トラスト・ソフトウェア・システム, All Rights Reserved.
*/

#ifndef IMAGER_LP_H
#define IMAGER_LP_H

#include <Windows.h>

#ifdef DLL_EXPORTS
#ifndef MLPAPI
#define MLPAPI __declspec(dllexport)
#endif
#else
#ifndef MLPAPI
#define MLPAPI __declspec(dllimport)
#endif
#endif

#ifdef	WINAPI
#undef	WINAPI
#endif
#define	WINAPI	__stdcall

#include "MlpError.h"
#include "MlpDeclaration.h"

#ifdef	_UNICODE
#define	MlpInitialize			MlpInitializeW
#define	MlpAddLicense			MlpAddLicenseW
#define	MlpGetLicenseInfoStr	MlpGetLicenseInfoStrW
#define	MlpGetLicenseInfo		MlpGetLicenseInfoW
#define	MlpLoadInitFile			MlpLoadInitFileW
#define	MlpLoadInitData			MlpLoadInitDataW
#define	MlpOpenDoc0				MlpOpenDoc0W
#define	MlpOpenDoc				MlpOpenDocW
#define	MlpOpenDocUsage			MlpOpenDocUsageW
#define	MlpOpenMemDoc0			MlpOpenMemDoc0W
#define	MlpOpenMemDoc			MlpOpenMemDocW
#define	MlpOpenMemDocUsage		MlpOpenMemDocUsageW

#define	MlpGetMetadataString	MlpGetMetadataStringW

#define	MlpCreatePict			MlpCreatePictW
#define	MlpCreatePictData		MlpCreatePictDataW
#define	MlpPageToPict			MlpPageToPictW
#define	MlpConvertToTiff		MlpConvertToTiffW
#define	MlpCreateTiffRange		MlpCreateTiffRangeW
#define	MlpCreateTiffMulti		MlpCreateTiffMultiW
#define	MlpRangeToTiff			MlpRangeToTiffW
#define	MlpMultiPageToTiff		MlpMultiPageToTiffW

#else
#define	MlpInitialize			MlpInitializeA
#define	MlpAddLicense			MlpAddLicenseA
#define	MlpGetLicenseInfoStr	MlpGetLicenseInfoStrA
#define	MlpGetLicenseInfo		MlpGetLicenseInfoA
#define	MlpLoadInitFile			MlpLoadInitFileA
#define	MlpLoadInitData			MlpLoadInitDataA
#define	MlpOpenDoc0				MlpOpenDoc0A
#define	MlpOpenDoc				MlpOpenDocA
#define	MlpOpenDocUsage			MlpOpenDocUsageA
#define	MlpOpenMemDoc0			MlpOpenMemDoc0A
#define	MlpOpenMemDoc			MlpOpenMemDocA
#define	MlpOpenMemDocUsage		MlpOpenMemDocUsageA

#define	MlpGetMetadataString	MlpGetMetadataStringA

#define	MlpCreatePict			MlpCreatePictA
#define	MlpCreatePictData		MlpCreatePictDataA
#define	MlpPageToPict			MlpPageToPictA
#define	MlpConvertToTiff		MlpConvertToTiffA
#define	MlpCreateTiffRange		MlpCreateTiffRangeA
#define	MlpCreateTiffMulti		MlpCreateTiffMultiA
#define	MlpRangeToTiff			MlpRangeToTiffA
#define	MlpMultiPageToTiff		MlpMultiPageToTiffA

#endif

#ifdef	__cplusplus
extern "C" {
#endif

	/*初期化*/
	MLPAPI int WINAPI MlpInitializeW(const wchar_t* license);
	MLPAPI int WINAPI MlpInitializeA(const char* license);
	MLPAPI void WINAPI MlpUninitialize();
	MLPAPI int WINAPI MlpAddLicenseA(const char* license);
	MLPAPI int WINAPI MlpLicenseIsValid();

	/*ライセンス情報*/
	MLPAPI void WINAPI MlpShowLicenseInfo();
	MLPAPI int WINAPI MlpGetLicenseInfoStrA(char* licenseStrPtr, int length);
	MLPAPI int WINAPI MlpGetLicenseInfoStr2(char* licenseStrPtr, int length);
	MLPAPI int WINAPI MlpGetLicenseInfoStrW(wchar_t* licenseStrPtr, int length);
	MLPAPI char* WINAPI MlpGetLicenseInfoA();
	MLPAPI wchar_t* WINAPI MlpGetLicenseInfoW();

	/*初期化データ*/
	MLPAPI int WINAPI MlpLoadInitFileW(const wchar_t* fileName);
	MLPAPI int WINAPI MlpLoadInitFileA(const char* fileName);
	MLPAPI int WINAPI MlpLoadInitDataW(const wchar_t* data, int len);
	MLPAPI int WINAPI MlpLoadInitDataA(const char* data, int len);

	/*オープン*/
	MLPAPI int WINAPI MlpOpenDoc0W(const wchar_t* fileName, const wchar_t* ownerPassword, const wchar_t* userPassword);
	MLPAPI int WINAPI MlpOpenDoc0A(const char* fileName, const char* ownerPassword, const char* userPassword);
	MLPAPI int WINAPI MlpOpenDocW(const wchar_t* fileName, const wchar_t* password);
	MLPAPI int WINAPI MlpOpenDocA(const char* fileName, const char* password);
	MLPAPI int WINAPI MlpOpenNewDoc(float width, float height, int rotate, void*);
	MLPAPI int WINAPI MlpOpenDocUsageW(const wchar_t* fileName, const wchar_t* password, int usage);
	MLPAPI int WINAPI MlpOpenDocUsageA(const char* fileName, const char* password, int usage);
	MLPAPI int WINAPI MlpOpenMemDocW(unsigned char* data, size_t len, const wchar_t* password);
	MLPAPI int WINAPI MlpOpenMemDocA(unsigned char* data, size_t length, const char* password);
	MLPAPI int WINAPI MlpOpenMemDocUsageW(unsigned char* data, size_t len, const wchar_t* password, int usage);
	MLPAPI int WINAPI MlpOpenMemDocUsageA(unsigned char* data, size_t length, const char* password, int usage);
	MLPAPI void WINAPI MlpCloseDoc();

	/*画像化*/
	MLPAPI int WINAPI MlpCreatePictW(int pageNumber, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpCreatePictA(int pageNumber, const char* outputFilePath);
	MLPAPI int WINAPI MlpCreatePictDataW(int pageNumber, const wchar_t* outputFormat, unsigned int* len, unsigned char** datap);
	MLPAPI int WINAPI MlpCreatePictDataA(int pageNumber, const char* outputFormat, unsigned int* len, unsigned char** datap);
	MLPAPI int WINAPI MlpPageToPictW(int pageNumber, int dpi, int quality, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpPageToPictA(int pageNumber, int dpi, int quality, const char* outputFilePath);
	MLPAPI int WINAPI MlpConvertToTiffW(const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpConvertToTiffA(const char* outputFilePath);
	MLPAPI int WINAPI MlpCreateTiffRangeW(int startPageNumber, int endPageNumber, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpCreateTiffRangeA(int startPageNumber, int endPageNumber, const char* outputFilePath);
	MLPAPI int WINAPI MlpCreateTiffMultiW(const wchar_t* pageList, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpCreateTiffMultiA(const char* pageList, const char* outputFilePath);
	MLPAPI int WINAPI MlpRangeToTiffW(int startPageNumber, int endPageNumber, int dpi, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpRangeToTiffA(int startPageNumber, int endPageNumber, int dpi, const char* outputFilePath);
	MLPAPI int WINAPI MlpMultiPageToTiffW(const wchar_t* pageList, int dpi, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpMultiPageToTiffA(const char* pageList, int dpi, const char* outputFilePath);

#ifdef	__cplusplus
}
#endif

#endif /*IMAGER_LP_H*/
