﻿/*
**	MlpDeclaration.h
**		version1.11.2
**/
/*
Copyright(c)2025 株式会社トラスト・ソフトウェア・システム, All Rights Reserved.
*/

#ifndef	MLP_DECLARATION_H
#define	MLP_DECLARATION_H

#include <time.h>
#include <Windows.h>

typedef	void* MlpStampData;

typedef enum MlpPictureOpt {
	MLP_PICTURE_RGB = 0,
	MLP_PICTURE_GRAY,
	MLP_PICTURE_DITHER,
	MLP_PICTURE_BW,
	MLP_PICTURE_FAXG3,
	MLP_PICTURE_FAXG4,

	MLP_COMPRESS_NONE,				/*TIFF変換の場合に圧縮なし*/
	MLP_COMPRESS_JPEG,				/*TIFF変換の場合にJPEG圧縮*/
	MLP_COMPRESS_DEFLATE,			/*TIFF変換の場合にDeflate圧縮*/
	MLP_COMPRESS_LZW,				/*TIFF変換の場合にLZW圧縮*/

	MLP_JPEG_QUALITY,				/*JPEG圧縮の画像品質*/

	MLP_RESOLUTION_DPI,				/*XDPI,YDPI双方同値の解像度*/
	MLP_RESOLUTION_XDPI,			/*XDPI 解像度*/
	MLP_RESOLUTION_YDPI,			/*YDPI 解像度*/
	MLP_CANVAS_SIZE,				/*キャンバスサイズ XY双方を指定*/
	MLP_CANVAS_XSIZE,				/*キャンバスサイズ X-方向のみを指定*/
	MLP_CANVAS_YSIZE,				/*キャンバスサイズ Y-方向のみを指定*/
	MLP_PICTURE_XSIZE,				/*論理サイズ幅を指定*/
	MLP_PICTURE_YSIZE,				/*論理サイズ高さを指定*/
	MLP_PICTURE_SIZE_UNIT,			/*論理サイズの単位*/
	MLP_PICTURE_USE_MEDIABOX=20,	/*ページの境界をMediaBoxにする*/
	MLP_PICTURE_USE_CROPBOX=21,		/*ページの境界をCropBoxにする*/
	MLP_PICTURE_USE_BLEEDBOX=22,	/*ページの境界をBleedBoxにする*/
	MLP_PICTURE_USE_TRIMBOX=23,		/*ページの境界をTrimBoxにする*/
	MLP_PICTURE_USE_ARTBOX=24,		/*ページの境界をArtBoxにする*/
	MLP_PIXEL_SIZE_X=25,			/*ピクセル単位の画像幅*/
	MLP_PIXEL_SIZE_Y,				/*ピクセル単位の画像高さ*/
	MLP_FILL_PATH_AA,				/*フィルパスのアンチアイリアス処理 MLP_GRAPHIC_AAの動作に変更*/
	MLP_CID_0_GLYPH,				/*文字コード0のグリフ処理 0:notdefを表示, 1:空白(gid=0)を表示, 2:この文字を無視*/
	MLP_PAGE_CLIP_VALUE=30,			/*ページをその領域より指定値ピクセル小さな領域でクリップする*/
	MLP_STROKEPATH_MINIMUM_LINE_WIDTH,	/*パスのストロークにおける最小線幅指定*/

	MLP_THRESHOLD_BITONAL,			/*二値化の閾値*/
	MLP_THRESHOLD_DITHER,			/*ディザ化の閾値*/

	MLP_PICTURE_CMYK=36,			/*CMYK色空間*/
	MLP_ANTIALIAS_LEVEL,			/*アンチアイリアスのレベル*/
	MLP_DATA_COMPRESSION_LEVEL,		/*データ圧縮のレベル*/
	MLP_PICTURE_USE_MEDIA_CROP=43,	/*ページの境界をMediaBoxまたはCropBoxの小さい方にする*/
	MLP_OCG_USAGE=44,				/*0:"view", 1:"Print", 2:"Export"*/
	MLP_XY_PIXEL_SIZE_MEM=47,		/*出来上がり画像データの物理サイズ (縦横でそれぞれのDPIに設定される)*/
	MLP_BITMAP_IMG_FORMAT=53,		/*BMP形式のデータフォーマット 0:Windows、1:OS/2*/
	MLP_USE_ZERO_LINE_WIDTH=55,		/*幅ゼロのストロークに対し、0:幅１ピクセルに変更(旧来互換)、1:アンチアイリアスのレベルに変更*/
	MLP_GRAPHIC_ANTIALIAS_LEVEL,	/*グラフィックのアンチアイリアスレベル*/
	MLP_TEXT_ANTIALIAS_LEVEL,		/*テキストのアンチアイリアスレベル*/
	MLP_BIGTIFF_CREATION_FLAG=58,	/*標準TIFFまたはBigTIFF画像生成切り替え*/
	MLP_CHANGE_PAGE_ROTATION=59,	/*PDF文書の現在ページを回転させる <<<非公開>>>*/
	MLP_ROTATE_PAGE_IMAGE=60,		/*PDF文書の現在ページを一時的に回転させる*/
	MLP_TRANSPARENT_PICT = 63,		/*透明な背景の画像を生成*/
	MLP_CANVAS_ALIGN_CENTER=64,		/*キャンバスを指定した際の配置位置を中心にする*/
	MLP_CANVAS_ALIGN_UPPER_LEFT=65,	/*キャンバスを指定した際の配置位置を左上にする*/
	MLP_CANVAS_ALIGN_LOWER_LEFT=66,	/*キャンバスを指定した際の配置位置を左下にする*/
	MLP_CANVAS_ALIGN_UPPER_RIGHT=67,/*キャンバスを指定した際の配置位置を右上にする*/
	MLP_CANVAS_ALIGN_LOWER_RIGHT=68,/*キャンバスを指定した際の配置位置を右下にする*/
	MLP_SUPPRESS_COMPONENT=71,		/*画像化の際に一部のコンポーネントを省略する*/

	/*PDFファイル生成*/
	MLP_PDF_RESOLUTION=301,			/*X,Y双方同値の解像度*/
	MLP_PDF_RESOLUTION_X,			/*X 解像度*/
	MLP_PDF_RESOLUTION_Y,			/*Y 解像度*/
	MLP_PDF_IMAGE_FORMAT,			/*ページ画像を格納する際の画像形式*/

	/*スタンプ*/
	STM_STAMP_INFO_CALLBACK=501,			/*スタンプ情報のコールバックを指定*/
	MLP_STAMP_INFO_CALLBACK=501,			/*スタンプ情報のコールバックを指定*/

	/*Secure 電子署名*/
	MLP_STROKEPATH_ENABLE_CALLBACK=1001,	/*ストロークパスのコールバックを有効にする*/
	MLP_TILE_IMAGE_ENABLE_CALLBACK,			/*タイル画像のコールバックを有効にする*/
	MLP_TILE_MASK_IMG_ENABLE_CALLBACK,		/*タイルマスク画像のコールバックを有効にする*/
	MLP_TILING_ENABLE_CALLBACK,				/*タイリングのコールバックを有効にする*/
	MLP_TILING_IGNORE_PROCESS,				/*タイリング処理を完全に無視する(この機能はサポートしない)*/
	MLP_SUPPRESS_ALPHA_CHANNEL_ON_CB,		/*コールバック時の画像データにアルファチャネル値を含めない*/
	MLP_PAGE_PICT_CREATED_ENABLE_CALLBACK,	/*複数ページ作成時のページ作成ごとコールバックを有効にする*/
	MLP_ONE_PAGE_CREATED_CALLBACK_ENABLE,	/*複数ページ作成時のコールバックを１ページでも有効にする*/

	/*以下　非公開*/
	MLP_NO_CHANGE_METADATA=30100,			/*1:作成するPDFのメタデータを変更する*/
	MLP_NO_CHANGE_DOC_INFO=30101,			/*1:作成するPDFのInfoとMetadataを変更しない*/
	MLP_CHANGE_CREATOR_TOOL_NAME=30102,		/*1:作成するPDFのInfoとMetadataの作成ツールを変更する*/

} MlpPictureOpt;

typedef enum MlpDocumentOpt {
	MLP_PERMISSION_FLAG=1201,	/*文書のパーミッションフラグ*/
	MLP_OCG_COUNT,				/*OCGの総数*/
	MLP_GLYPH_NOT_FOUND_COUNT,	/*グリフが検索できなかった数*/
	MLP_PDF_AUTHOR,
	MLP_NEEDS_PASSWORD,			/*0:非暗号化、1:NULLパスワードでオープン可、2:パスワードが必要*/
	MLP_PRINT_RESTRICTION=1207,	/*制限された印刷解像度フラグ値 1:限定された(低解像度)、0:無制限(高解像度)*/
	MLP_DOCUMENT_TITLE=1211,	/*PDF文書のタイトル*/
	MLP_CREATION_DATE,			/*生成日時*/
	MLP_MODIFICATION_DATE,		/*最新の変更日時*/
	MLP_ENCRYPT_VERSION,		/*文書の暗号化バージョン*/
	MLP_ENCRYPT_REVISION,		/*文書の暗号化レビジョン*/
	MLP_PDF_VERSION,			/*PDF文書のバージョン*/
	MLP_DOCUMENT_TITLE_LEN=1217,/*PDF文書のタイトル長*/
	MLP_DOCUMENT_TITLE_W,		/*PDF文書の WideCharの文字列*/
} MlpDocumentOpt;

typedef enum MlpLibraryOpt {
	MLP_LOGICAL_CPU_COUNT=101,		/*論理的なCPUの総数 _not used_ */
	MLP_THREAD_SPLIT_PAGE=102,		/*ページを複数のスレッドで実行*/
	MLP_THREAD_SPLIT_PAGE_COUNT,	/*ページを分割処理するスレッドの数*/
	MLP_THREAD_EACH_PAGE,			/*各ページを個別のスレッドで実行*/
	MLP_THREAD_EACH_PAGE_COUNT,		/*格ページを処理するスレッドの数*/

	MLP_LICENSE_ERROR_INFO = 1201,	/*不正ライセンスの詳細情報*/
} MlpLibraryOpt;

typedef enum MlpStampDataCmd_e {
	MLP_STAMP_PAGE = 101,
	MLP_STAMP_LAYER,
	MLP_STAMP_POS,
	MLP_STAMP_XPOS,
	MLP_STAMP_YPOS,
	MLP_STAMP_ALPHA,
	MLP_STAMP_ANNOT_CREATOR,
	MLP_STAMP_ANNOT_SUBJECT,
	MLP_STAMP_ANNOT_CREATION,
	MLP_STAMP_ANNOT_MODIFICATION,
	MLP_STAMP_ANNOT_LOCK,
	MLP_STAMP_ANNOT_RO,
	MLP_STAMP_ANNOT_BLENDMODE,

	MLP_STAMP_TEXT_VALUE = 201,
	MLP_STAMP_TEXT_FONT,
	MLP_STAMP_TEXT_FONTFILE,
	MLP_STAMP_TEXT_SIZE,
	MLP_STAMP_TEXT_BOLDEN,
	MLP_STAMP_TEXT_WMODE,
	MLP_STAMP_TEXT_COLOR,
	MLP_STAMP_TEXT_CHAR_SPACE,
	MLP_STAMP_TEXT_SCALE,
	MLP_STAMP_TEXT_EXPAND,

	MLP_STAMP_BORDER_COLOR = 301,
	MLP_STAMP_BORDER_CORNER,
	MLP_STAMP_BORDER_DASH,
	MLP_STAMP_BORDER_CLIP,

	MLP_STAMP_CIRCLE_POS = 401,
	MLP_STAMP_CIRCLE_DIAMETER,
	MLP_STAMP_CIRCLE_SUB,
	MLP_STAMP_CIRCLE_LWIDTH,
	MLP_STAMP_CIRCLE_COLOR,

	MLP_STAMP_RECTANGLE_POS = 501,
	MLP_STAMP_RECTANGLE_SIZE,
	MLP_STAMP_RECTANGLE_LWIDTH,
	MLP_STAMP_RECTANGLE_COLOR,

} MlpStampDataCmd;

typedef enum MlpPictureUnit_e {
	MLP_PICTURE_UNIT_PERCENT	= 1,		/*画像の論理サイズを指定する際の単位がパーセント*/
	MLP_PICTURE_UNIT_INCH		= 2,		/*画像の論理サイズを指定する際の単位がインチ*/
	MLP_PICTURE_UNIT_MM			= 3,		/*画像の論理サイズを指定する際の単位がミリメートル[mm]*/
} MlpPictureUnit;

typedef enum MlpCallbackSettingMode {
	MLP_RENDERING_CB=1,				/*ページの解析終了 / レンダリングの開始を知らせるコールバックを指定*/
	MLP_PROGRESS_CB,				/*指定した行数のレンダリング（画像格納）が終了したことを知らせるコールバックを指定*/
	MLP_RENDERED_CB,				/*ページのレンダリング終了を知らせるコールバックを指定*/
	MLP_PROGRESS2_CB,				/*処理終了率*/

	MLP_DRAW_STROKE_PATH_CB=101,	/*パスのストローキングが発生したときにコールバックされる*/
	MLP_DEFINE_IMAGE_TILE_CB,		/*タイルが定義されたときにコールバックされる*/
	MLP_DEFINE_MASK_IMAGE_TILE_CB,	/*タイルのマスクが定義されたときにコールバックされる*/
	MLP_DRAW_TILED_IMAGE_CB,		/*タイリングされた画像を貼り付るときにコールバックされる*/
} MlpCallbackSettingMode;

typedef enum MlpTiffCompressMode {
	MLP_TIFF_COMPRESS_NONE=0,		/*TIFF変換で圧縮なし*/
	MLP_TIFF_COMPRESS_JPEG,			/*TIFF変換でJPEG圧縮*/
	MLP_TIFF_COMPRESS_DEFLATE,		/*TIFF変換でDeflate圧縮*/
	MLP_TIFF_COMPRESS_LZW,			/*TIFF変換でLZW圧縮*/
} MlpTiffComtressMode;

typedef enum MlpConstants {
	MIN_RESOLUTION		= 10,		/*最小の解像度を変更*/
	MAX_RESOLUTION		= 10000,
	DEFAULT_RESOLUTION	= 150,
	DEFAULT_PDF_RESOLUTION	= 72,
	MIN_JPEG_QUALITY	= 24,
	MAX_JPEG_QUALITY	= 90,
	DEFAULT_JPEG_QUALITY= 75,

	MIN_PIXEL_SIZE		= 200,
	MAX_PIXEL_SIZE		= 5000000,

	DEFAULT_MULTILINE_TEXT_WIDGET_FONT_SIZE	= 55,	/*マルチラインのTextWidget(Form Annotation)のフォントの既定サイズ(値は実サイズの１０倍)*/

	CONVERT_CMYK_TO_RGB		= 1,	/*CMYKからRGBへの変換*/
	CONVERT_MOST_FAST		= 1,	/*最も速い*/
	CONVERT_FAST			= 2,	/*速い*/
	CONVERT_BY_COLOR_PROFILE= 3,	/*カラープロファイルによる変換*/
} MlpConstants;

typedef enum MlpCid0GlyphMode {
	SHOW_NOTDEF_GLYPH		= 0,
	REPLACE_TO_BLANK_GLYPH	= 1,
	IGNORE_CID_0_GLYPH		= 2,
} MlpCid0GlyphMode;

typedef enum MlpBoundaryBox {
	MEDIA_BOX		= 0,
	CROP_BOX		= 1,
	BLEED_BOX		= 2,
	TRIM_BOX		= 3,
	ART_BOX			= 4,
	MEDIA_CROP		= 5,
} MlpBoundaryBox;

typedef	enum MlpWatermarkLayer {
	WML_NO_PAINT	= 0,
	WML_FOREGROUND	= 1,
	WML_BACKGROUND	= 2,
} MlpWatermarkLayer;

typedef enum MlpCanvasOrigin {
	CORIGIN_CENTER		= 0,
	CORIGIN_LEFT_TOP	= 1,
	CORIGIN_LEFT_BOTTOM	= 2,
	CORIGIN_RIGHT_TOP	= 3,
	CORIGIN_RIGHT_BOTTOM= 4,
} MlpCanvasOrigin;

typedef	enum MlpOpenUsage {
	OPEN_USAGE_VIEW = 1,
	OPEN_USAGE_PRINT,
	OPEN_USAGE_EXPORT,
	OPEN_USAGE_EXTRACT,
} MlpOpenUsage;

typedef	struct MlpOcgDataRec_s	MlpOcgDataRec_t;
typedef	struct MlpOcgUsageRec_s	MlpOcgUsageRec_t;
typedef	MlpOcgDataRec_t		MlpOcgData;
typedef	MlpOcgUsageRec_t	MlpOcgUsage;

#define	MAX_OCG_NAME_LEN	100

struct MlpOcgDataRec_s {
	int		id;
	char	name[MAX_OCG_NAME_LEN+1];
	int		level;
	int		visible;
};

struct MlpOcgUsageRec_s {
	int		id;
	char	name[MAX_OCG_NAME_LEN+1];
	int		level;
	int		visible;

	/*Usage*/
	int	printState;
	int	viewState;
};

#ifndef	STROKE_PATH_ATTR_DEF
#define	STROKE_PATH_ATTR_DEF
typedef struct StrokePathAttr_s {
	float	lineWidth;
	int		lineCap;
	int		lineJoin;
	float	miterLimit;

	int		dashLen;
	float	dashPhase;
	float	dashData[32];

	float	colorfv[5];

	char	*pathString;

	int		x, y, width, height;
	int		colors;
} StrokePathAttr;
#endif	/*STROKE_PATH_ATTR_DEF*/

#ifndef	IMAGE_TILE_ATTR_DEF
#define	IMAGE_TILE_ATTR_DEF
typedef	struct Matrix_s {
	float	a, b, c, d, e, f;
} Matrix;

typedef struct ImageTileAttr_s {
	int		width, height, colors;
	float	alpha;
	float	xstep, ystep;
	Matrix	ctm;
} ImageTileAttr;
#endif	/*IMAGE_TILE_ATTR_DEF*/

typedef	struct BBox_s {
	float	x0, y0;
	float	x1, y1;
} BBox;

typedef struct MlpFormData_s {
	int			type;
	const char	*name;
	int			valueLength;
	const char	**value;		//[抽出値,表示値]ペアの配列
	const char	*richText;
	const char	**(*GetValue)(struct MlpFormData_s*, int);
} MlpFormData;

typedef struct MlpFontList_s {	/*フォントの各種属性を格納*/
	unsigned int	embedFlg;	//2:埋込フォント、3:サブセットフォント、4:標準14フォント、0:非埋込
	unsigned int	type;		//フォントタイプ enum FontType_eが入る
	union {
		char*		mbs;
		wchar_t*	wcs;
		char*		u8;
	}				uName;
} MlpFontList;

/*
**	Primitiveインターフェース
*/

typedef	void* PRIMITIVE_HANDLE;

typedef	struct PrmObjectHandle_s	PrmObjectHandle;
typedef	struct PrmDocumentXref_s	PrmDocumentXref;
typedef	enum PrmObjectType_e		PrmObjectType;
typedef	enum PrmXRefType_e			PrmXrefType;

struct PrmObjectHandle_s {
	PrmObjectType type;
	unsigned __int64 handle;
	int num;
};

struct PrmDocumentXref_s {
	int		ofs;
	int		num;
	int		gen;
	char	type;
};

enum PrmObjectType_e {
	PRM_UNKNOWN_OBJ = 0,
	PRM_NULL_OBJ = 1,
	PRM_BOOL_OBJ,
	PRM_INT_OBJ,
	PRM_REAL_OBJ,
	PRM_NUMBER_OBJ,
	PRM_STRING_OBJ,
	PRM_NAME_OBJ,
	PRM_ARRAY_OBJ,
	PRM_DICTIONARY_OBJ,
	PRM_INDIRECT_OBJ,
	PRM_NUMBER_OF_OBJS,
};

enum PrmXRefType_e {
	PRM_XREF_TABLE = 0,
	PRM_XREF_STREAM,
};

/*
**	Modifyer
*/
typedef	void* MOD_HANDLE;

#ifdef _UNICODE
typedef	struct ModTextArgW_s	ModTextArg;
#else
typedef	struct ModTextArgA_s	ModTextArg;
#endif
typedef struct ModTextArgW_s {
	int pageNumber;
	unsigned int cKind;
	float color[4];
	float xTextPos, yTextPos;
	wchar_t* fontName;
	float fontSize;
	wchar_t* text;
} ModTextArgW;
typedef struct ModTextArgA_s {
	int pageNumber;
	unsigned int cKind;
	float color[4];
	float xTextPos, yTextPos;
	char* fontName;
	float fontSize;
	char* text;
} ModTextArgA;

/*
**	Stamper
*+
*+	StamperInterfaceに代替される
*+
*/
typedef	void*	MlpStamp;

typedef	struct MlpPoint_s {
	float	x, y;
} MlpPoint;

/*
**	Stamper
*/
typedef	void* STAMP_HANDLE;

/*
**	Secure
*/
typedef	void*	SECURE_HANDLE;
typedef	struct MlpDocumentHierarchyInfo_s	MlpDocumentHierarchyInfo;
typedef	struct MlpRevokedInfo_s				MlpRevokedInfo;

enum SecKindOfSigningTime_e {
	SEC_SIGNING_TIME_SYS = 0,	//検証を実施したシステムの時刻
	SEC_SIGNING_TIME_M,			//文書の署名辞書に記視された時刻
	SEC_SIGNING_TIME_SIGN,		//PKCS#7メッセージに記載された署名時刻
	SEC_SIGNING_TIME_TS,		//タイムスタンプの時刻
};

struct MlpRevokedInfo_s {
	int nData;					//格納されたデータ数
	struct {
		unsigned char* data;
		unsigned long	len;
	} *d;
};

struct MlpDocumentHierarchyInfo_s {
	unsigned int has_DSS : 1;
	unsigned int has_VRI : 1;
	unsigned int has_SIG : 2;			//2:署名辞書のTyepはSigである(タイムスタンプ無し)、3:署名辞書のTyepはSigである(タイムスタンプ有り)
										//1:署名辞書のTyepはDocumentTimeStampである
	unsigned int sig_verified : 1;
	unsigned int has_page_obj : 1;
	unsigned int has_resource_onj : 1;
	unsigned int has_annotation_obj : 1;
	unsigned int TamperingElm : 1;			//1:ページを記述すると思われる(セキュリティ情報以外の)オブジェクトが記載されている
	unsigned int hash_is_matched_sign : 1;	//署名がadbe.pkcs7.detached, ETSI.CAdES.detached(DocTimeStamp以外)の場合に有効なフラグ
											//MLPはadbe.x509.rsa_sha1, adbe.pkcs7.sha1に未対応
	unsigned int hash_is_matched_ts : 1;	//署名がDocTimeStampの場合に有効なフラグ
	unsigned int SignerCertIsNotRevoked : 2;//署名者証明書の失効が、0:未確認、2:失効済み、3:失効なし
	unsigned int SignerCertIsCurrValid : 1;	//証明書は現在時刻で有効

	long long	DataSize;
	long long	SignedDataSize;
	long long	ByteRange[4];

	BYTE*		RangeDifference;			//ByteRangeとファイルサイズの差異データ
	size_t		RangeDifferenceLength;		//RangeDifferenceのバイト数	
	const char* SigObj;
	const char* Title;
	const char* Name;
	const char* M;
	const char* Filter;
	const char* SubFilter;
	const char* PropBuild;

	const unsigned char** VRI_Certs;
	const unsigned char** VRI_CRLs;
	const unsigned char** VRI_OCSPs;
	const unsigned int* VRI_Cert_size;	//VRI_Cert配列の各要素のバイトサイズ
	const unsigned int* VRI_CRL_size;	//VRI_CRL配列の各要素のバイトサイズ
	const unsigned int* VRI_OCSP_size;	//VRI_OCSP配列の各要素のバイトサイズ
	const unsigned long Contents_len;
	const unsigned long VRI_Certs_len;	//VRI_Cert配列のサイズ
	const unsigned long VRI_CRLs_len;	//VRI_CRL配列のサイズ
	const unsigned long VRI_OCSPs_len;	//VRI_OCSP配列のサイズ

	MlpRevokedInfo	cms_CRLs;
	MlpRevokedInfo	cms_OCSPs;
	MlpRevokedInfo	dss_CRLs;		//データを格納するコードは実装されていない（未使用である）
	MlpRevokedInfo	dss_OCSPs;		//データを格納するコードは実装されていない（未使用である）

	enum SecKindOfSigningTime_e	SigningTime_source;
	FILETIME SigningTime;

	const unsigned char* Contents;
	const char* DigestAlgorithm;

	const unsigned char* SignerCert;
	const unsigned char* SignerCertSn;
	const unsigned char* SignerCertSubj;
	const unsigned char* IssuerName;
	const unsigned long SignerCert_len;
	const unsigned long SignerCertSn_len;
	const unsigned long SignerCertSubj_len;
	const unsigned long IssuerName_len;
	const char* SignatureAlgorithmId;
	FILETIME	NotBefore;
	FILETIME	NotAfter;
	const int SignerCert_err;

	char*	TstPolicyId;
	char*	HashOid;
	unsigned char*	HashMessage;
	unsigned int	HashMessageLen;
	unsigned char*	TstSn;
	unsigned int	TstSnLen;
	char*	GenTime;
	struct tm	GenTm;		//日本時間
	int		AccuracySec;
	int		AccuracyMilli;
	int		AccuracyMicro;
	wchar_t*	TsaName;

	int error_code;
};

/*
**	メタデータ
*/
typedef	void* METADATA_HANDLE;

typedef	struct MlpMetadataProperty_s		MlpMetadataProperty;
typedef	struct MlpMetaSimpleProperty_s		MlpMetaSimpleProperty;
typedef	struct MlpMetaArrayProperty_s		MlpMetaArrayProperty;
typedef	struct MlpMetaStructProperty_s		MlpMetaStructProperty;

struct MlpMetaSimpleProperty_s {
	wchar_t	*property;
	wchar_t	*value;
};

struct MlpMetaArrayProperty_s {
	wchar_t	*property;
	wchar_t	**valueAry;
	unsigned int	value_count;
};

struct MlpMetaStructProperty_s {
	wchar_t	*property;
	wchar_t	**fieldAry;
	wchar_t	**valueAry;
	unsigned int	value_count;
};

struct MlpMetadataProperty_s {
	MlpMetaSimpleProperty	*siProp;
	unsigned int	si_count;

	MlpMetaArrayProperty	*arProp;
	unsigned int	ar_count;

	MlpMetaStructProperty	*stProp;
	unsigned int	st_count;
};

/*
**	XMP
*/
typedef	void* XMP_HANDLE;

/*
 *	文書解析用
 */
typedef	struct PrsFontName_s PrsFontName;
#define	PrsFontName_fontId_LEN		100
#define	PrsFontName_fontName_LEN	256

struct PrsFontName_s {
	int		pageNum;						/*フォントが使われている(最小の)ページ番号*/
	char	fontId[PrsFontName_fontId_LEN];	/*フォントの識別名*/
	char	fontName[PrsFontName_fontName_LEN];	/*フォント名*/
	int		embedded;						/*1:埋め込まれたフォント、0:それ以外*/
	int		render;							/*-1:レンダーモードの指定がない、0:通常のレンダーモードで利用されている、1:Tr=2のレンダーモードで使用されている*/
};

#endif	/*MLP_DECLARATION_H*/
