﻿/*
**	MplError.h
**	version 1.10.2
*/
/*
Copyright(c)2025 株式会社トラスト・ソフトウェア・システム, All Rights Reserved.
*/

#ifndef	MLP_ERROR_H
#define	MLP_ERROR_H

/*Imager-LP互換*/
#define	MLP_ALREADY_INITIALIZED			-1		/*既に初期化されています*/
#define	MLP_NOT_INITIALIZED				-2		/*初期化できませんでした。または、初期化してません*/
#define	MLP_INIT_FILE_OPEN_ERROR		-3		/*初期化ファイルを読めません*/
#define	MLP_INIT_DATA_LOAD_ERROR		-3		/*初期化をローディングできません*/
#define	MLP_LICENSE_ERROR				-4		/*不正なライセンスです*/
#define	MLP_ALREADY_OPENED				-5		/*既にオープンしています*/
#define	MLP_FILE_OPEN_ERROR				-6		/*オープンできません*/
#define	MLP_FILE_IS_NOT_PDF				-7		/*PDFではないようです*/
#define	MLP_UNRECOGNIZED_FILE			-7		/*認識できないファイル*/
#define	MLP_FILE_NOT_DECRYPTED			-8		/*復号できません*/
#define	MLP_FILE_NOT_OPENED				-9		/*オープンしていません*/
#define	MLP_OPEN_ERROR					-10		/*オープンでエラー*/
#define	MLP_FILE_COULDNT_CREATE			-10		/*ファイルを作成できません*/
#define	MLP_PDF_PARSE_ERROR				-11		/*PDFの解析エラー*/
#define	MLP_PDF_HAS_NOT_PAGE			-12		/*PDFに(指定の)ページがありません*/
#define	MLP_INVALID_PAGE_NUMBER			-13		/*無効なページ番号 または、無効なページ指定*/
#define	MLP_INVALID_RESOLUTION			-14		/*無効な解像度*/
#define	MLP_INVALID_QUALITY				-15		/*無効なJPEG品質*/
#define	MLP_NO_OUTPUT_FILE				-16		/*出力ファイルがありません*/
#define	MLP_TOO_LARGE_PIXEL				-17		/*ピクセル マップが大きすぎます*/
#define	MLP_DRAW_ERROR					-18		/*描画領域確保に失敗。または、画像の書き出しに失敗しました*/
#define	MLP_MEMORY_ERROR				-20		/*メモリー領域を確保できません*/
#define	MLP_INVALID_CANVAS_SIZE			-22		/*無効なキャンバスサイズ*/
#define	MLP_INVALID_ARG_VALUE			-22		/*無効な引数の値*/
#define	MLP_INVALID_PICT_TYPE			-23		/*無効な画像形式*/
#define	MLP_INVALID_CMD					-24		/*無効なコマンド*/
#define	MLP_NO_DATA						-25		/*有効なデータがありません、ページに大きさがありません*/
#define	MLP_FILL_1						-26
#define MLP_FAIL_TO_GET_PAGE			-27		/*ページの取得に失敗しました*/
#define	MLP_INVALID_DATA				-30		/*無効なデータ*/
#define	MLP_NO_LICENSE_KEY				-31		/*ライセンスキーが指定されていません*/
#define	MLP_UNUSABLE_LICENSE			-32		/*このバージョンでは使えないライセンス*/
#define	MLP_EXPIRED_LICENSE				-33		/*失効したライセンス*/
#define	MLP_ILLEGAL_OS_LICENSE			-34		/*このOSでは使えないライセンス*/
#define	MLP_OUT_OF_BOUND				-35		/*値が範囲外です*/
#define	MLP_COLOR_PROFILE_NOT_FOUND		-36		/*カラープロファイルを読み込めません*/
#define	MLP_COLOR_PROFILE_LOAD_ERROR	-36		/*カラープロファイルをロードできません*/
#define	MLP_INVALID_VER_COLOR_PROFILE	-37		/*ver.2ではないカラープロファイル*/
#define	MLP_INVALID_COLOR_PROFILE		-38		/*不正なカラープロファイル*/
#define MLP_FAIL_TO_COUNT_PAGES			-39		/*ページ数の取得に失敗しました*/
#define MLP_INVALID_PDF_VERSION			-40		/*不正なPDF文書バージョン*/
#define	MLP_FONT_NOT_FOUND				-41		/*フォントが見つかりません*/
#define	MLP_ALT_FONT_NOT_FOUND			-42		/*代替フォントが見つかりません*/
#define	MLP_FONT_FILE_NOT_OPENED		-43		/*フォントファイルを開けません*/
#define	MLP_FONT_NOT_LOADED				-44		/*フォントをロードできません*/
#define	MLP_GLYPH_NOT_FOUND				-51		/*グリフを検索できません*/
#define	MLP_UNAVAILABLE_CMD				-61		/*利用不能なコマンド*/
#define	MLP_CMS_IS_UNUSED				-62		/*CMSは利用不可*/
#define	MLP_FILE_NOT_EXISTS				-63		/*ファイルが存在しません*/
#define	MLP_EXN_IS_RUNNING				-64		/*Extractorが機能しています*/
#define	MLP_FAIL_TO_CREATE_PICT			-65		/*画像(ファイル)の作成に失敗しました*/

#define	MLP_XMP_INVALID_NS_URI			-75		/*不正な名前空間URI*/
#define	MLP_XMP_PROPERTY_NOT_EXIST		-76		/*このプロパティ名はありません*/
#define	MLP_XMP_NOT_SIMPLE_PROPERTY		-81		/*プロパティはSimpleプロパティではありません*/
#define	MLP_XMP_NOT_ARRAY_PROPERTY		-82		/*プロパティはArrayプロパティではありません*/
#define	MLP_XMP_ARRAY_HAS_NO_ITEMS		-83		/*プロパティはArrayプロパティですが、アイテムがありません*/
#define	MLP_XMP_TOO_BIG_ARRAY_INDEX		-84		/*プロパティはArrayプロパティですが、アイテム番号が大きすぎます*/
#define	MLP_XMP_INVALID_ARRAY_INDEX		-85		/*アイテム番号が不正*/
#define	MLP_XMP_NOT_STRUCT_PROPERTY		-86		/*プロパティはStructプロパティではありません*/
#define MLP_XMP_FEILD_NOT_EXITS			-87		/*プロパティはStructプロパティですが、このフィールドはありません*/
#define	MLP_XMP_ERROR					-91		/*XMPエラー*/
#define	MLP_XMP_NO_PROP_VALUE			-1296	/*XMPに指定されたプロパティが無い*/
#define	MLP_XMP_NO_TITLE				-1301	/*XMPのTitleデータが無い*/
#define	MLP_XMP_NO_CREATOR				-1302	/*XMPのCreatorデータが無い*/
#define	MLP_XMP_NO_DESCRIPTION			-1303	/*XMPのDescriptinデータが無い*/
#define	MLP_XMP_NO_KEYWORD				-1304	/*XMPのKeywordデータが無い*/
#define	MLP_XMP_NO_RIGHTS				-1305	/*XMPのRightsデータが無い*/

#define	MLP_DLL_NOT_FOUND			-501		/*ネイティブDllが見つからない*/

/*Svg*/

/*Exn*/
/*Imager-LP互換*/
#define	EXN_INVALID_CMD_D			-24			/*無効なコマンド*/
#define	EXN_UNAVAILABLE_CMD_D		-61			/*利用不能なコマンド*/
#define	EXN_IS_RUNNING_D			-64			/*Extractorが機能しています*/
#define	EXN_NOT_INITIALIZED_D		-2002		/*Extractorが初期化されていません*/
#define EXN_ALREADY_INITIALIZED_D	-2003		/*既にExtractorは初期化されています*/
#define EXN_HAS_BEEN_STARTED_D		-2004		/*既にExtractorが開始されています*/
#define EXN_PAGE_NOT_OPENED_D		-2005		/*ページが指定されていません*/
#define EXN_COULDNOT_EXTRACT_D		-2006		/*オブジェクトを抽出できません*/

/*Stm*/

/*Save*/

/*Secure*/

#endif	/*MLP_ERROR_H*/
