﻿/*
**	SecureInterface.h
**	version 1.10.2
**/
/*
Copyright(c)2025 株式会社トラスト・ソフトウェア・システム, All Rights Reserved.
*/

#pragma once

#include <Windows.h>
#include <MlpDeclaration.h>

#ifdef DLL_EXPORTS
#ifndef MLPAPI
#define MLPAPI __declspec(dllexport)
#endif
#else
#ifndef MLPAPI
#define MLPAPI __declspec(dllimport)
#endif
#endif

#ifdef	WINAPI
#undef	WINAPI
#endif
#define	WINAPI	__stdcall

#ifdef _UNICODE
#define SecSetOutputFileName		SecSetOutputFileNameW
#define	SecSignSaveCloseInterface	SecSignSaveCloseInterfaceW
#elif defined(_MBCS)
#define SecSetOutputFileName		SecSetOutputFileNameA
#define	SecSignSaveCloseInterface	SecSignSaveCloseInterfaceW
#endif


#ifdef __cplusplus
extern "C" {
#endif

	MLPAPI SECURE_HANDLE WINAPI MlpGetSecurityInterface();
	MLPAPI void WINAPI SecCloseInterface(SECURE_HANDLE);
	MLPAPI int WINAPI SecSignCloseInterface(SECURE_HANDLE);
	MLPAPI int WINAPI SecSignSaveCloseInterfaceW(SECURE_HANDLE, wchar_t* outFileName);
	MLPAPI int WINAPI SecSignSaveCloseInterfaceA(SECURE_HANDLE h, char* outFileName);
	MLPAPI int WINAPI SecGetLastError();

	MLPAPI int WINAPI SecSetOutputFileNameW(SECURE_HANDLE, wchar_t* fileName);
	MLPAPI int WINAPI SecSetOutputFileNameA(SECURE_HANDLE, char* fileName);

#define	SecSetTimestampAuthority	SecSetTimestampAuthorityW
#define SecSetSignerCertificateSubject	SecSetSignerCertificateSubjectW
#define SecSetSignerCertificateSerial	SecSetSignerCertificateSerialW
	MLPAPI int SecSetTimestampAuthorityW(SECURE_HANDLE, wchar_t* timestampAuthorityUrl, wchar_t* userName, wchar_t* userPassWord);
	MLPAPI int SecSetSignerCertificateSubjectW(SECURE_HANDLE, wchar_t* certSubject, wchar_t** errMsgPtr);
	MLPAPI int SecSetSignerCertificateSerialW(SECURE_HANDLE h, wchar_t* issuer, wchar_t* serialNumber, wchar_t** errPtr);
	MLPAPI int SecSetSignerCertificateDlg(SECURE_HANDLE, HWND);
	MLPAPI int SecSetSignerCertificate(SECURE_HANDLE h, ...);
	MLPAPI int SecPrepareSignature(SECURE_HANDLE);
#define	SigPrepareVisibleSignature	SigPrepareOpaqueSignature
	MLPAPI int SecPrepareOpaqueSignature(SECURE_HANDLE, int pageNumber, char* stampName, MlpPoint* position);
	MLPAPI int SecSignAndSaveW(SECURE_HANDLE, wchar_t* fileName);
	MLPAPI int SecSignAndSaveA(SECURE_HANDLE, char* file_name);

	MLPAPI int SecVerifySignature(SECURE_HANDLE);

	/*Utility*/
	MLPAPI char* SecBinaryToStringA(unsigned char* pbData, DWORD cbData, DWORD flag);
	MLPAPI BOOL SecViewCertificate(unsigned char* pbData, DWORD cbData, void* hwnd, wchar_t* title);
	MLPAPI BOOL SecViewCRL(unsigned char* pbData, DWORD cbData, void* hwnd, wchar_t* title);

#ifdef __cplusplus
}
#endif
