/*
**	StampInterface.h
**/
/*
Copyright(c)2025 株式会社トラスト・ソフトウェア・システム, All Rights Reserved.
*/
#pragma once

#include <Windows.h>
#include <MlpDeclaration.h>

#ifdef DLL_EXPORTS
#ifndef MLPAPI
#define MLPAPI __declspec(dllexport)
#endif
#else
#ifndef MLPAPI
#define MLPAPI __declspec(dllimport)
#endif
#endif

#ifdef	WINAPI
#undef	WINAPI
#endif
#define	WINAPI	__stdcall


#ifdef __cplusplus
extern "C" {
#endif

	MLPAPI STAMP_HANDLE WINAPI MlpGetStampInterface();
	MLPAPI void WINAPI StmCloseInterface(STAMP_HANDLE);

	MLPAPI int WINAPI StmSetStampFileA(STAMP_HANDLE, char* filePath);
	MLPAPI int WINAPI StmSetStampFileW(STAMP_HANDLE, wchar_t* filePath);
	MLPAPI int WINAPI StmSetStampDataA(STAMP_HANDLE, char* data, unsigned int length);
	MLPAPI int WINAPI StmSetStampDataW(STAMP_HANDLE, wchar_t* data, unsigned int len);
	MLPAPI int WINAPI StmPaintStampFileA(STAMP_HANDLE, char* filePath);
	MLPAPI int WINAPI StmPaintStampFileW(STAMP_HANDLE, wchar_t* filePath);
	MLPAPI int WINAPI StmPaintStampDataA(STAMP_HANDLE, char* data, unsigned int length);
	MLPAPI int WINAPI StmPaintStampDataW(STAMP_HANDLE, wchar_t* data, unsigned int length);
	MLPAPI int WINAPI StmPaintStamp(STAMP_HANDLE);
	MLPAPI int WINAPI StmPaintStampNameA(STAMP_HANDLE, char* id);
	MLPAPI int WINAPI StmPaintStampNameW(STAMP_HANDLE, wchar_t* id);
	MLPAPI int WINAPI StmPaintStampNamePosA(STAMP_HANDLE, char* id, float x_pos, float y_pos);
	MLPAPI int WINAPI StmPaintStampNamePosW(STAMP_HANDLE, wchar_t* id, float x_pos, float y_pos);
	MLPAPI int WINAPI StmResetStamp(STAMP_HANDLE);

	MLPAPI int WINAPI StmDocumentToFileW(STAMP_HANDLE, wchar_t* filePath);

#ifdef __cplusplus
}
#endif
