﻿/*
**	StcError.h
**	version 1.10.3
*/
/*
Copyright(c)2026 株式会社トラスト・ソフトウェア・システム, All Rights Reserved.
*/

#ifndef	STC_ERROR_H
#define	STC_ERROR_H

#define	STC_NO_ERROR				0x00000000
#define	STC_ALREADY_INITIALIZED		0x80000001	/*既に初期化されています*/
#define	STC_NOT_INITIALIZED			0xFFFFFFFE	/*初期化できませんでした。または、初期化してません*/
#define	STC_INIT_FILE_OPEN_ERROR	0x80000003	/*初期化ファイルを読めません*/
#define	STC_INIT_DATA_LOAD_ERROR	0x80000003	/*初期化をローディングできません*/
#define	STC_LICENSE_ERROR			0xFFFFFFFC	/*不正なライセンスです*/
#define	STC_ALREADY_OPENED			0x80000005	/*既にオープンしています*/
#define	STC_FILE_OPEN_ERROR			0x80000006	/*オープンできません*/
#define	STC_FILE_IS_NOT_PDF			0x80000007	/*PDFではないようです*/
#define	STC_UNRECOGNIZED_FILE		0x80000007	/*認識できないファイル*/
#define	STC_FILE_NOT_DECRYPTED		0x80000008	/*復号できません*/
#define	STC_FILE_NOT_OPENED			0x80000009	/*オープンしていません*/
#define	STC_OPEN_ERROR				0x8000000A	/*オープンでエラー*/
#define	STC_FILE_COULDNT_CREATE		0x8000000A	/*ファイルを作成できません*/
#define	STC_PDF_PARSE_ERROR			0x8000000B	/*PDFの解析エラー*/
#define	STC_PDF_HAS_NOT_PAGE		0x8000000C	/*PDFに(指定の)ページがありません*/
#define	STC_INVALID_PAGE_NUMBER		0x8000000D	/*無効なページ番号 または、無効なページ指定*/
#define	STC_INVALID_RESOLUTION		0x8000000E	/*無効な解像度*/
#define	STC_INVALID_QUALITY			0x8000000F	/*無効なJPEG品質*/
#define	STC_NO_OUTPUT_FILE			0x80000010	/*出力ファイルがありません*/
#define	STC_TOO_LARGE_PIXEL			0x80000011	/*ピクセル マップが大きすぎます*/
#define	STC_DRAW_ERROR				0x80000012	/*描画領域確保に失敗。または、画像の書き出しに失敗しました*/
#define	STC_MEMORY_ERROR			0x80000014	/*メモリー領域を確保できません*/
#define	STC_INVALID_ARG_VALUE		0x80000016	/*無効な引数の値*/
#define	STC_INVALID_PICT_TYPE		0x80000017	/*無効な画像形式*/
#define	STC_INVALID_CMD				0x80000018	/*無効なコマンド*/
#define	STC_NO_DATA					0x80000019	/*有効なデータがありません、ページに大きさがありません*/
#define	STC_FAIL_TO_GET_PAGE		0x8000001B	/*ページの取得に失敗しました*/
#define	STC_INVALID_DATA			0x8000001E	/*無効なデータ*/
#define	STC_NO_LICENSE_KEY			0x8000001F	/*ライセンスキーが指定されていません*/
#define	STC_UNUSABLE_LICENSE		0x80000020	/*このバージョンでは使えないライセンス*/
#define	STC_EXPIRED_LICENSE			0x80000021	/*失効したライセンス*/
#define	STC_ILLEGAL_OS_LICENSE		0x80000022	/*このOSでは使えないライセンス*/
#define	STC_OUT_OF_BOUND			0x80000023	/*値が範囲外です*/
#define	STC_COLOR_PROFILE_NOT_FOUND	0x80000024	/*カラープロファイルを読み込めません*/
#define	STC_COLOR_PROFILE_LOAD_ERROR 0x80000024	/*カラープロファイルをロードできません*/
#define	STC_INVALID_VER_COLOR_PROFILE 0x80000025/*ver.2ではないカラープロファイル*/
#define	STC_INVALID_COLOR_PROFILE	0x80000026	/*不正なカラープロファイル*/
#define	STC_FAIL_TO_COUNT_PAGES		0x80000027	/*ページ数の取得に失敗しました*/
#define	STC_INVALID_PDF_VERSION		0x80000028	/*不正なPDF文書バージョン*/
#define	STC_FONT_NOT_FOUND			0x80000029	/*フォントが見つかりません*/
#define	STC_ALT_FONT_NOT_FOUND		0x8000002A	/*代替フォントが見つかりません*/
#define	STC_FONT_FILE_NOT_OPENED	0x8000002B	/*フォントファイルを開けません*/
#define	STC_FONT_NOT_LOADED			0x8000002C	/*フォントをロードできません*/
#define	STC_GLYPH_NOT_FOUND			0x80000033	/*グリフを検索できません*/
#define	STC_UNAVAILABLE_CMD			0x8000003D	/*利用不能なコマンド*/
#define	STC_CMS_CANT_BE_UNUSED		0x8000003E	/*CMSは利用不可*/
#define	STC_FILE_NOT_EXISTS			0x8000003F	/*ファイルが存在しません*/
#define	STC_EXN_IS_RUNNING			0x80000040	/*Extractorが機能しています*/
#define	STC_FAIL_TO_CREATE_PICT		0x80000041	/*画像(ファイル)の作成に失敗しました*/
#define	STC_HAS_NOT_ENOUGH_MEMORY	0x80000042	/*メモリのサイズが小さすぎます*/
#define	STC_OTHER_IFS_ARE_RUNNING	0x80000043	/*他のインターフェースが機能しています*/
#define	STC_FILE_ALREADY_EXISTS		0x80000044	/*ファイルは既に存在します*/
#define	STC_DLL_NOT_FOUND			0x800001F5	/*ネイティブDLLが見つかりません*/

/*XMP*/
#define	STC_XMP_INVALID_NS_URI		0x8000004B	/*不正な名前空間URI*/
#define	STC_XMP_PROPERTY_NOT_EXIST	0x8000004C	/*このプロパティ名はありません*/
#define	STC_XMP_NOT_SIMPLE_PROPERTY	0x80000051	/*プロパティはSimpleプロパティではありません*/
#define	STC_XMP_NOT_ARRAY_PROPERTY	0x80000052	/*プロパティはArrayプロパティではありません*/
#define	STC_XMP_ARRAY_HAS_NO_ITEMS	0x80000053	/*プロパティはArrayプロパティですが、アイテムがありません*/
#define	STC_XMP_TOO_BIG_ARRAY_INDEX	0x80000054	/*プロパティはArrayプロパティですが、アイテム番号が大きすぎます*/
#define	STC_XMP_INVALID_ARRAY_INDEX	0x80000055	/*アイテム番号が不正*/
#define	STC_XMP_NOT_STRUCT_PROPERTY	0x80000056	/*プロパティはStructプロパティではありません*/
#define	STC_XMP_FEILD_NOT_EXITS		0x80000057	/*プロパティはStructプロパティですが、このフィールドはありません*/
#define	STC_XMP_ARRAY_NOT_ALTERNATE	0x80000059	/*プロパティはArrayプロパティですが、Alternateではありません*/
#define STC_XMP_COULDNT_DELETE_ITEM	0x8000005A	/*指定のアイテムを削除できませんでした*/
#define	STC_XMP_ERROR				0x8000005B	/*XMPエラー*/
#define	STC_XMP_NO_PROP_VALUE		STC_XMP_PROPERTY_NOT_EXIST	/*XMPに指定されたプロパティが無い*/
#define	STC_XMP_INVALID_DATE		0x80000071	/*XMPの日付が不正*/
#define	STC_XMP_NO_TITLE			0x80000515	/*XMPのTitleプロパティが無い*/
#define	STC_XMP_NO_CREATOR			0x80000516	/*XMPのCreatorプロパティが無い*/
#define	STC_XMP_NO_DESCRIPTION		0x80000517	/*XMPのDescriptinプロパティが無い*/
#define	STC_XMP_NO_SUBJECT			0x80000518	/*XMPのdc:subject(KeywordArray)プロパティが無い*/
#define	STC_XMP_NO_KEYWORDS			0x80000519	/*XMPのpdf:Keywordsプロパティが無い*/
#define	STC_XMP_NO_RIGHTS			0x80000521	/*XMPのRightsプロパティが無い*/

/*Svg*/
/*Exn*/
#define	EXN_INVALID_CMD				0x80000018	/*無効なコマンド*/
#define	EXN_UNAVAILABLE_CMD			0x8000003D	/*利用不能なコマンド*/
#define	EXN_IS_RUNNING				0x80000040	/*Extractorが機能しています*/
#define	EXN_NOT_INITIALIZED			0x800007D2	/*Extractorが初期化されていません*/
#define	EXN_ALREADY_INITIALIZED		0x800007D3	/*既にExtractorは初期化されています*/
#define	EXN_HAS_BEEN_STARTED		0x800007D4	/*既にExtractorが開始されています*/
#define	EXN_PAGE_NOT_OPENED			0x800007D5	/*ページが指定されていません*/
#define	EXN_COULDNOT_EXTRACT		0x800007D6	/*オブジェクトを抽出できません*/
#define	EXN_OBJECT_HAS_NO_ITEM		0x800007D7	/*オブジェクトに指定のアイテムがありません*/

/*Stm*/
#define	STM_INVALID_CMD				0x80000018	/*無効なコマンド*/
#define	STM_IS_NOT_BEGIN			0x80000BA0	/*Stampが開始されていない*/
#define	STM_IS_NOT_END				0x80000BA1	/*Stampが終了していない*/
#define	STM_NO_STAMP_INFO			0x80000BBC	/*スタンプリストに内容(設定)がない*/
#define	STM_NO_STAMP_NAME			0x80000BBD	/*スタンプのリストに指定の名前がない*/
#define	STM_FONT_NOT_FOUND			0x80000B81	/*指定されたファイルを検索できない*/

/*Save*/
#define	MLP_CANNOT_SAVE				0x80000BBF	/*この文書は保存できません*/
#define	STC_CANNOT_SAVE				0x80000BBF	/*この文書は保存できません*/

/*Secure*/
#define	SIG_DOCUMENT_HAS_NO_PAGE			0x8000000C	/*文書にページがない STC_PDF_HAS_NOT_PAGEと同じ*/
#define	SIG_INVALID_ARG_VALUE				0x80000016	/*無効な引数の値*/
#define	SIG_INVALID_CMD						0x80000018	/*無効なコマンド*/
#define	SIG_FILE_IS_NEWLY_CREATED			0xA0000021	/*新規に作成されたファイル*/
#define	SIG_DOCUMENT_ALREADY_MODIFIED		0xA0000022	/*対象のDocは既に更新されている*/
#define	SIG_INVALID_SIGN_OBJECT				0xA0000023	/*署名オブジェクトが不正*/
#define	SIG_INVALID_SIGNATURE				0xA0000024	/*署名データが不正*/
#define	SIG_INVALID_CERTIFICATE				0xA0000025	/*証明書が不正*/
#define	SIG_COULDNT_SIGN					0xA0000026	/*情報不足のため、電子署名できない*/
#define	SIG_ENCRYPTED_DOCUMENT				0xA0000031	/*文書は暗号化されている*/
#define	SIG_SECURE_ERROR					0xA0001000	/*Security一般的なエラー*/
#define	SIG_SECURE_COULDNT_OPEN				0xA0001001	/*Secureオープン失敗*/
#define	SIG_SECURE_NOT_BEGIN				0xA0001003	/*Secureが開始されていない*/
#define	SIG_SECURE_NOT_SIGNED				0xA0001004	/*InSecureで未署名*/
#define	SIG_SECURE_NOT_SAVED				0xA0001005	/*InSecureで文書を保存していない*/
#define	SIG_SECURE_ALREADY_OPENED			0xA0001010	/*Secureを複数回オープンできません*/
#define	SIG_SECURE_ALREADY_SAVED			0xA0001011	/*署名された文書は既に保存されています*/
#define	SIG_SECURE_ALREADY_SIGNED			0xA0001012	/*文書は既に署名されています*/
#define	SIG_SECURE_VERSION_IS_CURRENT		0xA0001021	/*指定のバージョンは現行(オープンした)文書*/
#define	SIG_SECURE_VERSION_IS_SIGNING		0xA0001022	/*指定のバージョンは署名している文書*/
#define	SIG_CERT_ERROR						0xA0002000	/*電子証明書のエラー*/
#define	SIG_CERT_NOT_SPECIFIED				0xA0002001	/*電子証明書が指定されていない*/
#define	SIG_CERT_STORE_COULDNT_OPEN			0xA0002002	/*証明書ストアがオープンできない*/
#define	SIG_CERT_NOT_FOUND					0xA0002003	/*電子証明書が見つからない*/
#define	SIG_CERT_INVALID_NAME				0xA0002004	/*電子証明書の名前が不正*/
#define	SIG_CERT_INVALID_TIME				0xA0002006	/*電子証明書が現在有効でない*/
#define	SIG_CERT_IS_REVOKED					0xA0002007	/*電子証明書が失効している*/
#define	SIG_CERT_INVALID_USAGE				0xA0002008	/*電子証明書の使用方法が違う*/
#define	SIG_CERT_INVALID_SIGNATURE			0xA0002009	/*電子証明書の署名が不正*/
#define	SIG_CERT_ROOT_IS_NOT_TRUSTED		0xA000200A	/*ルート(または中間)証明書が信頼できない*/
#define	SIG_CERT_UNKNOWN_REVOCATION_STATUS	0xA000200B	/*電子証明書の失効状況が不明*/
#define	SIG_CERT_TRUST_CHAIN_IS_CYCLIC		0xA000200C	/*電子証明書信頼チェーンが繰り返されている*/
#define	SIG_CERT_INVALID_EXTENSION			0xA000200D	/*電子証明書の拡張情報が不正*/
#define	SIG_CERT_IS_NOT_TRUSTED				0xA000200E	/*信頼できない電子証明書*/
#define	SIG_CERT_IS_EXPIRED					0xA000200F	/*証明書は期限切れ*/
#define	SIG_CERT_INCOMPRETE_CHAIN			0xA0002010	/*不完全な証明書チェーン*/
#define	SIG_SECT_NO_SIGNATURE_OBJECT		0xA0003005	/*署名ディクショナリが無い*/
#define	SIG_SECT_INVALID_BYTE_RANGE			0xA0003006	/*署名のByteRangeが不正*/
#define	SIG_SECT_INVALID_START_RANGE		0xA0003007	/*署名のByteRangeの開始位置が不正*/
#define	SIG_SECT_NOT_ENOUGH_SIGNED_RANGE	0xA0003008	/*署名のByteRangeがファイルサイズより小さい*/
#define	SIG_SECT_COULDNT_CALCULATE_HASH		0xA0003032	/*ハッシュ値を計算できない*/
#define	SIG_SECT_INVALID_HASH_LENGTH		0xA0003034	/*ハッシュ値のサイズが不正*/
#define	SIG_SECT_INVALID_SIGN_HASH_VALUE	0xA0003036	/*電子署名のハッシュ値が不正*/
#define	SIG_SECT_INVALID_TS_HASH_VALUE		0xA0003037	/*タイムスタンプのハッシュ値が不正*/
#define	SIG_SECT_MESSAGE_ERROR				0xA0003040	/*電子署名のメッセージを解析できない。メッセージが不正*/
#define	SIG_SECT_COULDNT_GET_CERTIFICATE	0xA0003042	/*証明書を取得できない*/
#define	SIG_SECT_MSG_IS_NOT_SIGNED_DATA		0xA0003043	/*署名メッセージがSignedDataでない*/
#define	SIG_SECT_INVALID_SIGN_SIGNATURE		0xA0003044	/*電子署名メッセージの検証エラー*/
#define	SIG_SECT_INVALID_TS_SIGNATURE		0xA0003045	/*タイムスタンプメッセージの検証エラー*/
#define	SIG_SECT_NO_REVOCATION_INFORMATION	0xA0003061	/*証明書の失効情報がPDF文書に含まれていない*/

#define	SIG_CERT_TRUST_IS_NOT_TIME_VALID			0xA0000221	/*証明書の時刻が有効でない*/
#define	SIG_CERT_TRUST_IS_REVOKED					0xA0000222	/*証明書が失効している*/
#define	SIG_CERT_TRUST_IS_NOT_SIGNATURE_VALID		0xA0000223	/*証明書の署名が不正*/
#define	SIG_CERT_TRUST_IS_NOT_VALID_FOR_USAGE		0xA0000224	/*証明書の利用目的が不正*/
#define	SIG_CERT_TRUST_IS_UNTRUSTED_ROOT			0xA0000225	/*証明書のRootが信頼されていない*/
#define	SIG_CERT_TRUST_REVOCATION_STATUS_UNKNOWN	0xA0000226	/*証明書の失効状況が不明*/
#define	SIG_CERT_TRUST_IS_CYCLIC					0xA0000227	/*証明書の信頼チェーンが巡回している*/
#define	SIG_CERT_TRUST_IS_PARTIAL_CHAIN				0xA0000228	/*証明書チェーンが未完成*/
#define	SIG_CERT_TRUST_CTL_IS_NOT_TIME_VALID		0xA0000229	/*証明書信頼リストの時刻が有効でない*/
#define	SIG_CERT_TRUST_CTL_IS_NOT_SIGNATURE_VALID	0xA000022A	/*証明書信頼リスト内の署名が不正*/
#define SIG_CERT_TRUST_CTL_IS_NOT_VALID_FOR_USAGE	0xA000022B	/*証明書信頼リスト内の利用目的が不正*/
#define	SIG_CERT_TRUST_IS_OFFLINE_REVOCATION		0xA000022C	/*OFFLINE*/

#define	SIG_CERT_STORE_ERROR				0xA0000281	/*証明書ストアでのエラー*/
#define	SIG_SIGNATURE_ERROR					0xA0000300	/*電子署名でエラー*/
#define	SIG_SIGNATURE_NOT_SPECIFIED			0xA0000302	/*署名情報(位置やスタンプなど)が未指定*/
#define	SIG_TIMESTAMP_ERROR					0xA0000400	/*タイムスタンプでエラー*/
#define	SIG_TIMESTAMP_NOT_ATHENTICATED		0xA0000401	/*タイムスタンプの認証エラー*/
#define	SIG_TIMESTAMP_COLDNT_GET			0xA0000402	/*タイムスタンプが取得できない*/
#define	SIG_TIMESTAMP_TOO_LERGE				0xA0000403	/*タイムスタンプのサイズが予想以上 キャッシュされたサイズよりも大きく処理の続行ができない*/
#define	SIG_TIMESTAMP_NOT_FOUND				0xA0000404	/*タイムスタンプURLが不正*/
#define	SIG_TIMESTAMP_ACCESS_ERROR			0xA0000480	/*タイムスタンプのアクセスエラー*/
#define	SIG_TIMESTAMP_STATUS_ERROR			0xA0000481	/*タイムスタンプのステータスエラー*/
#define	SIG_INVALID_TIMESTAMP				0xA00004A0	/*不正なタイムスタンプ*/
#define	SIG_TIMESTAMP_ALGORITHM_ERROR		0xA00004A1	/*不正な(未対応の)アルゴリズム*/
#define	SIG_TIMESTAMP_HASH_ERROR			0xA00004A2	/*タイムスタンプのハッシュ値が不一致*/
#define	SIG_VERIFY_ERROR					0xA0000600	/*署名検証でエラー*/
#define	SIG_VERIFY_NOT_DONE					0xA0000601	/*署名検証が未実行*/
#define	SIG_VERIFY_NOT_SIGNED				0xA0000602	/*署名検証で署名フィールドが見つからない*/
#define	SIG_VERIFY_NO_CERTIFICATE			0xA0000603	/*署名検証で証明書が見つからない*/

/*Imager-LP互換*/
#ifndef	MLP_ERROR_H
#include "MlpError.h"
#endif

#endif	/*STC_ERROR_H*/
