﻿/*
**	Structure DLL Header
**		version 1.10.3
*/
/*
Copyright(c)2026 株式会社トラスト・ソフトウェア・システム, All Rights Reserved.
*/

#ifndef	STRUCTURE_H
#define	STRUCTURE_H

#include <Windows.h>

#ifdef DLL_EXPORTS
#ifndef MLPAPI
#define MLPAPI __declspec(dllexport)
#endif
#else
#ifdef MLPAPI
#undef MLPAPI
#endif
#define MLPAPI __declspec(dllimport)
#endif

#ifdef	WINAPI
#undef	WINAPI
#endif
#define	WINAPI	__stdcall

#include "MlpDeclaration.h"

#ifdef	_UNICODE
#ifndef IMAGER_LP_H
#define	MlpInitialize			MlpInitializeW
#define	MlpAddLicense			MlpAddLicenseW
#define	MlpGetLicenseInfo		MlpGetLicenseInfoW
#define	MlpLoadInitFile			MlpLoadInitFileW
#define	MlpLoadInitData			MlpLoadInitDataW
#define	MlpOpenDoc0				MlpOpenDoc0W
#define	MlpOpenDoc				MlpOpenDocW
#define	MlpOpenDocLegacy		MlpOpenDocLegacyW
#define	MlpOpenDocUsage			MlpOpenDocUsageW
#define	MlpOpenMemDoc			MlpOpenMemDocW
#define	MlpOpenMemDocUsage		MlpOpenMemDocUsageW
#define	MlpSetImageWatermark	MlpSetImageWatermarkW
#define	MlpSetFillTextWatermark	MlpSetFillTextWatermarkW
#define	MlpSetStrokeTextWatermark	MlpSetStrokeTextWatermarkW
#define	MlpCreatePict			MlpCreatePictW
#define	MlpCreatePictData		MlpCreatePictDataW
#define	MlpPageToPict			MlpPageToPictW
#define	MlpPageToPictData		MlpPageToPictDataW
#define	MlpConvertToTiff		MlpConvertToTiffW
#define	MlpCreateTiffRange		MlpCreateTiffRangeW
#define	MlpCreateTiffMulti		MlpCreateTiffMultiW
#define	MlpPageRangeToTiff		MlpPageRangeToTiffW
#define	MlpMultiPageToTiff		MlpMultiPageToTiffW
#define	MlpCreateAllToTiff		MlpCreateAllToTiffW
#define	MlpCreateAllToPict		MlpCreateAllToPictW
#define	MlpPanelToFile			MlpPanelToFileW
#define	MlpPaintRectToPanel_2	MlpPaintRectToPanel_2W
#define MlpCreatePDF			MlpCreatePDFW
#define MlpCreatePDFFile		MlpCreatePDFFileW
#define MlpCreatePDFArray		MlpCreatePDFArrayW
#define MlpAppendToPDF			MlpAppendToPDFW

#define	MlpSetColorProfile		MlpSetColorProfileW
#define	MlpSetRGBProfile		MlpSetRGBProfileW
#define	MlpSetCMYKProfile		MlpSetCMYKProfileW
#define	MlpSetGrayProfile		MlpSetGrayProfileW
#define	MlpGetRGBProfileName	MlpGetRGBProfileNameW
#define	MlpGetCMYKProfileName	MlpGetCMYKProfileNameW
#define	MlpGetGrayProfileName	MlpGetGrayProfileNameW
#define MlpSetDefaultFont		MlpSetDefaultFontW
#define MlpSetAlternateFont		MlpSetAlternateFontW
#define MlpSetAlternateFont2	MlpSetAlternateFont2W
#define MlpSavePDF				MlpSavePDFW
#define MlpSaveLastPDF			MlpSaveLastPDFW
#define MlpConvertToLastVersion	MlpConvertToLastVersionW
#define MlpCountDocumentVersion	MlpCountDocumentVersionW
#define MlpSimpleFontListGetName MlpSimpleFontListGetNameW

#endif	//IMAGER_LP_H
#else	//_UNICODE
#ifndef IMAGER_LP_H
#define	MlpInitialize			MlpInitializeA
#define	MlpAddLicense			MlpAddLicenseA
#define	MlpGetLicenseInfo		MlpGetLicenseInfoA
#define	MlpLoadInitFile			MlpLoadInitFileA
#define	MlpLoadInitData			MlpLoadInitDataA
#define	MlpOpenDoc0				MlpOpenDoc0A
#define	MlpOpenDoc				MlpOpenDocA
#define	MlpOpenDocLegacy		MlpOpenDocLegacyA
#define	MlpOpenDocUsage			MlpOpenDocUsageA
#define	MlpOpenMemDoc			MlpOpenMemDocA
#define	MlpOpenMemDocUsage		MlpOpenMemDocUsageA
#define	MlpSetImageWatermark	MlpSetImageWatermarkA
#define	MlpSetFillTextWatermark	MlpSetFillTextWatermarkA
#define	MlpSetStrokeTextWatermark	MlpSetStrokeTextWatermarkA
#define	MlpCreatePict			MlpCreatePictA
#define	MlpCreatePictData		MlpCreatePictDataA
#define	MlpPageToPict			MlpPageToPictA
#define	MlpPageToPictData		MlpPageToPictDataA
#define	MlpConvertToTiff		MlpConvertToTiffA
#define	MlpCreateTiffRange		MlpCreateTiffRangeA
#define	MlpCreateTiffMulti		MlpCreateTiffMultiA
#define	MlpRangeToTiff			MlpRangeToTiffA
#define	MlpMultiPageToTiff		MlpMultiPageToTiffA
#define	MlpCreateAllToTiff		MlpCreateAllToTiffA
#define	MlpCreateAllToPict		MlpCreateAllToPictA
#define	MlpPanelToFile			MlpPanelToFileA
#define	MlpPaintRectToPanel_2	MlpPaintRectToPanel_2A
#define MlpCreatePDF			MlpCreatePDFA
#define MlpCreatePDFFile		MlpCreatePDFFileA
#define MlpCreatePDFArray		MlpCreatePDFArrayA
#define MlpAppendToPDF			MlpAppendToPDFA

#define	MlpSetColorProfile		MlpSetColorProfileA
#define	MlpSetRGBProfile		MlpSetRGBProfileA
#define	MlpSetCMYKProfile		MlpSetCMYKProfileA
#define	MlpSetGrayProfile		MlpSetGrayProfileA
#define	MlpGetRGBProfileName	MlpGetRGBProfileNameA
#define	MlpGetCMYKProfileName	MlpGetCMYKProfileNameA
#define	MlpGetGrayProfileName	MlpGetGrayProfileNameA
#define MlpSetDefaultFont		MlpSetDefaultFontA
#define MlpSetAlternateFont		MlpSetAlternateFontA
#define MlpSetAlternateFont2	MlpSetAlternateFont2A
#define MlpSavePDF				MlpSavePDFA
#define MlpSaveLastPDF			MlpSaveLastPDFA
#define MlpConvertToLastVersion	MlpConvertToLastVersionA
#define MlpCountDocumentVersion	MlpCountDocumentVersionA
#define MlpSimpleFontListGetName MlpSimpleFontListGetNameA

#endif	//IMAGER_LP_H
#endif	//_UNICODE

#ifdef _UNICODE
#define	ModRegisterFont		ModRegisterFontW
#define	ModSetFontName		ModSetFontNameW
#define	ModGetFontName		ModGetFontNameW
#define	ModRegisterImage	ModRegisterImageW
#define	ModSetImageName		ModSetImageNameW
#define	ModGetImageName		ModGetImageNameW
#define	ModPaintText		ModPaintTextW
#define	ModPaintTextArg		ModPaintTextArgW
#else
#define	ModRegisterFont		ModRegisterFontA
#define	ModSetFontName		ModSetFontNameA
#define	ModGetFontName		ModGetFontNameA
#define	ModRegisterImage	ModRegisterImageA
#define	ModSetImageName		ModSetImageNameA
#define	ModGetImageName		ModGetImageNameA
#define	ModPaintText		ModPaintTextA
#define	ModPaintTextArg		ModPaintTextArgA
#endif	//_UNICODE

#ifdef _UNICODE
#define	MlpSetStampFile			MlpSetStampFileW
#define	MlpSetStampData			MlpSetStampDataW
#define	MlpPaintStampFile		MlpPaintStampFileW
#define	MlpPaintStampFile		MlpPaintStampFileW
#define	MlpPaintStampData		MlpPaintStampDataW
#define	MlpSetStampSingleFile	MlpSetStampSingleFileW
#define	MlpSetStampSingleData	MlpSetStampSingleDataW
#define	MlpPaintStampSinglFile	MlpPaintStampSinglFileW
#define	MlpPaintStampSinglData	MlpPaintStampSinglDataW
#define	MlpPaintStampName		MlpPaintStampNameW
#define	MlpPaintStampNamePos	MlpPaintStampNamePosW

#define	PrmDocumentToFile		PrmDocumentToFileW

#define	StmPaintStampName		StmPaintStampNameW
#define	StmSetStampData			StmSetStampDataW
#define	StmPaintStampFile		StmPaintStampFileW
#define	StmPaintStampData		StmPaintStampDataW
#define	StmPaintStampName		StmPaintStampNameW
#define	StmPaintStampNamePos	StmPaintStampNamePosW
#else	//_UNICODE
#define	MlpSetStampFile			MlpSetStampFileA
#define	MlpSetStampData			MlpSetStampDataA
#define	MlpPaintStampFile		MlpPaintStampFileA
#define	MlpPaintStampFile		MlpPaintStampFileA
#define	MlpPaintStampData		MlpPaintStampDataA
#define	MlpSetStampSingleFile	MlpSetStampSingleFileA
#define	MlpSetStampSingleData	MlpSetStampSingleDataA
#define	MlpPaintStampSinglFile	MlpPaintStampSinglFileA
#define	MlpPaintStampSinglData	MlpPaintStampSinglDataA
#define	MlpPaintStampName		MlpPaintStampNameA
#define	MlpPaintStampNamePos	MlpPaintStampNamePosA

#define	PrmDocumentToFile		PrmDocumentToFileA

#define	StmPaintStampName		StmPaintStampNameA
#define	StmSetStampData			StmSetStampDataA
#define	StmPaintStampFile		StmPaintStampFileA
#define	StmPaintStampData		StmPaintStampDataA
#define	StmPaintStampName		StmPaintStampNameA
#define	StmPaintStampNamePos	StmPaintStampNamePosA
#endif	//_UNICODE

/* XMP */
#ifdef _UNICODE
#define	XmpDoesPropertyExist		XmpDoesPropertyExistW
#define	XmpDoesSimplePropertyExist	XmpDoesSimplePropertyExistW
#define	XmpDoesArrayPropertyExist	XmpDoesArrayPropertyExistW
#define	XmpDoesArrayItemExist		XmpDoesArrayItemExistW
#define	XmpDoesStructurePropertyExist XmpDoesStructurePropertyExistW
#define	XmpDoesStructureFieldExist	XmpDoesStructureFieldExistW
#define	XmpCountStructureFields		XmpCountStructureFieldaW
#define	XmpGetProperty				XmpGetPropertyW
#define	XmpGetSimpleProperty		XmpGetSimplePropertyW
#define	XmpGetArrayItem				XmpGetArrayItemW
#define	XmpGetLocalizedText			XmpGetLocalizedTextW
#define	XmpCountArrayItems			XmpCountArrayItemsW
#define	XmpGetStructureField		XmpGetStructureFieldW
#define	XmpSetProperty				XmpSetPropertyW
#define	XmpSetSimpleProperty		XmpSetSimplePropertyW
#define	XmpSetArrayItem				XmpSetArrayItemW
#define	XmpInsertArrayItem			XmpInsertArrayItemW
#define	XmpGetArrayAltLangText		XmpGetArrayAltLangTextW
#define	XmpSetArrayAltLangText		XmpSetArrayAltLangTextW
#define	XmpSetLocalizedText			XmpSetLocalizedTextW
#define	XmpAppendArrayItem			XmpAppendArrayItemW
#define	XmpSetStructureField		XmpSetStructureFieldW
#define	XmpDeleteProperty			XmpDeletePropertyW
#define	XmpDeleteSimpleProperty		XmpDeleteSimplePropertyW
#define	XmpDeleteArrayProperty		XmpDeleteArrayPropertyW
#define	XmpDeleteArrayItem			XmpDeleteArrayItemW
#define	XmpDeleteArrayAltLangText	XmpDeleteArrayAltLangTextW
#define	XmpDeleteStructureProperty	XmpDeleteStructurePropertyW
#define	XmpDeleteStructureField		XmpDeleteStructureFieldW
#define	XmpCreateProperty			XmpCreatePropertyW
#define	XmpCreateSimple				XmpCreateSimpleW
#define	XmpCreateUnorderedArray		XmpCreateUnorderedArrayW
#define	XmpCreateOrderedArray		XmpCreateOrderedArrayW
#define	XmpCreateAlternateArray		XmpCreateAlternateArrayW
#define	XmpCreateStructure			XmpCreateStructureW
#define	XmpCreateStructureField		XmpCreateStructureFieldW
#define	XmpSetQualifier				XmpSetQualifierW
#define	XmpGetQualifier				XmpGetQualifierW

#define	XmpReplaceTitle				XmpReplaceTitleW
#define	XmpSetTitle					XmpSetTitleW
#define	XmpGetTitle					XmpGetTitleW
#define	XmpDeleteTitleItem			XmpDeleteTitleItemW
#define	XmpSetCreator				XmpSetCreatorW
#define	XmpSetCreatorIndex			XmpSetCreatorIndexW
#define	XmpInsertCreator			XmpInsertCreatorW
#define	XmpReplaceCreator			XmpReplaceCreatorW
#define	XmpGetDescriptionItem		XmpGetDescriptionItemW
#define	XmpDeleteDescriptionItem	XmpDeleteDescriptionItemW
#define	XmpGetCreatorIndex			XmpGetCreatorIndexW
#define	XmpGetCreator				XmpGetCreatorW
#define	XmpReplaceDescription		XmpReplaceDescriptionW
#define	XmpSetDescription			XmpSetDescriptionW
#define	XmpGetSimpleLocalDate		XmpGetSimpleLocalDateW
#define	XmpGetSimpleUtcDate			XmpGetSimpleUtcDateW
#define	XmpSetSimpleLocalDate		XmpSetSimpleLocalDateW
#define	XmpSetSimpleUtcDate			XmpSetSimpleUtcDateW
#define	XmpSetSimpleDateTz			XmpSetSimpleDateTzW
#define	XmpSetSimpleDateFmt			XmpSetSimpleDateFmtW
#define	XmpSetSimpleCurrentDate		XmpSetSimpleCurrentDateW
#define	XmpDumpObjectToFile			XmpDumpObjectToFileW
#define	XmpDumpObjectToChar			XmpDumpObjectToCharW
#define	XmpRegisterNamespace		XmpRegisterNamespaceW
#define	XmpConvertCurrentDateToStr	XmpConvertCurrentDateToStrW
#define	XmpConvertLocalDateToStr	XmpConvertLocalDateToStrW
#define	XmpConvertFmtDateToStr		XmpConvertFmtDateToStrW
#define	XmpConvertStrDateToFmt		XmpConvertStrDateToFmtW
#define	XmpConvertStrDateToLocal	XmpConvertStrDateToLocalW
#define	XmpConvertStrDateToUtc		XmpConvertStrDateToUtcW
#define	XmpGetLastError				XmpGetLastErrorW
#define	XmpReplaceKeywords			XmpReplaceKeywordsW
#define	XmpSetKeywords				XmpSetKeywordsW
#define	XmpGetKeywords				XmpGetKeywordsW
#define	XmpSetSubject				XmpSetSubjectW
#define	XmpSetSubjectIndex			XmpSetSubjectIndexW
#define	XmpInsertSubject			XmpInsertSubjectW
#define	XmpGetSubjectIndex			XmpGetSubjectIndexW
#define	XmpReplaceRights			XmpReplaceRightsW
#define	XmpSetRights				XmpSetRightsW
#define	XmpReplaceRightsWebStatement	XmpReplaceRightsWebStatementW
#else	//_UNICODE
#define	XmpDoesPropertyExist		XmpDoesPropertyExistA
#define	XmpDoesSimplePropertyExist	XmpDoesSimplePropertyExistA
#define	XmpDoesArrayPropertyExist	XmpDoesArrayPropertyExistA
#define	XmpDoesArrayItemExist		XmpDoesArrayItemExistA
#define	XmpDoesStructurePropertyExist XmpDoesStructurePropertyExistA
#define	XmpDoesStructureFieldExist	XmpDoesStructureFieldExistA
#define	XmpCountStructureFields		XmpCountStructureFieldsA
#define	XmpGetProperty				XmpGetPropertyA
#define	XmpGetSimpleProperty		XmpGetSimplePropertyA
#define	XmpGetArrayItem				XmpGetArrayItemA
#define	XmpGetLocalizedText			XmpGetLocalizedTextA
#define	XmpCountArrayItems			XmpCountArrayItemsA
#define	XmpGetStructureField		XmpGetStructureFieldA
#define	XmpSetProperty				XmpSetPropertyA
#define	XmpSetSimpleProperty		XmpSetSimplePropertyA
#define	XmpSetArrayItem				XmpSetArrayItemA
#define	XmpInsertArrayItem			XmpInsertArrayItemA
#define	XmpGetArrayAltLangText		XmpGetArrayAltLangTextA
#define	XmpSetArrayAltLangText		XmpSetArrayAltLangTextA
#define	XmpSetLocalizedText			XmpSetLocalizedTextA
#define	XmpAppendArrayItem			XmpAppendArrayItemA
#define	XmpSetStructureField		XmpSetStructureFieldA
#define	XmpDeleteProperty			XmpDeletePropertyA
#define	XmpDeleteSimpleProperty		XmpDeleteSimplePropertyA
#define	XmpDeleteArrayProperty		XmpDeleteArrayPropertyA
#define	XmpDeleteArrayItem			XmpDeleteArrayItemA
#define	XmpDeleteArrayAltLangText	XmpDeleteArrayAltLangTextA
#define	XmpDeleteStructureProperty	XmpDeleteStructurePropertyA
#define	XmpDeleteStructureField		XmpDeleteStructureFieldA
#define	XmpCreateProperty			XmpCreatePropertyA
#define	XmpCreateSimple				XmpCreateSimpleA
#define	XmpCreateUnorderedArray		XmpCreateUnorderedArrayA
#define	XmpCreateOrderedArray		XmpCreateOrderedArrayA
#define	XmpCreateAlternateArray		XmpCreateAlternateArrayA
#define	XmpCreateStructure			XmpCreateStructureA
#define	XmpCreateStructureField		XmpCreateStructureFieldA
#define	XmpSetQualifier				XmpSetQualifierA
#define	XmpGetQualifier				XmpGetQualifierA
#define	XmpReplaceTitle				XmpReplaceTitleA
#define	XmpSetTitle					XmpSetTitleA
#define	XmpGetTitle					XmpGetTitleA
#define	XmpDeleteTitleItem			XmpDeleteTitleItemA
#define	XmpSetCreator				XmpSetCreatorA
#define	XmpSetCreatorIndex			XmpSetCreatorIndexA
#define	XmpInsertCreator			XmpInsertCreatorA
#define	XmpReplaceCreator			XmpReplaceCreatorA
#define	XmpGetCreatorIndex			XmpGetCreatorIndexA
#define	XmpGetCreator				XmpGetCreatorA
#define	XmpReplaceDescription		XmpReplaceDescriptionA
#define	XmpSetDescription			XmpSetDescriptionA
#define	XmpGetDescriptionItem		XmpGetDescriptionItemA
#define	XmpDeleteDescriptionItem	XmpDeleteDescriptionItemA
#define	XmpGetSimpleLocalDate		XmpGetSimpleLocalDateA
#define	XmpGetSimpleUtcDate			XmpGetSimpleUtcDateA
#define	XmpSetSimpleLocalDate		XmpSetSimpleLocalDateA
#define	XmpSetSimpleUtcDate			XmpSetSimpleUtcDateA
#define	XmpSetSimpleDateTz			XmpSetSimpleDateTzA
#define	XmpSetSimpleDateFmt			XmpSetSimpleDateFmtA
#define	XmpSetSimpleCurrentDate		XmpSetSimpleCurrentDateA
#define	XmpDumpObjectToFile			XmpDumpObjectToFileA
#define	XmpDumpObjectToChar			XmpDumpObjectToCharA
#define	XmpRegisterNamespace		XmpRegisterNamespaceA
#define	XmpConvertCurrentDateToStr	XmpConvertCurrentDateToStrA
#define	XmpConvertLocalDateToStr	XmpConvertLocalDateToStrA
#define	XmpConvertFmtDateToStr		XmpConvertFmtDateToStrA
#define	XmpConvertStrDateToFmt		XmpConvertStrDateToFmtA
#define	XmpConvertStrDateToLocal	XmpConvertStrDateToLocalA
#define	XmpConvertStrDateToUtc		XmpConvertStrDateToUtcA
#define	XmpGetLastError				XmpGetLastErrorA
#define	XmpReplaceKeywords			XmpReplaceKeywordsA
#define	XmpSetKeywords				XmpSetKeywordsA
#define	XmpGetKeywords				XmpGetKeywordsA
#define	XmpSetSubject				XmpSetSubjectA
#define	XmpSetSubjectIndex			XmpSetSubjectIndexA
#define	XmpInsertSubject			XmpInsertSubjectA
#define	XmpGetSubjectIndex			XmpGetSubjectIndexA
#define	XmpReplaceRights			XmpReplaceRightsA
#define	XmpSetRights				XmpSetRightsA
#define	XmpReplaceRightsWebStatement	XmpReplaceRightsWebStatementA
#endif	//_UNICODE

#ifdef	__cplusplus
extern "C" {
#endif

#ifndef IMAGER_LP_H

	/*初期化*/
	MLPAPI int WINAPI MlpInitializeA(const char* license);
	MLPAPI int WINAPI MlpInitializeW(const wchar_t* license);
	MLPAPI int WINAPI MlpUninitialize();
	MLPAPI int WINAPI MlpAddLicenseA(const char* license);
	MLPAPI void WINAPI MlpSetErrorStyle(int style);

	/*初期化データ*/
	MLPAPI int WINAPI MlpLoadInitFileW(const wchar_t* fileName);
	MLPAPI int WINAPI MlpLoadInitFileA(const char* fileName);
	MLPAPI int WINAPI MlpLoadInitDataW(const wchar_t* data, int len);
	MLPAPI int WINAPI MlpLoadInitDataA(const char* data, int len);

	/*ライセンス情報*/
	MLPAPI void WINAPI MlpShowLicenseInfo();
	MLPAPI char* WINAPI MlpGetLicenseInfoA();
	MLPAPI wchar_t* WINAPI MlpGetLicenseInfoW();

	/*オープン*/
	MLPAPI int WINAPI MlpOpenDoc0W(const wchar_t* fileName, const wchar_t* ownerPassword, const wchar_t* userPassword);
	MLPAPI int WINAPI MlpOpenDoc0A(const char* fileName, const char* ownerPassword, const char* userPassword);
	MLPAPI int WINAPI MlpOpenDocW(const wchar_t* fileName, const wchar_t* password);
	MLPAPI int WINAPI MlpOpenDocA(const char* fileName, const char* password);
	MLPAPI int WINAPI MlpOpenDocLegacyW(const wchar_t* fileName, const wchar_t* ownerPassword, const wchar_t* userPassword);
	MLPAPI int WINAPI MlpOpenDocLegacyA(const char* fileName, const char* ownerPassword, const char* userPassword);
	MLPAPI int WINAPI MlpOpenNewDoc(float width, float height, int rotate, void*);
	MLPAPI int WINAPI MlpOpenDocUsageW(const wchar_t* fileName, const wchar_t* password, int usage);
	MLPAPI int WINAPI MlpOpenDocUsageA(const char* fileName, const char* password, int usage);
	MLPAPI int WINAPI MlpOpenMemDocA(unsigned char* data, size_t length, const char* password);
	MLPAPI int WINAPI MlpOpenMemDocUsageA(unsigned char* data, size_t len, const char* password, int usage);
	MLPAPI int WINAPI MlpCloseDoc();

	/*ライブラリ情報*/
	MLPAPI int WINAPI MlpGetLibraryInfo(int cmd, ...);
	MLPAPI int WINAPI MlpGetMinimumLineWidth(float*);
	MLPAPI int WINAPI MlpGetPictureXResolution();
	MLPAPI int WINAPI MlpGetPictureYResolution();
	MLPAPI int WINAPI MlpGetPictureQuality();
	MLPAPI int WINAPI MlpGetFillPathAALevel();

	/*文書情報*/
	MLPAPI int WINAPI MlpGetDocumentInfo(int cmd, ...);
	MLPAPI int WINAPI MlpPageCount();
	MLPAPI int WINAPI MlpGetPageCount();
	MLPAPI int WINAPI MlpGetMetadata(unsigned char** metadata);
	MLPAPI int WINAPI MlpGetTitle(wchar_t** title);
	MLPAPI int WINAPI MlpPrintRestriction();
	MLPAPI int WINAPI MlpConvertToLastVersionA(const char* originalFileName, const char* lastVersionFileName);
	MLPAPI int WINAPI MlpConvertToLastVersionW(const wchar_t* originalFileName, const wchar_t* lastVersionFileName);
	MLPAPI int WINAPI MlpCountDocumentVersionA(const char* fileName);
	MLPAPI int WINAPI MlpCountDocumentVersionW(const wchar_t* fileName);
	MLPAPI int WINAPI MlpCountDocumentUpdates();
	MLPAPI int WINAPI MlpSaveLastPDFA(const char* fileName);
	MLPAPI int WINAPI MlpSaveLastPDFW(const wchar_t* fileName);
	MLPAPI int WINAPI MlpSimpleFontListGetNameA(int number, char** fontName, int* embeddedFlag, int* fontType);
	MLPAPI int WINAPI MlpSimpleFontListGetNameW(int number, wchar_t** fontName, int* embeddedFlag, int* fontType);
	MLPAPI int WINAPI MlpGetFontListA(MlpFontList**);
	MLPAPI int WINAPI MlpGetFontListW(MlpFontList**);
	MLPAPI int WINAPI MlpGetFontListU8(MlpFontList**);
	MLPAPI MlpFormData WINAPI MlpInteractiveFormFirstData();
	MLPAPI MlpFormData WINAPI MlpInteractiveFormNextData();

	/*Primitiveインターフェース*/
	MLPAPI PRIMITIVE_HANDLE WINAPI MlpGetPrimitiveInterface();
	MLPAPI void WINAPI MlpFinishPrimitiveInterface();
	MLPAPI void WINAPI PrmCloseInterface(PRIMITIVE_HANDLE);
	MLPAPI int WINAPI PrmDocumentToFileA(PRIMITIVE_HANDLE, char* outputFilePath);
	MLPAPI int WINAPI PrmDocumentToFileW(PRIMITIVE_HANDLE, wchar_t* outputFilePath);

	MLPAPI int WINAPI PrmShowXref(PRIMITIVE_HANDLE);
	MLPAPI int WINAPI PrmShowTrailer(PRIMITIVE_HANDLE, int pretty);
	MLPAPI int WINAPI PrmShowCatalog(PRIMITIVE_HANDLE, int pretty);
	MLPAPI int WINAPI PrmShowDocumentInformation(PRIMITIVE_HANDLE, int pretty);
	MLPAPI int WINAPI PrmShowPageTree(PRIMITIVE_HANDLE, int pretty);
	MLPAPI int WINAPI PrmShowNumberedObject(PRIMITIVE_HANDLE, unsigned int objectNumber, int pretty);
	MLPAPI int WINAPI PrmShowNumberedObjectWithStream(PRIMITIVE_HANDLE, unsigned int objectNumber, int pretty, int ascii);
	MLPAPI int WINAPI PrmShowStream(PRIMITIVE_HANDLE, unsigned int objectNumber);

	MLPAPI int WINAPI PrmStringXref(PRIMITIVE_HANDLE, char **data);
	MLPAPI int WINAPI PrmStringTrailer(PRIMITIVE_HANDLE, int pretty, char **data);
	MLPAPI int WINAPI PrmStringCatalog(PRIMITIVE_HANDLE, int pretty, char **data);
	MLPAPI int WINAPI PrmStringDocumentInformation(PRIMITIVE_HANDLE, int pretty, char **data);
	MLPAPI int WINAPI PrmStringPageTree(PRIMITIVE_HANDLE, int pretty, char **data);
	MLPAPI int WINAPI PrmStringObject(PRIMITIVE_HANDLE, unsigned int objectNumber, int pretty, char **data);
	MLPAPI int WINAPI PrmStringStream(PRIMITIVE_HANDLE, unsigned int objectNumber, char **data);

	MLPAPI int WINAPI PrmObjectHasStream(PRIMITIVE_HANDLE, unsigned int objectNumber);
	MLPAPI int WINAPI PrmGetXrefOffset(PRIMITIVE_HANDLE);
	MLPAPI int WINAPI PrmIsXrefTable(PRIMITIVE_HANDLE);
	MLPAPI int WINAPI PrmIsXrefStream(PRIMITIVE_HANDLE, int* num, int* gen);
	MLPAPI int WINAPI PrmXrefTable(PRIMITIVE_HANDLE, PrmDocumentXref** data);
	MLPAPI int WINAPI PrmXrefStream(PRIMITIVE_HANDLE, PrmDocumentXref** data);

	MLPAPI PrmObjectHandle WINAPI PrmObjectHandleTrailer(PRIMITIVE_HANDLE);
	MLPAPI PrmObjectHandle WINAPI PrmObjectHandleCatalog(PRIMITIVE_HANDLE);
	MLPAPI PrmObjectHandle WINAPI PrmObjectHandleDocumentInformation(PRIMITIVE_HANDLE);
	MLPAPI PrmObjectHandle WINAPI PrmObjectHandlePageTree(PRIMITIVE_HANDLE);
	MLPAPI PrmObjectHandle WINAPI PrmObjectHandlePage(PRIMITIVE_HANDLE, int pageNumber);
	MLPAPI int WINAPI PrmObjectHandleGetStream(PRIMITIVE_HANDLE, PrmObjectHandle referenceObject, unsigned char** data);
	MLPAPI int WINAPI PrmObjectHandleSetStream(PRIMITIVE_HANDLE, PrmObjectHandle referenceObject, unsigned char* data, unsigned int length);
	MLPAPI PrmObjectHandle WINAPI PrmObjectHandleNumberedObject(PRIMITIVE_HANDLE, unsigned int objectNumber);
	MLPAPI int WINAPI PrmObjectHandleLength(PRIMITIVE_HANDLE, PrmObjectHandle);
	MLPAPI int WINAPI PrmObjectHandleHasStream(PRIMITIVE_HANDLE, PrmObjectHandle);
	MLPAPI int WINAPI PrmObjectHandleDictionaryLength(PRIMITIVE_HANDLE, PrmObjectHandle dictionaryObject);
	MLPAPI PrmObjectHandle WINAPI PrmObjectHandleDictionaryKey(PRIMITIVE_HANDLE, PrmObjectHandle dictionaryObject, unsigned int index);
	MLPAPI PrmObjectHandle WINAPI PrmObjectHandleDictionaryValue(PRIMITIVE_HANDLE, PrmObjectHandle dictionaryObject, unsigned int index);
	MLPAPI PrmObjectHandle WINAPI PrmObjectHandleDictionaryByString(PRIMITIVE_HANDLE, PrmObjectHandle dictionaryObject, const char *key);
	MLPAPI PrmObjectHandle WINAPI PrmObjectHandleDictionaryByObject(PRIMITIVE_HANDLE, PrmObjectHandle dictionaryObject, PrmObjectHandle key);
	MLPAPI int WINAPI PrmObjectHandleArrayLength(PRIMITIVE_HANDLE, PrmObjectHandle arryObject);
	MLPAPI PrmObjectHandle WINAPI PrmObjectHandleArrayValue(PRIMITIVE_HANDLE, PrmObjectHandle arryObject, unsigned int index);
	MLPAPI int WINAPI PrmObjectHandleReferenceToNumber(PRIMITIVE_HANDLE, PrmObjectHandle);
	MLPAPI int WINAPI PrmObjectHandleReferenceToGeneration(PRIMITIVE_HANDLE, PrmObjectHandle);
	MLPAPI PrmObjectHandle WINAPI PrmObjectHandleReferenceToObject(PRIMITIVE_HANDLE, PrmObjectHandle);
	MLPAPI int WINAPI PrmObjectHandleToBool(PRIMITIVE_HANDLE, PrmObjectHandle);
	MLPAPI int WINAPI PrmObjectHandleToInt(PRIMITIVE_HANDLE, PrmObjectHandle);
	MLPAPI float WINAPI PrmObjectHandleToReal(PRIMITIVE_HANDLE, PrmObjectHandle);
	MLPAPI char* WINAPI PrmObjectHandleToStr(PRIMITIVE_HANDLE, PrmObjectHandle);
	MLPAPI char* WINAPI PrmObjectHandleToName(PRIMITIVE_HANDLE, PrmObjectHandle);
	MLPAPI int WINAPI PrmShowObjectHandle(PRIMITIVE_HANDLE, PrmObjectHandle, int resolve, int stream, int pretty);
	MLPAPI int WINAPI PrmStringObjectHandle(PRIMITIVE_HANDLE, PrmObjectHandle, int resolve, int stream, int pretty, char **data);

	/*XMPインターフェース*/
	MLPAPI XMP_HANDLE WINAPI MlpGetXmpInterface();
	MLPAPI int WINAPI XmpDocumentToFile(XMP_HANDLE, const char *fileName);
	MLPAPI void WINAPI XmpCloseInterface(XMP_HANDLE);
	MLPAPI int WINAPI XmpDoesPropertyExistA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpDoesPropertyExistW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);
	MLPAPI int WINAPI XmpGetPropertyA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, char** value, long* optionBits);
	MLPAPI int WINAPI XmpGetPropertyW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, wchar_t** value, long* optionBits);
	MLPAPI int WINAPI XmpSetPropertyA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* value, const long optionBits);
	MLPAPI int WINAPI XmpSetPropertyW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, const wchar_t* value, const long optionBits);
	MLPAPI int WINAPI XmpCreatePropertyA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* propertyValue, const long optionBits);
	MLPAPI int WINAPI XmpCreatePropertyW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, const wchar_t* propertyValue, const long optionBits);
	MLPAPI int WINAPI XmpDeletePropertyA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpDeletePropertyW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);
	MLPAPI int WINAPI XmpGetLocalizedTextA(XMP_HANDLE, const char* uri, const char* altTextName, const char* genericLang, const char* specificLang, char** actualLang, char** value, long* optionBits);
	MLPAPI int WINAPI XmpGetLocalizedTextW(XMP_HANDLE, const wchar_t* uri, const wchar_t* altTextName, const wchar_t* genericLang, const wchar_t* specificLang, wchar_t** actualLang, wchar_t** value, long* optionBits);
	MLPAPI int WINAPI XmpSetLocalizedTextA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* genericLang, const char* specificLang, char* value);
	MLPAPI int WINAPI XmpSetLocalizedTextW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, const wchar_t* genericLang, const wchar_t* specificLang, wchar_t* value);
	MLPAPI int WINAPI XmpGetQualifierA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* qUriifierUri, const char* qualifierName, char** value);
	MLPAPI int WINAPI XmpGetQualifierW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, const wchar_t* qUriifierUri, const wchar_t* qualifierName, wchar_t** value);
	MLPAPI int WINAPI XmpSetQualifierA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* qualifierUri, const char* qualifierName, const char* value);
	MLPAPI int WINAPI XmpSetQualifierW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, const wchar_t* qualifierUri, const wchar_t* qualifierName, const wchar_t* value);

	MLPAPI int WINAPI XmpDoesSimplePropertyExistA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpDoesSimplePropertyExistW(XMP_HANDLE, const wchar_t *namespaceURI, const wchar_t *propertyName);
	MLPAPI int WINAPI XmpGetSimplePropertyA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, char** value);
	MLPAPI int WINAPI XmpGetSimplePropertyW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, wchar_t** value);
	MLPAPI int WINAPI XmpSetSimplePropertyA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* value);
	MLPAPI int WINAPI XmpSetSimplePropertyW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, const wchar_t* value);
	MLPAPI int WINAPI XmpCreateSimpleA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpCreateSimpleW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);
	MLPAPI int WINAPI XmpDeleteSimplePropertyA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpDeleteSimplePropertyW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);

	MLPAPI int WINAPI XmpGetSimpleLocalDateA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, time_t* datetime);
	MLPAPI int WINAPI XmpGetSimpleLocalDateW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, time_t* localDatetime);
	MLPAPI int WINAPI XmpGetSimpleUtcDateA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, time_t* UTCDatetime);
	MLPAPI int WINAPI XmpGetSimpleUtcDateW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, time_t* UTCDatetime);
	MLPAPI int WINAPI XmpSetSimpleLocalDateA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, time_t datetime);
	MLPAPI int WINAPI XmpSetSimpleLocalDateW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, time_t localDatetime);
	MLPAPI int WINAPI XmpSetSimpleUtcDateA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, time_t UTCDatetime);
	MLPAPI int WINAPI XmpSetSimpleUtcDateW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, time_t UTCDatetime);
	MLPAPI int WINAPI XmpSetSimpleDateTzA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, time_t localdatetime, int tzSign, int tzHour, int tzMinute);
	MLPAPI int WINAPI XmpSetSimpleDateTzW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, time_t localDatetime, int tzSign, int tzHour, int tzMinute);
	MLPAPI int WINAPI XmpSetSimpleDateFmtA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, time_t zoneTime, int nanosecond, int formatNumber, int tzSign, int tzHour, int tzMinute);
	MLPAPI int WINAPI XmpSetSimpleDateFmtW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, time_t zoneTime, int nanosecond, int formatNumber, int tzSign, int tzHour, int tzMinute);
	MLPAPI int WINAPI XmpSetSimpleCurrentDateA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpSetSimpleCurrentDateW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);

	MLPAPI int WINAPI XmpDoesArrayPropertyExistA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpDoesArrayPropertyExistW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);
	MLPAPI int WINAPI XmpDoesArrayItemExistA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, int itemIndex);
	MLPAPI int WINAPI XmpDoesArrayItemExistW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, int itemIndex);
	MLPAPI int WINAPI XmpCountArrayItemsA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpCountArrayItemsW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);
	MLPAPI int WINAPI XmpGetArrayItemA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, int itemIndex, char** value);
	MLPAPI int WINAPI XmpGetArrayItemW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, int itemIndex, wchar_t** value);
	MLPAPI int WINAPI XmpSetArrayItemA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, int itemIndex, const char* value);
	MLPAPI int WINAPI XmpSetArrayItemW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, int itemIndex, const wchar_t* value);
	MLPAPI int WINAPI XmpInsertArrayItemA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, int itemIndex, const char* value);
	MLPAPI int WINAPI XmpInsertArrayItemW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, int itemIndex, const wchar_t* value);
	MLPAPI int WINAPI XmpGetArrayAltLangTextA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* genericLang, const char* specificLang, char** actualLang, char** value);
	MLPAPI int WINAPI XmpGetArrayAltLangTextW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, const wchar_t* genericLang, const wchar_t* specificLang, wchar_t** actualLang, wchar_t** value);
	MLPAPI int WINAPI XmpSetArrayAltLangTextA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* genericLang, const char* specificLang, const char* value);
	MLPAPI int WINAPI XmpSetArrayAltLangTextW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, const wchar_t* genericLang, const wchar_t* specificLang, const wchar_t* value);
	MLPAPI int WINAPI XmpAppendArrayItemA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* value);
	MLPAPI int WINAPI XmpAppendArrayItemW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, const wchar_t* value);
	MLPAPI int WINAPI XmpCreateOrderedArrayA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpCreateOrderedArrayW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);
	MLPAPI int WINAPI XmpCreateUnorderedArrayA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpCreateUnorderedArrayW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);
	MLPAPI int WINAPI XmpCreateAlternateArrayA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpCreateAlternateArrayW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);
	MLPAPI int WINAPI XmpDeleteArrayPropertyA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpDeleteArrayPropertyW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);
	MLPAPI int WINAPI XmpDeleteArrayItemA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, int itemIndex);
	MLPAPI int WINAPI XmpDeleteArrayItemW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, int itemIndex);
	MLPAPI int WINAPI XmpDeleteArrayAltLangTextA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* genericLng, const char* specificLang);
	MLPAPI int WINAPI XmpDeleteArrayAltLangTextW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, const wchar_t* genericLng, const wchar_t* specificLang);
	MLPAPI int WINAPI XmpDoesStructurePropertyExistA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpDoesStructurePropertyExistW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);
	MLPAPI int WINAPI XmpDoesStructureFieldExistA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* fieldUri, const char* fieldName);
	MLPAPI int WINAPI XmpDoesStructureFieldExistW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* prop, const wchar_t* fieldUri, const wchar_t* fieldName);
	MLPAPI int WINAPI XmpCountStructureFieldsA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpCountStructureFieldsW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);
	MLPAPI int WINAPI XmpGetStructureFieldA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* fieldUri, const char* fieldName, char** value);
	MLPAPI int WINAPI XmpGetStructureFieldW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, const wchar_t* fieldUri, const wchar_t* fieldName, wchar_t** value);
	MLPAPI int WINAPI XmpSetStructureFieldA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* fieldUri, const char* fieldName, const char* value);
	MLPAPI int WINAPI XmpSetStructureFieldW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* prop, const wchar_t* fieldUri, const wchar_t* fieldName, const wchar_t* value);
	MLPAPI int WINAPI XmpCreateStructureA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpCreateStructureW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName);
	MLPAPI int WINAPI XmpCreateStructureFieldA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* fieldUri, const char* fieldName);
	MLPAPI int WINAPI XmpCreateStructureFieldW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* propertyName, const wchar_t* fieldUri, const wchar_t* fieldName);
	MLPAPI int WINAPI XmpDeleteStructurePropertyA(XMP_HANDLE, const char* namespaceURI, const char* propertyName);
	MLPAPI int WINAPI XmpDeleteStructurePropertyW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* prop);
	MLPAPI int WINAPI XmpDeleteStructureFieldA(XMP_HANDLE, const char* namespaceURI, const char* propertyName, const char* fieldUri, const char* fieldName);
	MLPAPI int WINAPI XmpDeleteStructureFieldW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* prop, const wchar_t* fieldUri, const wchar_t* fieldName);

	//Title Array(Ordered)
	MLPAPI int WINAPI XmpGetTitleA(XMP_HANDLE, const char* genericLanguage, const char* specificLanguage, char** actualLang, char** value);
	MLPAPI int WINAPI XmpGetTitleW(XMP_HANDLE, const wchar_t* genericLanguage, const wchar_t* specificLanguage, wchar_t** actualLanguage, wchar_t** value);
	MLPAPI int WINAPI XmpReplaceTitleA(XMP_HANDLE, const char* genericLanguage, const char* specificLanguage, const char* value);
	MLPAPI int WINAPI XmpReplaceTitleW(XMP_HANDLE, const wchar_t* genericLanguage, const wchar_t* specificLanguage, const wchar_t* value);
	MLPAPI int WINAPI XmpSetTitleA(XMP_HANDLE, const char* genericLanguage, const char* specificLanguage, const char* value);
	MLPAPI int WINAPI XmpSetTitleW(XMP_HANDLE, const wchar_t* genericLanguage, const wchar_t* specificLanguage, const wchar_t* value);
	MLPAPI int WINAPI XmpCountTitles(XMP_HANDLE);
	MLPAPI int WINAPI XmpDeleteTitle(XMP_HANDLE);
	MLPAPI int WINAPI XmpDeleteTitleItemA(XMP_HANDLE, const char* genericLanguage, const char* specificLanguage);
	MLPAPI int WINAPI XmpDeleteTitleItemW(XMP_HANDLE, const wchar_t* genericLanguage, const wchar_t* specificLanguage);

	//Creator Array(Ordered)
	MLPAPI int WINAPI XmpGetCreatorA(XMP_HANDLE, char** value);
	MLPAPI int WINAPI XmpGetCreatorW(XMP_HANDLE, wchar_t** value);
	MLPAPI int WINAPI XmpGetCreatorIndexA(XMP_HANDLE, int itemIndex, char** value);
	MLPAPI int WINAPI XmpGetCreatorIndexW(XMP_HANDLE, int itemIndex, wchar_t** value);
	MLPAPI int WINAPI XmpReplaceCreatorA(XMP_HANDLE, const char* value);
	MLPAPI int WINAPI XmpReplaceCreatorW(XMP_HANDLE, const wchar_t* value);
	MLPAPI int WINAPI XmpSetCreatorA(XMP_HANDLE, const char* value);
	MLPAPI int WINAPI XmpSetCreatorW(XMP_HANDLE, const wchar_t* value);
	MLPAPI int WINAPI XmpSetCreatorIndexA(XMP_HANDLE, int itemIndex, const char* value);
	MLPAPI int WINAPI XmpSetCreatorIndexW(XMP_HANDLE, int itemIndex, const wchar_t* value);
	MLPAPI int WINAPI XmpInsertCreatorA(XMP_HANDLE, int itemIndex, const char* value);
	MLPAPI int WINAPI XmpInsertCreatorW(XMP_HANDLE, int itemIndex, const wchar_t* value);
	MLPAPI int WINAPI XmpCountCreatorItems(XMP_HANDLE);
	MLPAPI int WINAPI XmpDeleteCreator(XMP_HANDLE);
	MLPAPI int WINAPI XmpDeleteCreatorItem(XMP_HANDLE, int itemIndex);

	//Description Array(Alternate)
	MLPAPI int WINAPI XmpGetDescriptionItemA(XMP_HANDLE, const char* genericlanguage, const char* specificlanguage, char** actualLenguage, char** value);
	MLPAPI int WINAPI XmpGetDescriptionItemW(XMP_HANDLE, const wchar_t* genericlanguage, const wchar_t* specificlanguage, wchar_t** actualLenguage, wchar_t** value);
	MLPAPI int WINAPI XmpReplaceDescriptionA(XMP_HANDLE, const char* genericLanguage, const char* specificLanguage, const char* value);
	MLPAPI int WINAPI XmpReplaceDescriptionW(XMP_HANDLE, const wchar_t* genericLanguage, const wchar_t* specificLanguage, const wchar_t* value);
	MLPAPI int WINAPI XmpSetDescriptionA(XMP_HANDLE, const char* genericLanguage, const char* specificLanguage, const char* value);
	MLPAPI int WINAPI XmpSetDescriptionW(XMP_HANDLE, const wchar_t* genericLanguage, const wchar_t* specificLanguage, const wchar_t* value);
	MLPAPI int WINAPI XmpCountDescription(XMP_HANDLE);
	MLPAPI int WINAPI XmpDeleteDescription(XMP_HANDLE);
	MLPAPI int WINAPI XmpDeleteDescriptionItemA(XMP_HANDLE, const char* genericLanguage, const char* specificLanguage);
	MLPAPI int WINAPI XmpDeleteDescriptionItemW(XMP_HANDLE, const wchar_t* genericLanguage, const wchar_t* specificLanguage);

	//Simple
	MLPAPI int WINAPI XmpGetKeywordsA(XMP_HANDLE, char** value);
	MLPAPI int WINAPI XmpGetKeywordsW(XMP_HANDLE, wchar_t** value);
	MLPAPI int WINAPI XmpReplaceKeywordsA(XMP_HANDLE, char* value);
	MLPAPI int WINAPI XmpReplaceKeywordsW(XMP_HANDLE, wchar_t* value);
	MLPAPI int WINAPI XmpSetKeywordsA(XMP_HANDLE, char* value);
	MLPAPI int WINAPI XmpSetKeywordsW(XMP_HANDLE, wchar_t* value);
	MLPAPI int WINAPI XmpDeleteKeywords(XMP_HANDLE);

#define	XmpDeleteSubject	XmpDeleteKeywords
	//Unordered Array
	MLPAPI int WINAPI XmpGetSubjectIndexA(XMP_HANDLE, int itemIndex, char** value);
	MLPAPI int WINAPI XmpGetSubjectIndexW(XMP_HANDLE, int itemIndex, wchar_t** value);
	MLPAPI int WINAPI XmpSetSubjectA(XMP_HANDLE , char* value);
	MLPAPI int WINAPI XmpSetSubjectW(XMP_HANDLE , wchar_t* value);
	MLPAPI int WINAPI XmpInsertSubjectA(XMP_HANDLE, int itemIndex ,char* value);
	MLPAPI int WINAPI XmpInsertSubjectW(XMP_HANDLE, int itemIndex ,wchar_t* value);
	MLPAPI int WINAPI XmpSetSubjectIndexA(XMP_HANDLE, int itemIndex, char* value);
	MLPAPI int WINAPI XmpSetSubjectIndexW(XMP_HANDLE, int itemIndex, wchar_t* value);
	MLPAPI int WINAPI XmpCountSubjectItems(XMP_HANDLE);
	MLPAPI int WINAPI XmpDeleteSubjectIndex(XMP_HANDLE, int itemIndex);

	//Alternate Array(Ordered)
	MLPAPI int WINAPI XmpReplaceRightsA(XMP_HANDLE, const char* genericLanguage, const char* specificLanguage, const char* value);
	MLPAPI int WINAPI XmpReplaceRightsW(XMP_HANDLE, const wchar_t* genericLanguage, const wchar_t* specificLanguage, const wchar_t* value);
	MLPAPI int WINAPI XmpSetRightsA(XMP_HANDLE, const char* genericLanguage, const char* specificLanguage, const char* value);
	MLPAPI int WINAPI XmpSetRightsW(XMP_HANDLE, const wchar_t* genericLanguage, const wchar_t* specificLanguage, const wchar_t* value);
	//Simple
	MLPAPI int WINAPI XmpReplaceRightsWebStatementA(XMP_HANDLE, char* value);
	MLPAPI int WINAPI XmpReplaceRightsWebStatementW(XMP_HANDLE, wchar_t* value);
	MLPAPI int WINAPI XmpReplaceRightsMarked(XMP_HANDLE, BOOL flag);
	MLPAPI int WINAPI XmpOmitRightsMarked(XMP_HANDLE);

	MLPAPI int WINAPI XmpDumpObjectToConsole(XMP_HANDLE);
	MLPAPI int WINAPI XmpDumpObjectToFileA(XMP_HANDLE, const char* fileName);
	MLPAPI int WINAPI XmpDumpObjectToFileW(XMP_HANDLE, const wchar_t* fileName);
	MLPAPI int WINAPI XmpDumpObjectToCharA(XMP_HANDLE, char **data);
	MLPAPI int WINAPI XmpDumpObjectToCharW(XMP_HANDLE, wchar_t** data);
	MLPAPI int WINAPI XmpRegisterNamespaceA(XMP_HANDLE, const char* namespaceURI, const char* suggestedPrefix, char** registeredPrefix);
	MLPAPI int WINAPI XmpRegisterNamespaceW(XMP_HANDLE, const wchar_t* namespaceURI, const wchar_t* suggestedPrefix, wchar_t** registeredPrefix);
	//Utility
	MLPAPI int WINAPI XmpConvertCurrentDateToStrA(XMP_HANDLE, char** value);
	MLPAPI int WINAPI XmpConvertCurrentDateToStrW(XMP_HANDLE, wchar_t** value);
	MLPAPI int WINAPI XmpConvertLocalDateToStrA(XMP_HANDLE, const time_t, char** value);
	MLPAPI int WINAPI XmpConvertLocalDateToStrW(XMP_HANDLE, const time_t, wchar_t** value);
	MLPAPI int WINAPI XmpConvertFmtDateToStrA(XMP_HANDLE, const time_t, int nanosecond, const int fmtNumber, const int tzSign, const int tzHour, const int tzMinute, char** value);
	MLPAPI int WINAPI XmpConvertFmtDateToStrW(XMP_HANDLE, const time_t, int nanosecond, const int fmtNumber, const int tzSign, const int tzHour, const int tzMinute, wchar_t** value);
	MLPAPI int WINAPI XmpConvertStrDateToFmtA(XMP_HANDLE, const char* dateString, int* formatNumber, time_t*, int* nanosecond, int* tzSign, int* tzHour, int* tzMinute);
	MLPAPI int WINAPI XmpConvertStrDateToFmtW(XMP_HANDLE, const wchar_t* dateString, int* formatNumber, time_t*, int* nanosecond, int* tzSign, int* tzHour, int* tzMinute);
	MLPAPI int WINAPI XmpConvertStrDateToLocalA(XMP_HANDLE, const char* dateString, time_t*);
	MLPAPI int WINAPI XmpConvertStrDateToLocalW(XMP_HANDLE, const wchar_t* dateString, time_t*);
	MLPAPI int WINAPI XmpConvertStrDateToUtcA(XMP_HANDLE, const char* dateString, time_t*);
	MLPAPI int WINAPI XmpConvertStrDateToUtcW(XMP_HANDLE, const wchar_t* dateString, time_t*);
	//Other
	MLPAPI int WINAPI XmpUpdateDocument(XMP_HANDLE);
	MLPAPI long WINAPI XmpGetLastErrorA(XMP_HANDLE, char** message);
	MLPAPI long WINAPI XmpGetLastErrorW(XMP_HANDLE, wchar_t** message);

	/*Modify Interface*/
	MLPAPI MOD_HANDLE WINAPI MlpGetModInterface();
	MLPAPI int WINAPI ModCloseInterface(MOD_HANDLE, int flag);
	MLPAPI int WINAPI ModRegisterFontA(MOD_HANDLE, char* requestFontName, char* fontPath, char** fontName);
	MLPAPI int WINAPI ModRegisterFontW(MOD_HANDLE, wchar_t* requestFontName, wchar_t* fontPath, wchar_t** fontName);
	MLPAPI int WINAPI ModRegisterImageA(MOD_HANDLE, char* imagePath, char** imageName);
	MLPAPI int WINAPI ModRegisterImageW(MOD_HANDLE, wchar_t* imagePath, wchar_t** ImageName);
	MLPAPI int WINAPI ModSetFontNameA(MOD_HANDLE, char* fontName);
	MLPAPI int WINAPI ModSetFontNameW(MOD_HANDLE, wchar_t* fontName);
	MLPAPI const char* WINAPI ModGetFontNameA(MOD_HANDLE);
	MLPAPI const wchar_t* WINAPI ModGetFontNameW(MOD_HANDLE);
	MLPAPI float WINAPI ModGetFontSize(MOD_HANDLE);
	MLPAPI int WINAPI ModSetFontSize(MOD_HANDLE, float size);
	MLPAPI float WINAPI ModGetTextLeading(MOD_HANDLE);
	MLPAPI int WINAPI ModSetTextLeading(MOD_HANDLE, float value);
	MLPAPI float WINAPI ModGetCharSpacing(MOD_HANDLE);
	MLPAPI int WINAPI ModSetCharSpacing(MOD_HANDLE, float value);
	MLPAPI int WINAPI ModSetImageNameA(MOD_HANDLE, char* imageName);
	MLPAPI int WINAPI ModSetImageNameW(MOD_HANDLE, wchar_t* imageName);
	MLPAPI const char* WINAPI ModGetImageNameA(MOD_HANDLE);
	MLPAPI const wchar_t* WINAPI ModGetImageNameW(MOD_HANDLE);
	MLPAPI int WINAPI ModSetFillColorArray(MOD_HANDLE, float* colorArray, unsigned char arrayLength);
	MLPAPI int WINAPI ModSetFillColorGray(MOD_HANDLE, float gray);
	MLPAPI int WINAPI ModSetFillColorRGB(MOD_HANDLE, float red, float green, float blue);
	MLPAPI int WINAPI ModSetFillColorCMYK(MOD_HANDLE, float cyan, float magenta, float yellow, float key);
	MLPAPI int WINAPI ModSetStrokeColorArray(MOD_HANDLE, float* colorArray, unsigned char arrayLength);
	MLPAPI int WINAPI ModSetStrokeColorGray(MOD_HANDLE, float gray);
	MLPAPI int WINAPI ModSetStrokeColorRGB(MOD_HANDLE, float red, float green, float blue);
	MLPAPI int WINAPI ModSetStrokeColorCMYK(MOD_HANDLE, float cyan, float magenta, float yellow, float key);
	MLPAPI int WINAPI ModSetTextRenderingMode(MOD_HANDLE, int renderingMode);
	MLPAPI int WINAPI ModSetPathRenderingMode(MOD_HANDLE, int renderingMode);
	MLPAPI int WINAPI ModGetTextRenderingMode(MOD_HANDLE);
	MLPAPI int WINAPI ModGetPathRenderingMode(MOD_HANDLE);
	MLPAPI int WINAPI ModSetTextLineWidth(MOD_HANDLE, float lineWidth);
	MLPAPI int WINAPI ModSetPathLineWidth(MOD_HANDLE, float lineWidth);
	MLPAPI float WINAPI ModGetTextLineWidth(MOD_HANDLE);
	MLPAPI float WINAPI ModGetPathLineWidth(MOD_HANDLE);
	MLPAPI int WINAPI ModSetPathDash(MOD_HANDLE, float* dashArray, int arrayLength, float dashPhase);
	MLPAPI int WINAPI ModClearPathDash(MOD_HANDLE);
	MLPAPI int WINAPI ModSetImageMatrix(MOD_HANDLE, Matrix);
	MLPAPI int WINAPI ModSetTransparent(MOD_HANDLE, float CA, float ca);
	MLPAPI int WINAPI ModPaintTextA(MOD_HANDLE, int pageNumber, float xpos, float ypos, char* text);
	MLPAPI int WINAPI ModPaintTextCS(MOD_HANDLE h, int pageNumber, float xpos, float ypos, wchar_t* text);	//C#専用
	MLPAPI int WINAPI ModEndText(MOD_HANDLE, int pageNumber);
	MLPAPI int WINAPI ModPaintTextW(MOD_HANDLE, int pageNumber, float xpos, float ypos, wchar_t* text);
	MLPAPI int WINAPI ModPaintTextArgA(MOD_HANDLE, ModTextArgA* arg);
	MLPAPI int WINAPI ModPaintTextArgW(MOD_HANDLE, ModTextArgW* arg);
	MLPAPI int WINAPI ModPaintRectangle(MOD_HANDLE, int pageNumber, float xpos, float ypos, float width, float height);
	MLPAPI int WINAPI ModPaintLine(MOD_HANDLE, int pageNumber, float xFrom, float yFrom, float xTo, float yTo);
	MLPAPI int WINAPI ModPaintEllipse(MOD_HANDLE, int pageNumber, float xcenter, float ycenter, float width, float height);
	MLPAPI int WINAPI ModPaintImage(MOD_HANDLE, int pageNumber, float xpos, float ypos);
	MLPAPI int WINAPI ModPaintImageSize(MOD_HANDLE, int pageNumber, float xpos, float ypos, float width, float height);
	MLPAPI int WINAPI ModPaintImageScale(MOD_HANDLE, int pageNumber, float xpos, float ypos, float scale);
	MLPAPI int WINAPI ModPaintMatrixValue(MOD_HANDLE, int pageNumber, float a, float b, float c, float d, float e, float f);
	MLPAPI int WINAPI ModPaintMatrixArray(MOD_HANDLE h, int pageNumber, float m[]);

	/*Secure Interface*/

	/*ページ情報*/
	MLPAPI int WINAPI MlpGetPageRotation(int pageNumber, int* rotate);
	MLPAPI int WINAPI MlpGetPageBoundary(int pageNumber, int kind, float* userUnit, float* left, float* bottom, float* right, float* top);
	MLPAPI int WINAPI MlpGetPageRawBoundary(int pageNumber, int kind, float* userUnit, float* left, float* bottom, float* right, float* top);
	MLPAPI int WINAPI MlpGetPicturePixel(int pageNumber, int* x, int* y);
	MLPAPI int WINAPI MlpGetPicturePixelX(int pageNumber);
	MLPAPI int WINAPI MlpGetPicturePixelY(int pageNumber);
	MLPAPI int WINAPI MlpGetCid0GlyphMode();

	/*設定*/
	MLPAPI int WINAPI MlpSetPicture(int opt, ...);
	MLPAPI int WINAPI MlpSetPictureSize(int x, int y, int unit);
	MLPAPI int WINAPI MlpSetPictureResolution(int dpi);
	MLPAPI int WINAPI MlpSetPictureXResolution(int dpi);
	MLPAPI int WINAPI MlpSetPictureYResolution(int dpi);
	MLPAPI int WINAPI MlpSetPictureQuality(int quality);
	MLPAPI int WINAPI MlpSetPicturePixelX(int x);
	MLPAPI int WINAPI MlpSetPicturePixelY(int y);
	MLPAPI int WINAPI MlpSetCanvasSize(int x, int y);
	MLPAPI int WINAPI MlpSetCanvasOrigin(int org);
	MLPAPI int WINAPI MlpSetTiffCompress(int mode);
	MLPAPI int WINAPI MlpSetFillPathAAEnable();
	MLPAPI int WINAPI MlpSetFillPathAADisable();
	MLPAPI int WINAPI MlpSetCid0GlyphMode(int mode);	/*ToBe Obsoleted*/
	MLPAPI int WINAPI MlpSetMinimumLineWidth(float width);
	MLPAPI int WINAPI MlpSetIncrementalUpdate(int flag);
	MLPAPI int WINAPI MlpAlternateAnnotFreeText(char *fontName, float fontSize, int numOfColors, float* colorValues);

	/*色空間*/
	MLPAPI int WINAPI MlpSetPictureRGB();
	MLPAPI int WINAPI MlpSetPictureCMYK();
	MLPAPI int WINAPI MlpSetPictureGray();
	MLPAPI int WINAPI MlpSetPictureBW();
	MLPAPI int WINAPI MlpSetPictureDither();

	/*カラープロファイル*/
	MLPAPI int WINAPI MlpUseCMS();
	MLPAPI int WINAPI MlpUnuseCMS();
	MLPAPI int WINAPI MlpSetColorProfileW(const wchar_t* fileName);
	MLPAPI int WINAPI MlpSetRGBProfileW(const wchar_t* fileName);
	MLPAPI int WINAPI MlpSetCMYKProfileW(const wchar_t* fileName);
	MLPAPI int WINAPI MlpSetGrayProfileW(const wchar_t* fileName);
	MLPAPI wchar_t* WINAPI MlpGetRGBProfileNameW();
	MLPAPI wchar_t* WINAPI MlpGetCMYKProfileNameW();
	MLPAPI wchar_t* WINAPI MlpGetGrayProfileNameW();
	MLPAPI int WINAPI MlpSetColorProfileA(const char* fileName);
	MLPAPI int WINAPI MlpSetRGBProfileA(const char* fileName);
	MLPAPI int WINAPI MlpSetCMYKProfileA(const char* fileName);
	MLPAPI int WINAPI MlpSetGrayProfileA(const char* fileName);
	MLPAPI char* WINAPI MlpGetRGBProfileNameA();
	MLPAPI char* WINAPI MlpGetCMYKProfileNameA();
	MLPAPI char* WINAPI MlpGetGrayProfileNameA();

	/*コールバック*/
	MLPAPI int WINAPI MlpSetCallbackFunc(int mode, int option, void* fnction);

	/*フォント*/
	MLPAPI int WINAPI MlpSetDefaultFontW(const wchar_t* defaultFont);
	MLPAPI int WINAPI MlpSetDefaultFontA(const char* defaultFont);
	MLPAPI int WINAPI MlpSetAlternateFontW(const wchar_t* org, const wchar_t* alt, int always);
	MLPAPI int WINAPI MlpSetAlternateFontA(const char* org, const char* alt, int always);
	MLPAPI int WINAPI MlpSetAlternateFont2W(const wchar_t* org, const wchar_t* alt, const wchar_t* weight, const wchar_t* style, int always, int replace);
	MLPAPI int WINAPI MlpSetAlternateFont2A(const char* org, const char* alt, const char* weight, const char* style, int always, int replace);

	/*ウォーターマーク*/
	MLPAPI int WINAPI MlpSetImageWatermarkW(const wchar_t* fileName, int x_position, int y_position, int z_position, float x_scale, float y_scale, float alpha);
	MLPAPI int WINAPI MlpSetImageWatermarkA(const char* fileName, int x_position, int y_position, int z_position, float x_scale, float y_scale, float alpha);
	MLPAPI int WINAPI MlpSetFillTextWatermarkW(const wchar_t* text, const wchar_t* fontName, int x_position, int y_position, int z_position, float fontSize, const wchar_t* colorName, float alpha);
	MLPAPI int WINAPI MlpSetFillTextWatermarkA(const char* text, const char* fontName, int x_position, int y_position, int z_position, float fontSize, const char* colorName, float alpha);
	MLPAPI int WINAPI MlpSetStrokeTextWatermarkW(const wchar_t* text, const wchar_t* fontName, int x_position, int y_position, int z_position, float fontSize, const wchar_t* colorName, float alpha);
	MLPAPI int WINAPI MlpSetStrokeTextWatermarkA(const char* text, char const* fontName, int x_position, int y_position, int z_position, float fontSize, const char* colorName, float alpha);
	MLPAPI int WINAPI MlpClearWatermarkData();

	/*レイヤー(OCG)*/
	MLPAPI int WINAPI MlpGetOcgCount();
	MLPAPI int WINAPI MlpGetOcgData(MlpOcgData* data[]);
	MLPAPI int WINAPI MlpGetOcgUsage(MlpOcgUsage* data[]);
	MLPAPI int WINAPI MlpSetOcgState(MlpOcgData data[]);
	MLPAPI int WINAPI MlpSetOcgStateUsage(MlpOcgUsage data[]);

	/*画像化*/
	MLPAPI int WINAPI MlpPageToPictW(int pageNumber, int dpi, int quality, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpPageToPictA(int pageNumber, int dpi, int quality, const char* outputFilePath);
	MLPAPI int WINAPI MlpPageToPictDataW(int pageNumber, int dpi, int quality, const wchar_t* outputFormat, unsigned long long* length, unsigned char** datap);
	MLPAPI int WINAPI MlpPageToPictDataA(int pageNumber, int dpi, int quality, const char* outputFormat, unsigned long long* length, unsigned char** datap);
	MLPAPI int WINAPI MlpCreatePictW(int pageNumber, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpCreatePictA(int pageNumber, const char* outputFilePath);
	MLPAPI int WINAPI MlpCreatePictDataW(int pageNumber, const wchar_t* outputFormat, unsigned long long* len, unsigned char** datap);
	MLPAPI int WINAPI MlpCreatePictDataA(int pageNumber, const char* outputFormat, unsigned long long* len, unsigned char** datap);
	MLPAPI int WINAPI MlpConvertToTiffW(const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpConvertToTiffA(const char* outputFilePath);
	MLPAPI int WINAPI MlpCreateTiffRangeW(int startPageNumber, int endPageNumber, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpCreateTiffRangeA(int startPageNumber, int endPageNumber, const char* outputFilePath);
	MLPAPI int WINAPI MlpCreateTiffMultiW(const wchar_t* pageList, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpCreateTiffMultiA(const char* pageList, const char* outputFilePath);
	MLPAPI int WINAPI MlpRangeToTiffW(int startPageNumber, int endPageNumber, int dpi, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpRangeToTiffA(int startPageNumber, int endPageNumber, int dpi, const char* outputFilePath);
	MLPAPI int WINAPI MlpPageRangeToTiffW(int startPageNumber, int endPageNumber, int dpi, int quality, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpPageRangeToTiffA(int startPageNumber, int endPageNumber, int dpi, int quality, const char* outputFilePath);
	MLPAPI int WINAPI MlpMultiPageToTiffW(const wchar_t* pageList, int dpi, const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpMultiPageToTiffA(const char* pageList, int dpi, const char* outputFilePath);
	MLPAPI int WINAPI MlpCreateAllToTiffW(const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpCreateAllToTiffA(const char* outputFilePath);
	MLPAPI int WINAPI MlpCreateAllToPictW(const wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpCreateAllToPictA(const char* outputFilePath);

	/*ラスタライズドPDF*/
	MLPAPI int WINAPI MlpCreatePDFW(int pageNumber, int img_dpi, int img_quality, wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpCreatePDFA(int pageNumber, int img_dpi, int img_quality, char* outputFilePath);
	MLPAPI int WINAPI MlpCreatePDFFileW(int img_dpi, int img_quality, wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpCreatePDFFileA(int img_dpi, int img_quality, char* outputFilePath);
	MLPAPI int WINAPI MlpCreatePDFArrayW(int* arry_page, int arry_len, int img_dpi, int img_quality, wchar_t* outputFilePpath);
	MLPAPI int WINAPI MlpCreatePDFArrayA(int* arry_page, int arry_len, int img_dpi, int img_quality, char* outputFilePpath);
	MLPAPI int WINAPI MlpAppendToPDFW(int pageNumber, int img_dpi, int img_quality, wchar_t* outputFilePath);
	MLPAPI int WINAPI MlpAppendToPDFA(int pageNumber, int img_dpi, int img_quality, char* outputFilePath);

	/*パネル*/
	MLPAPI int WINAPI MlpCreatePanel(int width, int height, int colorspace);
	MLPAPI int WINAPI MlpClearPanel();
	MLPAPI int WINAPI MlpFreePanel();
	MLPAPI int WINAPI MlpPanelToFileW(const wchar_t* filePath);
	MLPAPI int WINAPI MlpPanelToFileA(const char* filePath);
	MLPAPI int WINAPI MlpMemPictToPanel(int x, int y, float alpha);
	MLPAPI int WINAPI MlpMemPictToPanelBBox(int panel_xpos, int panel_ypos, float alpha, int bbox_xpos, int bbox_ypos, int bbox_width, int bbox_height);
	MLPAPI int WINAPI MlpPaintRectToPanel(int xpos, int ypos, int width, int height, int lineWidth, unsigned char* color);
	MLPAPI int WINAPI MlpPaintRectToPanel_2W(int xpos, int ypos, int width, int height, int lineWidth, wchar_t* color);
	MLPAPI int WINAPI MlpPaintRectToPanel_2A(int xpos, int ypos, int width, int height, int lineWidth, char* color);

	/*画像データ化*/
	MLPAPI int WINAPI MlpCreatePictBufPage(int pageNumber, unsigned char** pixels, int* width, int* height, int* nOfColors);
	MLPAPI int WINAPI MlpCreatePictBufPageRange(int firstPageNumber, int lastPageNumber);
	MLPAPI int WINAPI MlpCreatePictBufPageArray(int PageNumberArray[], int length);
	MLPAPI int WINAPI MlpCreatePictMem(int pageNumber);

	/*画像データ取得と開放*/
	MLPAPI int WINAPI MlpGetPictFromMem(unsigned char** pixels, int* width, int* height, int* nOfColors);
	MLPAPI int WINAPI MlpGetPictFromMemIndex(int index, unsigned char** pixels, int* width, int* height, int* nOfColors, int* pageNumber);
	MLPAPI int WINAPI MlpGetPictFromMemPage(int pageNumber, unsigned char** pixels, int* width, int* height, int* nOfColors);
	MLPAPI int WINAPI MlpFreePictMem();
	//非公開
	MLPAPI int WINAPI MlpGetPictSizeFromMemIndex(int index, size_t* size);
	MLPAPI int WINAPI MlpGetPictSizeFromMemPage(int pageNumber, size_t* size);
	MLPAPI int WINAPI MlpGetPictFromMemIndexWithSize(int index, unsigned char* pixels, size_t size, int* w, int* h, int* n, int* pageNumber);
	MLPAPI int WINAPI MlpGetPictFromMemPageWithSize(int pageNumber, unsigned char* pixels, size_t size, int* w, int* h, int* n);
	MLPAPI void WINAPI MlpUnlock();

	/*スタンプ*/
	MLPAPI int WINAPI MlpSetStampFileA(char *filePath);
	MLPAPI int WINAPI MlpSetStampFileW(wchar_t *filePath);
	MLPAPI int WINAPI MlpSetStampDataA(char* data, unsigned int length);
	MLPAPI int WINAPI MlpSetStampDataW(wchar_t* data, unsigned int length);
	MLPAPI int WINAPI MlpPaintStamp();
	MLPAPI int WINAPI MlpPaintStampFileA(char *filePath);
	MLPAPI int WINAPI MlpPaintStampFileW(wchar_t *filePath);
	MLPAPI int WINAPI MlpPaintStampDataA(char* data, unsigned int length);
	MLPAPI int WINAPI MlpPaintStampDataW(wchar_t* data, unsigned int length);
	MLPAPI int WINAPI MlpSetStampSingleFileA(char *filePath);
	MLPAPI int WINAPI MlpSetStampSingleFileW(wchar_t *filePath);
	MLPAPI int WINAPI MlpSetStampSingleDataA(char* data, unsigned int length);
	MLPAPI int WINAPI MlpSetStampSingleDataW(wchar_t* data, unsigned int length);
	MLPAPI int WINAPI MlpPaintStampSinglFileA(char *filePath);
	MLPAPI int WINAPI MlpPaintStampSinglFileW(wchar_t *filePath);
	MLPAPI int WINAPI MlpPaintStampSinglDataA(char* data, unsigned int length);
	MLPAPI int WINAPI MlpPaintStampSinglDataW(wchar_t* data, unsigned int length);
	MLPAPI int WINAPI MlpPaintStampNameA(char *id);
	MLPAPI int WINAPI MlpPaintStampNameW(wchar_t *id);
	MLPAPI int WINAPI MlpPaintStampNamePosA(char *id, float x_pos, float y_pos);
	MLPAPI int WINAPI MlpPaintStampNamePosW(wchar_t *id, float x_pos, float y_pos);
	MLPAPI int WINAPI MlpResetStamp();

	/*スタンプ インターフェース*/
	MLPAPI STAMP_HANDLE WINAPI MlpGetStampInterface();
	MLPAPI void WINAPI StmCloseInterface(STAMP_HANDLE);
	MLPAPI void WINAPI StmFinishInterface(STAMP_HANDLE);

	MLPAPI int WINAPI StmSetStampFileA(STAMP_HANDLE, char* stampFilePath);
	MLPAPI int WINAPI StmSetStampFileW(STAMP_HANDLE, wchar_t* stampFileName);
	MLPAPI int WINAPI StmSetStampDataA(STAMP_HANDLE, char* stampData, unsigned int dataLength);
	MLPAPI int WINAPI StmSetStampDataW(STAMP_HANDLE h, wchar_t* stampData, unsigned int dataLength);
	MLPAPI int WINAPI StmPaintStamp(STAMP_HANDLE);
	MLPAPI int WINAPI StmPaintStampFileA(STAMP_HANDLE, char* stampFileName);
	MLPAPI int WINAPI StmPaintStampFileW(STAMP_HANDLE, wchar_t* stampFileName);
	MLPAPI int WINAPI StmPaintStampDataA(STAMP_HANDLE, char* stampData, unsigned int dataLength);
	MLPAPI int WINAPI StmPaintStampDataW(STAMP_HANDLE, wchar_t* stampData, unsigned int dataLength);
	MLPAPI int WINAPI StmPaintStampNameA(STAMP_HANDLE, char* stampId);
	MLPAPI int WINAPI StmPaintStampNameW(STAMP_HANDLE, wchar_t* stampId);
	MLPAPI int WINAPI StmPaintStampNamePosA(STAMP_HANDLE, char* stampId, float x_pos, float y_pos);
	MLPAPI int WINAPI StmPaintStampNamePosW(STAMP_HANDLE, wchar_t* stampId, float x_pos, float y_pos);
	MLPAPI int WINAPI StmResetStamp(STAMP_HANDLE);
	MLPAPI int WINAPI StmDocumentToFileA(STAMP_HANDLE, char* outputFilePath);
	MLPAPI int WINAPI StmDocumentToFileW(STAMP_HANDLE, wchar_t* outputFilePath);

	/*PDFデータ*/
	MLPAPI int WINAPI MlpRemoveMetadata();
	MLPAPI int WINAPI MlpSavePDFA(char *filePath);
	MLPAPI int WINAPI MlpSavePDFW(wchar_t *filePath);
	MLPAPI int WINAPI MlpInsertPage(int at, float width, float height, int rotate);
	MLPAPI int WINAPI MlpRemovePage(int pageNumber);

	/*PDF表示*/
	MLPAPI int WINAPI MlpSetDisplayTitleFlag(BOOL flag);
	MLPAPI int WINAPI MlpGetDisplayTitleFlag(BOOL* flag);
	MLPAPI int WINAPI MlpDeleteDisplayTitleFlag();
	MLPAPI int WINAPI MlpSetFitWindowFlag(BOOL flag);
	MLPAPI int WINAPI MlpDeleteFitWindowFlag();

	/*画像関連*/
	MLPAPI int WINAPI MlpCreatePngFromPixels(unsigned char* pixels, int width, int height, int nOfColors, char* outputFilePath);
	MLPAPI int WINAPI MlpCreatePictFromMemPage(int pageNumber, char* outputFilePath);

#endif

#ifdef	__cplusplus
}
#endif

#endif /*STRUCTURE_H*/
