﻿/*
 *	XMP Constants
 *   "XMP Toolkit"に含まれる"XMP_Const.h"の部分
 */

// =================================================================================================
// Copyright 2002 Adobe
// All Rights Reserved.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// =================================================================================================

#ifndef XMP_CONSTANTS_H
#define XMP_CONSTANTS_H

#include <tchar.h>

// =================================================================================================
// Standard namespace URI constants
// ================================

// XML namespace constants for standard XMP schema.
#define kXMP_NS_XMP        _T("http://ns.adobe.com/xap/1.0/")

#define kXMP_NS_XMP_Rights _T("http://ns.adobe.com/xap/1.0/rights/")
#define kXMP_NS_XMP_MM     _T("http://ns.adobe.com/xap/1.0/mm/")
#define kXMP_NS_XMP_BJ     _T("http://ns.adobe.com/xap/1.0/bj/")

#define kXMP_NS_PDF        _T("http://ns.adobe.com/pdf/1.3/")
#define kXMP_NS_Photoshop  _T("http://ns.adobe.com/photoshop/1.0/")
#define kXMP_NS_PSAlbum    _T("http://ns.adobe.com/album/1.0/")
#define kXMP_NS_EXIF       _T("http://ns.adobe.com/exif/1.0/")
#define kXMP_NS_EXIF_Aux   _T("http://ns.adobe.com/exif/1.0/aux/")
#define kXMP_NS_TIFF       _T("http://ns.adobe.com/tiff/1.0/")
#define kXMP_NS_PNG        _T("http://ns.adobe.com/png/1.0/")
#define kXMP_NS_SWF        _T("http://ns.adobe.com/swf/1.0/")
#define kXMP_NS_JPEG       _T("http://ns.adobe.com/jpeg/1.0/")
#define kXMP_NS_JP2K       _T("http://ns.adobe.com/jp2k/1.0/")
#define kXMP_NS_CameraRaw  _T("http://ns.adobe.com/camera-raw-settings/1.0/")
#define kXMP_NS_DM         _T("http://ns.adobe.com/xmp/1.0/DynamicMedia/")
#define kXMP_NS_Script     _T("http://ns.adobe.com/xmp/1.0/Script/")
#define kXMP_NS_ASF        _T("http://ns.adobe.com/asf/1.0/")
#define kXMP_NS_WAV        _T("http://ns.adobe.com/xmp/wav/1.0/")
#define kXMP_NS_BWF        _T("http://ns.adobe.com/bwf/bext/1.0/")
#define kXMP_NS_AEScart    _T("http://ns.adobe.com/aes/cart/")
#define kXMP_NS_RIFFINFO   _T("http://ns.adobe.com/riff/info/")
#define kXMP_NS_iXML       _T("http://ns.adobe.com/ixml/1.0/")
#define kXMP_NS_XMP_Note   _T("http://ns.adobe.com/xmp/note/")

#define kXMP_NS_AdobeStockPhoto _T("http://ns.adobe.com/StockPhoto/1.0/")
#define kXMP_NS_CreatorAtom _T("http://ns.adobe.com/creatorAtom/1.0/")

#define kXMP_NS_ExifEX		_T("http://cipa.jp/exif/1.0/")

// XML namespace constants for qualifiers and structured property fields.
#define kXMP_NS_XMP_IdentifierQual _T("http://ns.adobe.com/xmp/Identifier/qual/1.0/")
#define kXMP_NS_XMP_Dimensions     _T("http://ns.adobe.com/xap/1.0/sType/Dimensions#")
#define kXMP_NS_XMP_Text           _T("http://ns.adobe.com/xap/1.0/t/")
#define kXMP_NS_XMP_PagedFile      _T("http://ns.adobe.com/xap/1.0/t/pg/")
#define kXMP_NS_XMP_Graphics       _T("http://ns.adobe.com/xap/1.0/g/")
#define kXMP_NS_XMP_Image          _T("http://ns.adobe.com/xap/1.0/g/img/")
#define kXMP_NS_XMP_Font           _T("http://ns.adobe.com/xap/1.0/sType/Font#")
#define kXMP_NS_XMP_ResourceEvent  _T("http://ns.adobe.com/xap/1.0/sType/ResourceEvent#")
#define kXMP_NS_XMP_ResourceRef    _T("http://ns.adobe.com/xap/1.0/sType/ResourceRef#")
#define kXMP_NS_XMP_ST_Version     _T("http://ns.adobe.com/xap/1.0/sType/Version#")
#define kXMP_NS_XMP_ST_Job         _T("http://ns.adobe.com/xap/1.0/sType/Job#")
#define kXMP_NS_XMP_ManifestItem   _T("http://ns.adobe.com/xap/1.0/sType/ManifestItem#")

// Deprecated XML namespace constants
#define kXMP_NS_XMP_T     _T("http://ns.adobe.com/xap/1.0/t/")
#define kXMP_NS_XMP_T_PG  _T("http://ns.adobe.com/xap/1.0/t/pg/")
#define kXMP_NS_XMP_G_IMG _T("http://ns.adobe.com/xap/1.0/g/img/")

// XML namespace constants from outside Adobe.
#define kXMP_NS_DC             _T("http://purl.org/dc/elements/1.1/")

#define kXMP_NS_IPTCCore       _T("http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/")
#define kXMP_NS_IPTCExt        _T("http://iptc.org/std/Iptc4xmpExt/2008-02-29/")

#define kXMP_NS_DICOM          _T("http://ns.adobe.com/DICOM/")

#define kXMP_NS_PLUS           _T("http://ns.useplus.org/ldf/xmp/1.0/")

#define kXMP_NS_PDFA_Schema    _T("http://www.aiim.org/pdfa/ns/schema#")
#define kXMP_NS_PDFA_Property  _T("http://www.aiim.org/pdfa/ns/property#")
#define kXMP_NS_PDFA_Type      _T("http://www.aiim.org/pdfa/ns/type#")
#define kXMP_NS_PDFA_Field     _T("http://www.aiim.org/pdfa/ns/field#")
#define kXMP_NS_PDFA_ID        _T("http://www.aiim.org/pdfa/ns/id/")
#define kXMP_NS_PDFA_Extension _T("http://www.aiim.org/pdfa/ns/extension/")

#define kXMP_NS_PDFX           _T("http://ns.adobe.com/pdfx/1.3/")
#define	kXMP_NS_PDFX_ID        _T("http://www.npes.org/pdfx/ns/id/")

#define kXMP_NS_RDF            _T("http://www.w3.org/1999/02/22-rdf-syntax-ns#")
#define kXMP_NS_XML            _T("http://www.w3.org/XML/1998/namespace")

#endif /*XMP_CONSTANTS_H*/
