﻿//
//	PDF Structure
//	Metadata sample code
//
/*
Copyright(c) 2026 株式会社トラスト・ソフトウェア・システム, All Rights Reserved.
*/

using PDFTools.PdfStructure;
using PDFTools.PdfStructure.Constants;

try
{
	// PDF Structure初期化
	//	ライセンスキーを指定せずにも一定期間利用できますが、
	//	期間後は試用版または正規ライセンスキーを指定してください。
	using(var stc = new Structure())
	{
		//入力PDF
		if (0 != stc.OpenDoc("../../../../../../resources/hello.pdf")) {
			Console.WriteLine("PDFを読み込めません");
			return;
		}
		else
		{
			//メタデータ インターフェース開始
			XmpInterface xmp = stc.GetXmpInterface();

			//タイトル
			xmp.ReplaceTitle("文書のタイトル");

			//作成者
			xmp.ReplaceCreator("文書の作成者");

			//キーワード
			xmp.ReplaceKeywords("キーワード１,キーワード ２");  //	//複数のキーワードを指定できる

			//日本語と英語の詳細(サブタイトル)
			xmp.ReplaceDescription("ja-JP", "詳細");
			xmp.SetDescription("en", "Description");

			//日本語と英語の著作権
			xmp.ReplaceRights("ja-JP", "Copyright © 20xx 著作権者");
			xmp.SetRights("en", "Copyright © 20xx copyright_holder");
			xmp.ReplaceRightsWebStatement("https://www.sample.com/");
			xmp.ReplaceRightsMarked(false);
//					xmp.ReplaceOmitMarked();

			//メタデータ更新
			xmp.UpdateDocument();

			//メタデータ インターフェース終了
			xmp.CloseInterface();

			//PDF保存
			stc.SavePDF("out.pdf");
		}
	}
}
catch (Exception e)
{
	Console.WriteLine("初期化できません:{0}",e.Message);
}
