﻿//
// メタデータテスト
//

using PDFTools.PdfStructure;
using PDFTools.PdfStructure.Constants;

try
{
    // PDF Structure初期化
    //	ライセンスキーを指定せずにも一定期間利用できますが、
    //	期間後は試用版または正規ライセンスキーを指定してください。
    using (var stc = new Structure())
	{
		//オープン
		stc.OpenDoc("../../../../../../resources/hello.pdf");

		// XMPインターフェース
		XmpInterface xmp = stc.GetXmpInterface();

		string dir = "GET";

		//Simpleプロパティ
		string prop = "Rating";
		if (0 >= xmp.DoesSimplePropertyExist(kXMP_NS.XMP, prop))
		{
			dir = "SET";
			xmp.SetSimpleProperty(kXMP_NS.XMP, prop, "3");
		}
		Console.WriteLine($"{dir}: {prop} = {xmp.GetSimpleProperty(kXMP_NS.XMP, prop)}");

		//Structureプロパティ
		dir = "GET";
		prop = "MaxPageSize";
		if (0 >= xmp.DoesStructPropertyExist(kXMP_NS.XMP_T_PG, prop))
		{
			dir = "SET";
			xmp.SetStructField(kXMP_NS.XMP_T_PG, prop, kXMP_NS.XMP_Dimensions, "h", "297");
			xmp.SetStructField(kXMP_NS.XMP_T_PG, prop, kXMP_NS.XMP_Dimensions, "w", "210");
			xmp.SetStructField(kXMP_NS.XMP_T_PG, prop, kXMP_NS.XMP_Dimensions, "unit", "mm");
		}
		Console.WriteLine($"{dir}: {prop}[h] = {xmp.GetStructField(kXMP_NS.XMP_T_PG, prop, kXMP_NS.XMP_Dimensions, "h")}");
		Console.WriteLine($"{dir}: {prop}[w] = {xmp.GetStructField(kXMP_NS.XMP_T_PG, prop, kXMP_NS.XMP_Dimensions, "w")}");
		Console.WriteLine($"{dir}: {prop}[unit] = {xmp.GetStructField(kXMP_NS.XMP_T_PG, prop, kXMP_NS.XMP_Dimensions, "unit")}");

		//Array(Ordered)プロパティ
		dir = "GET";
		prop = "ordered-subject";
		string[] val = { "XMP", "metadata", "PDF Metadata" };
		if (0 >= xmp.DoesArrayPropertyExist(kXMP_NS.XMP_T_PG, prop))
		{
			dir = "SET";
			for (int i = 0; i < val.Length; i++)
				xmp.AppendArrayItem(kXMP_NS.DC, prop, kXMP_Prop.ArrayIsOrdered, val[i]);
		}
		int cnt = xmp.CountArrayItems(kXMP_NS.DC, prop);
		for (int i = 1; i <= cnt; i++)
			Console.WriteLine($"{dir}: {prop}[{i}] = {xmp.GetArrayItem(kXMP_NS.DC, prop, i)}");

		//Array(Unrdered)プロパティ
		dir = "GET";
		prop = "unordered-subject";
		if (0 >= xmp.DoesArrayPropertyExist(kXMP_NS.XMP_T_PG, prop))
		{
			dir = "SET";
			for (int i = 0; i < val.Length; i++)
				xmp.AppendArrayItem(kXMP_NS.DC, prop, kXMP_Prop.ArrayIsUnordered, val[i]);
		}
		cnt = xmp.CountArrayItems(kXMP_NS.DC, prop);
		for (int i = 1; i <= cnt; i++)
			Console.WriteLine($"{dir}: {prop}[{i}] = {xmp.GetArrayItem(kXMP_NS.DC, prop, i)}");

		//Array(Alternate)プロパティ
		Alt_lang[] alt_Langs = {
			new Alt_lang { Gene = "", Spec = "ja-JP", Value = "サブジェクト" },
			new Alt_lang { Gene = "", Spec = "en", Value = "Subject" },
		};
		prop = "alternate-subject";
		if (0 >= xmp.DoesArrayPropertyExist(kXMP_NS.DC, prop))
		{
			dir = "SET";
			xmp.CreateAlternateArrayProperty(kXMP_NS.DC, prop);
			cnt = alt_Langs.Length;
			for (int i = 0; i < cnt; i++)
				xmp.SetLocalizedText(kXMP_NS.DC, prop, alt_Langs[i].Gene, alt_Langs[i].Spec, alt_Langs[i].Value);
		}
		else dir = "GET";

		string[] lang = { "x-default", "ja-JP", "en" };
		string actualLang, value;
		long opts;
		cnt = lang.Length;
		xmp.GetProperty(kXMP_NS.DC, prop, out opts);
		if (XMP_Macro.ArrayIsAlternate(opts))
			for (int i = 0; i < cnt; i++)
			{
				xmp.GetLocalizedText(kXMP_NS.DC, prop, null, lang[i], out actualLang, out value, out opts);
				Console.WriteLine($"{lang[i]}({actualLang}): {value}");
			}
		else
			for (int i = 1; i <= cnt; i++)
				Console.WriteLine($"{dir}: {prop}[{i}] = {xmp.GetArrayItem(kXMP_NS.DC, prop, i)}");

		//PDF出力
		stc.SavePDF("../../../out.pdf");

		//インターフェース終了
		xmp.CloseInterface();

		//終了
		stc.Uninitialize();
	}
}
catch (Exception e)
{
	Console.WriteLine("初期化できません:{0}",e.Message);
}

public struct Alt_lang {
	Alt_lang(string s, string v) { Gene = "";Spec = s;Value = v; }
	public string Gene;
	public string Spec;
	public string Value;
}
