﻿//
//  PDF Structure
//  Sign sample code
//
/*
Copyright(c) 2026 株式会社トラスト・ソフトウェア・システム, All Rights Reserved.
*/

using System;
using System.Security.Cryptography.X509Certificates;
using PDFTools.PdfStructure;
using PDFTools.PdfStructure.Security;
using PDFTools.PdfStructure.Security.Misc;

namespace Sign
{
    class Sign
    {
        static void Main(string[] args)
        {
            //初期化
            using(var stc=new Structure())
            {
                //PDFファイルオープン
                stc.OpenDoc("../../../../../../resources/hello.pdf");

                //Securityインターフェース取得
                var sec = stc.GetSecurityInterface();

                //証明書選択
                sec.SetSignerCertificate("CN=CommnName");

                //タイムスタンプ（省略可）
#if true
                sec.TimestampAuthority = "http://tsa.trustss.jp/";
#endif

                //出力フィル指定
                sec.SetOutputFileName("out.pdf");

                //電子署名と格納（Securityインターフェース終了）
                sec.SignCloseInterface();
            }
        }
    }
}
