﻿//
//  PDF Structure
//  Timestamp sample code
//
/*
Copyright(c) 2026 株式会社トラスト・ソフトウェア・システム, All Rights Reserved.
*/

using System;
using System.Security.Cryptography.X509Certificates;
using PDFTools.PdfStructure;
using PDFTools.PdfStructure.Security;
using PDFTools.PdfStructure.Security.Misc;

namespace Timestamp
{
    class Timestamp
    {
        static void Main(string[] args)
        {
            //初期化
            using (var stc = new Structure())
            {
                // オープン
                stc.OpenDoc("../../../../../resources/hello.pdf");

                //Securityインターフェース取得
                var sec = stc.GetSecurityInterface();

                //検証結果取得（省略可）
#if false
                //  オープンしたPDFファイルに署名やタイムスタンプがある場合
                //  その検証結果を取得できます
                var validated = sec.GetHierarcyInformation();
#endif

                //タイムスタンプ局指定
                sec.TimeStamp = "http://tsa.trustss.jp/";

                //出力ファイル指定
                sec.SetOutputFileName("out.pdf");

                //電子署名と格納（Securityインターフェース終了）
                sec.SignCloseInterface();
            }
        }
    }
}
