﻿/*
**	SetMetadata.c
*
*/
/*Copyright © 2026 株式会社トラスト・ソフトウェア・システム*/

#include <stdio.h>
#include <tchar.h>
#include <Structure.h>
#include <StcError.h>
#include <XMP_Constants.h>
#include <XMP_PropertyOptionBit.h>

#pragma comment(lib, "PdfStructure.lib")

int main()
{
	// 初期化
	//	ライセンスキーを指定せずにも一定期間利用できますが、
	//	期間後は試用版または正規ライセンスキーを指定してください。
	if (MlpInitialize(NULL))
	{
		printf("MlpInitialize error\n");
		return -1;
	}


	// 入力PDFオープン
	if (MlpOpenDoc(_T("../../../resources/hello.pdf"), NULL))
		printf("MlpOpenDoc error\n");
	else {
		// メタデータ インターフェースを開始
		XMP_HANDLE h;
		if (h = MlpGetXmpInterface()) {
			//「タイトル」メタデータを変更
			XmpReplaceTitle(h, NULL, NULL, _T("文書のタイトル"));

			//「作成者」メタデータを変更
			XmpReplaceCreator(h, _T("文書の作成者"));

			// 日本語と英語の「詳細(サブタイトル)」メタデータに変更
			XmpReplaceDescription(h, NULL, _T("ja-JP"), _T("詳細"));	//既定の言語になる
			XmpSetDescription(h, NULL, _T("en"), _T("Description"));

			//「キーワード」メタデータを変更
			XmpReplaceKeywords(h, _T("キーワード1,キーワード 2"));	//複数のキーワードを指定できる

			// 日本語と英語の「著作権」メタデータに変更
			XmpReplaceRights(h, NULL, _T("ja-JP"), _T("Copyright © 20xx 著作権者"));
			XmpSetRights(h, NULL, _T("en"), _T("Copyright © 20xx copyright_holder"));
			XmpReplaceRightsWebStatement(h, _T("https://www.sample.com/"));
			XmpReplaceRightsMarked(h, FALSE);
//			XmpOmitRightsMarked(h);

			// 変更したメタデータでPDFを更新
			XmpUpdateDocument(h);

			// メタデータ インターフェースを終了
			XmpCloseInterface(h);

			// PDF文書をファイルに格納
			MlpSavePDF(_T("out.pdf"));
		}
	}

	/*終了*/
	MlpUninitialize();
}
