﻿/*
**	MetadataProperty
*/
/*Copyright © 2026 株式会社トラスト・ソフトウェア・システム*/

#include <locale.h>
#include <stdio.h>
#include <tchar.h>
#include <Structure.h>
#include <StcError.h>
#include <XMP_Constants.h>
#include <XMP_PropertyOptionBit.h>

#pragma comment(lib, "PdfStructure.lib")

int main()
{
	setlocale(LC_ALL, "Japanese");

	//初期化
	//	ライセンスキーを指定せずにも一定期間利用できますが、
	//	期間後は試用版または正規ライセンスキーを指定してください。
	if(MlpInitialize(NULL))
	{
		printf("MlpInitialize error\n");
		return -1;
	}

	// 入力PDFオープン
	if (MlpOpenDoc(_T("../../../resources/hello.pdf"), NULL))
		printf("MlpOpenDoc error\n");
	else {
		//XMPインターフェース
		XMP_HANDLE h = MlpGetXmpInterface();

		TCHAR* dir;

		//Simpleプロパティ
		TCHAR* prop = _T("Rating");
		TCHAR* val;
		if (!XmpDoesSimplePropertyExist(h, kXMP_NS_XMP, prop)) {
			dir = _T("SET");
			val = _T("3");
			XmpSetSimpleProperty(h, kXMP_NS_XMP, prop, val);
		}
		else dir = _T("GET");
		XmpGetSimpleProperty(h, kXMP_NS_XMP, prop, &val);
		_tprintf(_T("%s: %s = %s\n"), dir, prop, val);

		//Structureプロパティ
		prop = _T("MaxPageSize");
		if (!XmpDoesStructPropertyExist(h, kXMP_NS_XMP_T_PG, prop)) {
			dir = _T("SET");
			XmpSetStructField(h, kXMP_NS_XMP_T_PG, prop, kXMP_NS_XMP_Dimensions, _T("h"), _T("297"));
			XmpSetStructField(h, kXMP_NS_XMP_T_PG, prop, kXMP_NS_XMP_Dimensions, _T("w"), _T("210"));
			XmpSetStructField(h, kXMP_NS_XMP_T_PG, prop, kXMP_NS_XMP_Dimensions, _T("unit"), _T("mm"));
		}
		else dir = _T("GET");
		TCHAR* height, * width, * unit;
		XmpGetStructField(h, kXMP_NS_XMP_T_PG, prop, kXMP_NS_XMP_Dimensions, _T("h"), &height);
		_tprintf(_T("%s: %s[h] = %s, "), dir, prop, height);
		XmpGetStructField(h, kXMP_NS_XMP_T_PG, prop, kXMP_NS_XMP_Dimensions, _T("w"), &width);
		_tprintf(_T("%s[w] = %s, "), prop, width);
		XmpGetStructField(h, kXMP_NS_XMP_T_PG, prop, kXMP_NS_XMP_Dimensions, _T("unit"), &unit);
		_tprintf(_T("%s[unit] = %s\n"), prop, unit);

		//Array順序付きプロパティ
		prop = _T("OrderedSubject");
		int cnt;
		if (!XmpDoesArrayPropertyExist(h, kXMP_NS_DC, prop)) {
			dir = _T("SET");
			TCHAR* val[] = { _T("XMP"),_T("metadata"),_T("PDF Metadata") };
			cnt = sizeof(val) / sizeof(TCHAR*);
			for (int i = 0; i < cnt; i++) {
				XmpAppendArrayItem(h, kXMP_NS_DC, prop, kXMP_PropArrayIsOrdered, val[i]);
			}
		}
		else dir = _T("GET");
		cnt = XmpCountArrayItems(h, kXMP_NS_DC, prop);
		for (int i = 1; i <= cnt; i++) {
			XmpGetArrayItem(h, kXMP_NS_DC, prop, i, &val);
			_tprintf(_T("%s: %s[%d] = %s\n"), dir, prop, i, val);
		}

		//Array順序無しプロパティ
		prop = _T("UnorderedSubject");
		if (!XmpDoesArrayPropertyExist(h, kXMP_NS_DC, prop)) {
			dir = _T("SET");
			TCHAR* val[3] = { _T("XMP"),_T("metadata"),_T("PDF Metadata") };
			cnt = sizeof(val) / sizeof(TCHAR*);
			for (int i = 0; i < cnt; i++)
				XmpAppendArrayItem(h, kXMP_NS_DC, prop, kXMP_PropArrayIsUnordered, val[i]);
		}
		else dir = _T("GET");
		cnt = XmpCountArrayItems(h, kXMP_NS_DC, prop);
		for (int i = 1; i <= cnt; i++) {
			XmpGetArrayItem(h, kXMP_NS_DC, prop, i, &val);
			_tprintf(_T("%s: %s[%d] = %s\n"), dir, prop, i, val);
		}

		struct Alt_lang {
			TCHAR* Gene;
			TCHAR* Spec;
			TCHAR* Value;
		};

		//Array代替プロパティ
		prop = _T("AlternatedSubject");
		if (!XmpDoesArrayPropertyExist(h, kXMP_NS_DC, prop)) {
			dir = _T("SET");
			struct Alt_lang val[] = { {NULL, _T("ja-JP"), _T("サブジェクト")}, {NULL, _T("en"), _T("SUBJECT")} };
			cnt = sizeof(val) / sizeof(struct Alt_lang);
			XmpCreateProperty(h, kXMP_NS_DC, prop, _T(""), kXMP_PropArrayIsAlternate);
//			XmpCreateAlternateArrayPropertyW(h, kXMP_NS_DC, prop);
			for (int i = 0; i < cnt; i++)
				XmpSetLocalizedTextW(h, kXMP_NS_DC, prop, val[i].Gene, val[i].Spec, val[i].Value);
		}
		else dir = _T("GET");
		TCHAR* lang[] = { _T("x-default"), _T("ja-JP"), _T("en")};
		TCHAR* value, *actualLang;
		long opts;
		XmpGetPropertyW(h, kXMP_NS_DC, prop, NULL, &opts);
		cnt = sizeof(lang) / sizeof(TCHAR*);
		if (XMP_ArrayIsAlternate(opts))
			for (int i = 0; i < cnt; i++) {
				XmpGetLocalizedTextW(h, kXMP_NS_DC, prop, NULL, lang[i], &actualLang, &value, NULL);
				_tprintf(_T("[%s]->%s\n"), actualLang, value);
			}
		else {
			for (int i = 1; i <= cnt; i++) {
				XmpGetArrayItem(h, kXMP_NS_DC, prop, i, &val);
				_tprintf(_T(" %s[%d] = %s\n"), prop, i, val);
			}
		}

		//出力
		MlpSavePDF(_T("out.pdf"));

		//クローズ インターフェース
		XmpCloseInterface(h);
	}

	//クローズ PDF
	MlpCloseDoc();

	//後始末
	MlpUninitialize();
}
